<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\backend\master\BrandController;
use App\Http\Controllers\backend\master\MasterController;

use App\Http\Controllers\backend\location\LocationController;
use App\Http\Controllers\backend\service\ServiceController;

use App\Http\Controllers\superadmin\SuperadminController;
use App\Http\Controllers\backend\login\LoginController;
use App\Http\Controllers\backend\adminuser\AdminuserController;
use App\Http\Controllers\backend\email\EmailtemplateController;
use App\Http\Controllers\backend\partner\PartnerController;

use App\Http\Controllers\backend\features\SliderController;
use App\Http\Controllers\backend\features\NewsletterController;
use App\Http\Controllers\backend\features\BlogController;
use App\Http\Controllers\backend\features\PageController;
use App\Http\Controllers\backend\features\ContactController;
use App\Http\Controllers\backend\features\TeamController;
use App\Http\Controllers\backend\features\TestimonialController;
use App\Http\Controllers\backend\features\FaqController;

use App\Http\Controllers\backend\lead\LeadController;
use App\Http\Controllers\backend\product\ProductController;
use App\Http\Controllers\backend\settings\SettingController;
use App\Http\Controllers\backend\promocode\PromocodeController;
use App\Http\Controllers\backend\order\OrderController;
use App\Http\Controllers\backend\users\UsersController;
use App\Http\Controllers\backend\media\MediaController;
use App\Http\Controllers\backend\wallet\WalletManagerController;


use App\Http\Controllers\frontend\FrontendController;
use App\Http\Controllers\frontend\UserController;
use App\Http\Controllers\frontend\CheckoutController;
use App\Http\Controllers\frontend\CartController;
use App\Http\Controllers\frontend\features\ContactusController;
use App\Http\Controllers\frontend\blog\BlogController as FrontendBlogController;
use App\Http\Controllers\frontend\service\ServiceController as FrontendServiceController;
use App\Http\Controllers\frontend\service\ServiceplanController;
use App\Http\Controllers\frontend\login\LoginController as FrontendLoginController;
use App\Http\Controllers\backend\settings\SuperadminsettingsController;

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::post('/slugalreadycheck/', function (Request $request) {
   return  slugalreadycheck($request); 
});

//Location Frontend
Route::get('/windowreloadloation/', function (Request $request) {
   return  windowreloadloation($request); 
});
//Location Admin
Route::get('/statebycity/', function (Request $request) {
   return  statebycity($request); 
});
//Service Admin
Route::get('/subservicebychildservice/', function (Request $request) {
   return  subservicebychildservice($request); 
});
 


Route::prefix('backend')->name('backend.')->group(function(){
    
Route::get('index',[LoginController::class,'index'])->name('index');
//Login Admin
Route::get('login',[LoginController::class,'login'])->name('login');
Route::post('login_process',[LoginController::class,'login_process'])->name('login_process');;
//Otp Admin
Route::get('otpverify', [LoginController::class, 'otpverify'])->name('otpverify');
Route::get('login/otp', [LoginController::class, 'otp'])->name('otp');
Route::post('otpverification',[LoginController::class,'otpverification'])->name('otpverification');
Route::get('login/otpmail', [LoginController::class, 'otpmail'])->name('otpmail');

Route::get('logout', [LoginController::class, 'logout'])->name('logout');

//Forgotpassword
Route::get('forgetpassword', [LoginController::class, 'forgetpassword'])->name('forgetpassword');
Route::post('forgetpasswordcheck', [LoginController::class, 'forgetpasswordcheck'])->name('forgetpasswordcheck');
Route::post('forgotchangepassword', [LoginController::class, 'forgotchangepassword'])->name('forgotchangepassword');


// ****** Master*******//

// Brand
Route::get('master/brands',[BrandController::class,'brands'])->name('brands');
Route::post('brandscreate',[BrandController::class,'brandscreate'])->name('brandscreate');
Route::post('brandsajax',[BrandController::class,'brandsajax'])->name('brandsajax');
Route::post('brandslug',[BrandController::class,'brandslug'])->name('brandslug');
Route::post('brandsstatus',[BrandController::class,'brandsstatus'])->name('brandsstatus');
Route::get('brandsdelete/{id}',[BrandController::class,'brandsdelete'])->name('brandsdelete');
Route::get('brandsedit/{id}',[BrandController::class,'brandsedit'])->name('brandsedit');
Route::post('brandsupdate/{id}',[BrandController::class,'brandsupdate'])->name('brandsupdate');
Route::get('getsubservices', [BrandController::class, 'getsubservices'])->name('getsubservices');

//Status//
Route::get('master/status',[MasterController::class,'status'])->name('status');
Route::post('statuscreate',[MasterController::class,'statuscreate'])->name('statuscreate');
Route::post('statusajax',[MasterController::class,'statusajax'])->name('statusajax');
Route::post('statusstatus',[MasterController::class,'statusstatus'])->name('statusstatus');
Route::get('statusdelete/{id}',[MasterController::class,'statusdelete'])->name('statusdelete');
Route::post('statusupdate',[MasterController::class,'statusupdate'])->name('statusupdate');

//Source//
Route::get('master/source',[MasterController::class,'source'])->name('source');
Route::post('sourcecreate',[MasterController::class,'sourcecreate'])->name('sourcecreate');
Route::post('sourceajax',[MasterController::class,'sourceajax'])->name('sourceajax');
Route::post('sourcestatus',[MasterController::class,'sourcestatus'])->name('sourcestatus');
Route::get('sourcedelete/{id}',[MasterController::class,'sourcedelete'])->name('sourcedelete');
Route::post('sourceupdate',[MasterController::class,'sourceupdate'])->name('sourceupdate');

// ****** Master*******//

//***********Location*********//

//Countries
Route::get('countries',[LocationController::class,'countries'])->name('countries');
Route::post('ajaxcountriesview',[LocationController::class,'ajaxcountriesview'])->name('ajaxcountriesview');
Route::post('countriesstatus',[LocationController::class,'countriesstatus'])->name('countriesstatus');
Route::post('countriesadd',[LocationController::class,'countriesadd'])->name('countriesadd');
Route::post('countriesupdate',[LocationController::class,'countriesupdate'])->name('countriesupdate');
Route::get('countriesdelete/{id}',[LocationController::class,'countriesdelete'])->name('countriesdelete');

//State
Route::get('state',[LocationController::class,'state'])->name('state');
Route::post('ajaxstatessview',[LocationController::class,'ajaxstatessview'])->name('ajaxstatessview');
Route::post('statestatus',[LocationController::class,'statestatus'])->name('statestatus');
Route::post('stateadd',[LocationController::class,'stateadd'])->name('stateadd');
Route::post('stateupdate',[LocationController::class,'stateupdate'])->name('stateupdate');
Route::get('statedelete/{id}',[LocationController::class,'statedelete'])->name('statedelete');

//City
Route::get('cities',[LocationController::class,'cities'])->name('cities');
Route::post('ajaxcitiesview',[LocationController::class,'ajaxcitiesview'])->name('ajaxcitiesview');
Route::post('citiesstatus',[LocationController::class,'citiesstatus'])->name('citiesstatus');
Route::post('cityadd',[LocationController::class,'cityadd'])->name('cityadd');
Route::post('cityupdate',[LocationController::class,'cityupdate'])->name('cityupdate');
Route::get('citydelete/{id}',[LocationController::class,'citydelete'])->name('citydelete');
Route::get('selectstate',[LocationController::class,'selectstate'])->name('selectstate');
Route::get('getCountryByState',[LocationController::class,'getCountryByState'])->name('getCountryByState');

// Pincode //
Route::get('pincode', [LocationController::class, 'pincode'])->name('pincode');
Route::post('pincodecreate', [LocationController::class, 'pincodecreate'])->name('pincodecreate');
Route::post('pincodeajax', [LocationController::class, 'pincodeajax'])->name('pincodeajax');
Route::post('pincodestatus', [LocationController::class, 'pincodestatus'])->name('pincodestatus');
Route::get('pincodedelete/{id}', [LocationController::class, 'pincodedelete'])->name('pincodedelete');
Route::get('pincodeedit/{id}', [LocationController::class, 'pincodeedit'])->name('pincodeedit');
Route::post('pincodeupdate/{id}', [LocationController::class, 'pincodeupdate'])->name('pincodeupdate');

//Store///
Route::get('store', [LocationController::class, 'store'])->name('store');
Route::post('storecreate', [LocationController::class, 'storecreate'])->name('storecreate');
Route::post('storeajax', [LocationController::class, 'storeajax'])->name('storeajax');
Route::post('storestatus', [LocationController::class, 'storestatus'])->name('storestatus');
Route::get('storedelete/{id}', [LocationController::class, 'storedelete'])->name('storedelete');
Route::get('storeedit/{id}', [LocationController::class, 'storeedit'])->name('storeedit');
Route::post('storeupdate/{id}', [LocationController::class, 'storeupdate'])->name('storeupdate');

//***********Location*********//

//***********Service*********//

// Services
Route::get('service/services',[ServiceController::class,'services'])->name('services');
Route::post('servicescreate',[ServiceController::class,'servicescreate'])->name('servicescreate');
Route::post('servicesajax',[ServiceController::class,'servicesajax'])->name('servicesajax');
Route::post('serviceslug',[ServiceController::class,'serviceslug'])->name('serviceslug');
Route::post('servicesstatus',[ServiceController::class,'servicesstatus'])->name('servicesstatus');
Route::get('servicesdelete/{id}',[ServiceController::class,'servicesdelete'])->name('servicesdelete');
Route::get('servicesedit/{id}',[ServiceController::class,'servicesedit'])->name('servicesedit');
Route::post('servicesupdate/{id}',[ServiceController::class,'servicesupdate'])->name('servicesupdate');

//serviceallottedcity
Route::get('serviceallottedcity/{id}',[ServiceController::class,'serviceallottedcity'])->name('serviceallottedcity');
Route::get('serviceallottedcitydelete/{id}',[ServiceController::class,'serviceallottedcitydelete'])->name('serviceallottedcitydelete');
Route::post('serviceallottedcityadd',[ServiceController::class,'serviceallottedcityadd'])->name('serviceallottedcityadd');
Route::post('serviceallottedcityview',[ServiceController::class,'serviceallottedcityview'])->name('serviceallottedcityview');
Route::post('serviceallottedcitystatus',[ServiceController::class,'serviceallottedcitystatus'])->name('serviceallottedcitystatus');
Route::get('serviceallottedcitycountryget',[ServiceController::class,'serviceallottedcitycountryget'])->name('serviceallottedcitycountryget');


//Sub Service
Route::get('service/subservice',[ServiceController::class,'subservice'])->name('subservice');
Route::get('subserviceadd',[ServiceController::class,'subserviceadd'])->name('subserviceadd');
Route::post('subservicecreate',[ServiceController::class,'subservicecreate'])->name('subservicecreate');
Route::post('subserviceajax',[ServiceController::class,'subserviceajax'])->name('subserviceajax');
Route::post('subservicestatus',[ServiceController::class,'subservicestatus'])->name('subservicestatus');
Route::get('subservicedelete/{id}',[ServiceController::class,'subservicedelete'])->name('subservicedelete');
Route::get('subserviceedit/{id}',[ServiceController::class,'subserviceedit'])->name('subserviceedit');
Route::post('subserviceupdate/{id}',[ServiceController::class,'subserviceupdate'])->name('subserviceupdate');
Route::post('subserviceslug',[ServiceController::class,'subserviceslug'])->name('subserviceslug');

//subserviceallottedcity
Route::get('subserviceallottedcity/{id}',[ServiceController::class,'subserviceallottedcity'])->name('subserviceallottedcity');
Route::get('subserviceallottedcitydelete/{id}',[ServiceController::class,'subserviceallottedcitydelete'])->name('subserviceallottedcitydelete');
Route::post('subserviceallottedcityview',[ServiceController::class,'subserviceallottedcityview'])->name('subserviceallottedcityview');
Route::post('subserviceallottedcityadd',[ServiceController::class,'subserviceallottedcityadd'])->name('subserviceallottedcityadd');
Route::get('subservicecountrydata',[ServiceController::class,'subservicecountrydata'])->name('subservicecountrydata');
Route::post('subserviceallottedcitystatus',[ServiceController::class,'subserviceallottedcitystatus'])->name('subserviceallottedcitystatus');


//Child Service
Route::get('service/childservice',[ServiceController::class,'childservice'])->name('childservice');
Route::get('selectservices',[ServiceController::class,'selectservices'])->name('selectservices');
Route::post('childservicescreate',[ServiceController::class,'childservicescreate'])->name('childservicescreate');
Route::post('childservicesajax',[ServiceController::class,'childservicesajax'])->name('childservicesajax');
Route::post('childservicesstatus',[ServiceController::class,'childservicesstatus'])->name('childservicesstatus');
Route::get('childservicesdelete/{id}',[ServiceController::class,'childservicesdelete'])->name('childservicesdelete');
Route::get('childservicesedit/{id}',[ServiceController::class,'childservicesedit'])->name('childservicesedit');
Route::post('childservicesupdate/{id}',[ServiceController::class,'childservicesupdate'])->name('childservicesupdate');
Route::post('childserviceslug',[ServiceController::class,'childserviceslug'])->name('childserviceslug');

//childsubserviceallottedcity
Route::get('childserviceallottedcity/{id}',[ServiceController::class,'childserviceallottedcity'])->name('childserviceallottedcity');
Route::get('childserviceallottedcitydelete/{id}',[ServiceController::class,'childserviceallottedcitydelete'])->name('childserviceallottedcitydelete');
Route::post('deletemultiplecitieschild',[ServiceController::class,'deletemultiplecitieschild'])->name('deletemultiplecitieschild');
Route::post('childserviceallottedcityview',[ServiceController::class,'childserviceallottedcityview'])->name('childserviceallottedcityview');
Route::post('childserviceallottedcityadd',[ServiceController::class,'childserviceallottedcityadd'])->name('childserviceallottedcityadd');
Route::post('childserviceallottedcitystatus',[ServiceController::class,'childserviceallottedcitystatus'])->name('childserviceallottedcitystatus');
Route::get('childservicecountrydata',[ServiceController::class,'childservicecountrydata'])->name('childservicecountrydata');


//Service Plan //
Route::get('service/serviceplan',[ServiceController::class,'serviceplan'])->name('serviceplan');
Route::get('selectallservices',[ServiceController::class,'selectallservices'])->name('selectallservices');
Route::post('serviceplancreate',[ServiceController::class,'serviceplancreate'])->name('serviceplancreate');
Route::post('serviceplanajaxview',[ServiceController::class,'serviceplanajaxview'])->name('serviceplanajaxview');
Route::get('serviceplanadelete/{id}',[ServiceController::class,'serviceplanadelete'])->name('serviceplanadelete');
Route::get('serviceplanaedit/{id}',[ServiceController::class,'serviceplanaedit'])->name('serviceplanaedit');
Route::post('serviceplanupdate/{id}',[ServiceController::class,'serviceplanupdate'])->name('serviceplanupdate');
Route::post('serviceplanslug',[ServiceController::class,'serviceplanslug'])->name('serviceplanslug');
Route::post('serviceplanstatus',[ServiceController::class,'serviceplanstatus'])->name('serviceplanstatus');
Route::get('singleviewserviceplan/{id}',[ServiceController::class,'singleviewserviceplan'])->name('singleviewserviceplan');

//Service Plan Allotted City
Route::get('serviceplanallottedcity/{id}',[ServiceController::class,'serviceplanallottedcity'])->name('serviceplanallottedcity');
Route::get('serviceplancountrydata',[ServiceController::class,'serviceplancountrydata'])->name('serviceplancountrydata');
Route::post('serviceplanallottedcityadd',[ServiceController::class,'serviceplanallottedcityadd'])->name('serviceplanallottedcityadd');
Route::post('serviceplanallottedcityview',[ServiceController::class,'serviceplanallottedcityview'])->name('serviceplanallottedcityview');
Route::get('serviceplanallottedcitydelete/{id}',[ServiceController::class,'serviceplanallottedcitydelete'])->name('serviceplanallottedcitydelete');
Route::post('serviceplanallottedcitystatus',[ServiceController::class,'serviceplanallottedcitystatus'])->name('serviceplanallottedcitystatus');
Route::post('deletemultiplecities', [ServiceController::class, 'deletemultiplecities'])->name('deletemultiplecities');

//***********Service*********//

//***********Web Feature*********//

/// Slider ///
Route::get('features/slider', [SliderController::class, 'slider'])->name('slider');
Route::post('slidercreate', [SliderController::class, 'slidercreate'])->name('slidercreate');
Route::post('sliderajax', [SliderController::class, 'sliderajax'])->name('sliderajax');
Route::post('sliderstatus', [SliderController::class, 'sliderstatus'])->name('sliderstatus');
Route::get('sliderdelete/{id}', [SliderController::class, 'sliderdelete'])->name('sliderdelete');
Route::get('slideredit/{id}', [SliderController::class, 'slideredit'])->name('slideredit');
Route::post('sliderupdate/{id}', [SliderController::class, 'sliderupdate'])->name('sliderupdate');

// Blog //
Route::get('features/blog', [BlogController::class, 'blog'])->name('blog');
Route::post('blogcreate', [BlogController::class, 'blogcreate'])->name('blogcreate');
Route::post('blogajax', [BlogController::class, 'blogajax'])->name('blogajax');
Route::post('blogslug', [ProductController::class, 'blogslug'])->name('blogslug');
Route::post('blogstatus', [BlogController::class, 'blogstatus'])->name('blogstatus');
Route::get('blogdelete/{id}', [BlogController::class, 'blogdelete'])->name('blogdelete');
Route::get('blogedit/{id}', [BlogController::class, 'blogedit'])->name('blogedit');
Route::post('blogupdate/{id}', [BlogController::class, 'blogupdate'])->name('blogupdate');
Route::get('bloggetsubservices', [BlogController::class, 'bloggetsubservices'])->name('bloggetsubservices');

// Pages //
Route::get('features/page', [PageController::class, 'page'])->name('page');
Route::post('pagecreate', [PageController::class, 'pagecreate'])->name('pagecreate');
Route::post('pageajax', [PageController::class, 'pageajax'])->name('pageajax');
Route::get('pageedit/{id}', [PageController::class, 'pageedit'])->name('pageedit');
Route::post('pageupdate/{id}', [PageController::class, 'pageupdate'])->name('pageupdate');
Route::post('pagestatus', [PageController::class, 'pagestatus'])->name('pagestatus');
Route::get('pagedelete/{id}', [PageController::class, 'pagedelete'])->name('pagedelete');

// Contact   
Route::get('features/contact', [ContactController::class, 'contact'])->name('contact');
Route::post('contactajax', [ContactController::class, 'contactajax'])->name('contactajax');
Route::post('contactstatus', [ContactController::class, 'contactstatus'])->name('contactstatus');
Route::get('contactdelete/{id}', [ContactController::class, 'contactdelete'])->name('contactdelete');
Route::post('deletemultiplecontact',[ContactController::class,'deletemultiplecontact'])->name('deletemultiplecontact');

// Team //
Route::get('features/team', [TeamController::class, 'team'])->name('team');
Route::post('teamcreate', [TeamController::class, 'teamcreate'])->name('teamcreate');
Route::post('teamajax', [TeamController::class, 'teamajax'])->name('teamajax');
Route::post('teamstatus', [TeamController::class, 'teamstatus'])->name('teamstatus');
Route::get('teamdelete/{id}', [TeamController::class, 'teamdelete'])->name('teamdelete');
Route::get('teamedit/{id}', [TeamController::class, 'teamedit'])->name('teamedit');
Route::post('teamupdate/{id}', [TeamController::class, 'teamupdate'])->name('teamupdate');

// Testimonial //
Route::get('features/testimonial', [TestimonialController::class, 'testimonial'])->name('testimonial');
Route::post('testimonialcreate', [TestimonialController::class, 'testimonialcreate'])->name('testimonialcreate');
Route::post('testimonialajax', [TestimonialController::class, 'testimonialajax'])->name('testimonialajax');
Route::post('testimonialstatus', [TestimonialController::class, 'testimonialstatus'])->name('testimonialstatus');
Route::get('testimonialdelete/{id}', [TestimonialController::class, 'testimonialdelete'])->name('testimonialdelete');
Route::get('testimonialedit/{id}', [TestimonialController::class, 'testimonialedit'])->name('testimonialedit');
Route::post('testimonialupdate/{id}', [TestimonialController::class, 'testimonialupdate'])->name('testimonialupdate');

// Faq //
Route::get('features/faq', [FaqController::class, 'faq'])->name('faq');
Route::post('faqcreate', [FaqController::class, 'faqcreate'])->name('faqcreate');
Route::post('faqajax', [FaqController::class, 'faqajax'])->name('faqajax');
Route::post('faqstatus', [FaqController::class, 'faqstatus'])->name('faqstatus');
Route::get('faqdelete/{id}', [FaqController::class, 'faqdelete'])->name('faqdelete');
Route::get('faqedit/{id}', [FaqController::class, 'faqedit'])->name('faqedit');
Route::post('faqupdate/{id}', [FaqController::class, 'faqupdate'])->name('faqupdate');

//Newsletter
Route::get('features/newsletter', [NewsletterController::class, 'newsletter'])->name('newsletter');
Route::post('newsletterajax', [NewsletterController::class, 'newsletterajax'])->name('newsletterajax');
Route::post('newsletterstatus', [NewsletterController::class, 'newsletterstatus'])->name('newsletterstatus');
Route::post('deletemultiplecitiesnewsletter', [NewsletterController::class, 'deletemultiplecitiesnewsletter'])->name('deletemultiplecitiesnewsletter');
Route::get('newsletterdelete/{id}', [NewsletterController::class, 'newsletterdelete'])->name('newsletterdelete');

//***********Web Feature*********//

//***********Lead*********//

//Lead
Route::get('lead/lead',[LeadController::class,'lead'])->name('lead');
Route::post('leadscreate',[LeadController::class,'leadscreate'])->name('leadscreate');
Route::get('leadcountrydata',[LeadController::class,'leadcountrydata'])->name('leadcountrydata');
Route::post('leadsajax',[LeadController::class,'leadsajax'])->name('leadsajax');
Route::get('leaddelete/{id}',[LeadController::class,'leaddelete'])->name('leaddelete');
Route::get('leadedit/{id}',[LeadController::class,'leadedit'])->name('leadedit');
Route::post('leadupdate/{id}',[LeadController::class,'leadupdate'])->name('leadupdate');
Route::post('leadstatus',[LeadController::class,'leadstatus'])->name('leadstatus');
Route::get('lead/reminder',[LeadController::class,'reminder'])->name('reminder');

//reminder
Route::post('remindercreate',[LeadController::class,'remindercreate'])->name('remindercreate');
Route::post('reminderajax',[LeadController::class,'reminderajax'])->name('reminderajax');
Route::post('reminderupdate',[LeadController::class,'reminderupdate'])->name('reminderupdate');
Route::post('reminderstatus',[LeadController::class,'reminderstatus'])->name('reminderstatus');
Route::get('reminderdelete/{id}',[LeadController::class,'reminderdelete'])->name('reminderdelete');
Route::get('reminderedit/{id}',[LeadController::class,'reminderedit'])->name('reminderedit');

//Follow Up
Route::post('followup',[LeadController::class,'followup'])->name('followup');
Route::post('followupajax',[LeadController::class,'followupajax'])->name('followupajax');
Route::post('followupstatus',[LeadController::class,'followupstatus'])->name('followupstatus');
Route::post('followupdate',[LeadController::class,'followupdate'])->name('followupdate');
Route::get('followupdelete/{id}',[LeadController::class,'followupdelete'])->name('followupdelete');

//***********Lead*********//



//***********Setting*********//

//Settings
Route::get('settings',[SettingController::class,'settings'])->name('settings');
Route::get('settings/websitesetting',[SettingController::class,'websitesetting'])->name('websitesetting');
Route::post('websitesettingedit',[SettingController::class,'websitesettingedit'])->name('websitesettingedit');
Route::get('getsubserviceshome',[SettingController::class,'getsubserviceshome'])->name('getsubserviceshome');

//tbl_crud_features
Route::get('settings/tbl_crud_features',[SettingController::class,'tbl_crud_features'])->name('tbl_crud_features');

//Role//
Route::get('role',[AdminuserController::class,'role'])->name('role');
Route::post('rolecreate',[AdminuserController::class,'rolecreate'])->name('rolecreate');
Route::post('roleedit',[AdminuserController::class,'roleedit'])->name('roleedit');
Route::post('rolestatus',[AdminuserController::class,'rolestatus'])->name('rolestatus');
Route::post('roleajax',[AdminuserController::class,'roleajax'])->name('roleajax');
Route::get('roledelete/{id}',[AdminuserController::class,'roledelete'])->name('roledelete');
Route::get('permission_denied',[AdminuserController::class,'permission_denied'])->name('permission_denied');

//Additional setting
Route::get('additionalsetting',[SettingController::class,'additionalsetting'])->name('additionalsetting');
Route::post('locationsetting',[SettingController::class,'locationsetting'])->name('locationsetting');
Route::post('additionalsettingupdate/{id}',[SettingController::class,'additionalsettingupdate'])->name('additionalsettingupdate');


//***********Setting*********//


//Admin User
Route::get('adminuser',[AdminuserController::class,'adminuser'])->name('adminuser');
Route::get('adminuseradd',[AdminuserController::class,'adminuseradd'])->name('adminuseradd');
Route::get('adminuserdelete/{id}',[AdminuserController::class,'adminuserdelete'])->name('adminuserdelete');
Route::post('adminusercreate',[AdminuserController::class,'adminusercreate'])->name('adminusercreate');
Route::post('houseajexadminuser',[AdminuserController::class,'houseajexadminuser'])->name('houseajexadminuser');
Route::get('adminuseredit/{id}',[AdminuserController::class,'adminuseredit'])->name('adminuseredit');
Route::post('adminuserupdate/{id}',[AdminuserController::class,'adminuserupdate'])->name('adminuserupdate');
Route::post('adminuserstatus',[AdminuserController::class,'adminuserstatus'])->name('adminuserstatus');
Route::post('imagecheck',[AdminuserController::class,'imagecheck'])->name('imagecheck');
Route::get('admincountrydata',[AdminuserController::class,'admincountrydata'])->name('admincountrydata');

//Email Template
Route::get('email/emailtemplate',[EmailtemplateController::class,'emailtemplate'])->name('emailtemplate');
Route::post('emailtemplateadd',[EmailtemplateController::class,'emailtemplateadd'])->name('emailtemplateadd');
Route::post('emailtemplateviewajax',[EmailtemplateController::class,'emailtemplateviewajax'])->name('emailtemplateviewajax');
Route::post('emailtemplatestatus',[EmailtemplateController::class,'emailtemplatestatus'])->name('emailtemplatestatus');
Route::get('emailtemplatedelete/{id}',[EmailtemplateController::class,'emailtemplatedelete'])->name('emailtemplatedelete');
Route::post('emailtemplateupdate',[EmailtemplateController::class,'emailtemplateupdate'])->name('emailtemplateupdate');
Route::get('emailtemplatepage/{id}',[EmailtemplateController::class,'emailtemplatepage'])->name('emailtemplatepage');

// Partner
Route::get('partner/partner',[PartnerController::class,'partner'])->name('partner');
Route::post('partneradd',[PartnerController::class,'partneradd'])->name('partneradd');
Route::post('partnerviewajax',[PartnerController::class,'partnerviewajax'])->name('partnerviewajax');
Route::post('partnerstatus',[PartnerController::class,'partnerstatus'])->name('partnerstatus');
Route::get('partnerdelete/{id}',[PartnerController::class,'partnerdelete'])->name('partnerdelete');
Route::get('partnersingleview/{id}',[PartnerController::class,'partnersingleview'])->name('partnersingleview');
Route::get('partneredit/{id}',[PartnerController::class,'partneredit'])->name('partneredit');
Route::post('partnerverify',[PartnerController::class,'partnerverify'])->name('partnerverify');
Route::post('partnerupdate/{id}',[PartnerController::class,'partnerupdate'])->name('partnerupdate');




//Product//
Route::get('product/product',[ProductController::class,'product'])->name('product');
Route::post('productcreate', [ProductController::class, 'productcreate'])->name('productcreate');
Route::post('productajax', [ProductController::class, 'productajax'])->name('productajax');
Route::post('productslug', [ProductController::class, 'productslug'])->name('productslug');
Route::post('productstatus', [ProductController::class, 'productstatus'])->name('productstatus');
Route::get('productdelete/{id}', [ProductController::class, 'productdelete'])->name('productdelete');
Route::get('productedit/{id}', [ProductController::class, 'productedit'])->name('productedit');
Route::post('productupdate/{id}', [ProductController::class, 'productupdate'])->name('productupdate');
Route::get('productgetsubservices', [ProductController::class, 'productgetsubservices'])->name('productgetsubservices');
Route::get('productsingleview/{id}',[ProductController::class,'productsingleview'])->name('productsingleview');

//Product Allotted City
Route::get('productallottedcity/{id}',[ProductController::class,'productallottedcity'])->name('productallottedcity');
Route::get('productcountrydata',[ProductController::class,'productcountrydata'])->name('productcountrydata');
Route::post('productallottedcityadd',[ProductController::class,'productallottedcityadd'])->name('productallottedcityadd');
Route::post('productallottedcityview',[ProductController::class,'productallottedcityview'])->name('productallottedcityview');
Route::get('productallottedcitydelete/{id}',[ProductController::class,'productallottedcitydelete'])->name('productallottedcitydelete');
Route::post('productallottedcitystatus',[ProductController::class,'productallottedcitystatus'])->name('productallottedcitystatus');
Route::post('productdeletemultiplecities', [ProductController::class, 'productdeletemultiplecities'])->name('productdeletemultiplecities');





//Promocode///
Route::get('promocode/promocode', [PromocodeController::class, 'promocode'])->name('promocode');
Route::get('promocodestatebycity', [PromocodeController::class, 'promocodestatebycity'])->name('promocodestatebycity');
Route::post('promocodecreate', [PromocodeController::class, 'promocodecreate'])->name('promocodecreate');
Route::post('promocodeajax', [PromocodeController::class, 'promocodeajax'])->name('promocodeajax');
Route::post('promocodestatus', [PromocodeController::class, 'promocodestatus'])->name('promocodestatus');
  Route::get('promocodedelete/{id}', [PromocodeController::class, 'promocodedelete'])->name('promocodedelete');
Route::get('promocodeedit/{id}', [PromocodeController::class, 'promocodeedit'])->name('promocodeedit');
Route::get('promocodeincentive/{id}', [PromocodeController::class, 'promocodeincentive'])->name('promocodeincentive');
Route::get('incentivedelete/{id}', [PromocodeController::class, 'incentivedelete'])->name('incentivedelete');
Route::post('promocodeincentivecreate', [PromocodeController::class, 'promocodeincentivecreate'])->name('promocodeincentivecreate');
Route::post('promocodeupdate/{id}', [PromocodeController::class, 'promocodeupdate'])->name('promocodeupdate');



/// Superadmin Profile ////
Route::get('profile', [SuperadminsettingsController::class, 'profile'])->name('profile');

/// Notifications ////
Route::get('notifications', [SuperadminsettingsController::class, 'notifications'])->name('notifications');
Route::post('notificationstatus', [SuperadminsettingsController::class, 'notificationstatus'])->name('notificationstatus');
Route::post('notificationsajax', [SuperadminsettingsController::class, 'notificationsajax'])->name('notificationsajax');
Route::post('markRead', [SuperadminsettingsController::class, 'markRead'])->name('markRead');
Route::post('markSingleRead', [SuperadminsettingsController::class, 'markSingleRead'])->name('markSingleRead');
Route::get('notificationdelete/{id}', [SuperadminsettingsController::class, 'notificationdelete'])->name('notificationdelete');
Route::post('deletemultiplenotification',[SuperadminsettingsController::class,'deletemultiplenotification'])->name('deletemultiplenotification');

/// Change Password ////
Route::get('changepassword', [SuperadminsettingsController::class, 'changepassword'])->name('changepassword');
Route::post('passwordupdate', [SuperadminsettingsController::class, 'passwordupdate'])->name('passwordupdate');


// Order //
Route::get('order', [OrderController::class, 'order'])->name('order');

// Users //
Route::get('users', [UsersController::class, 'users'])->name('users');
Route::post('usersstatus', [UsersController::class, 'usersstatus'])->name('usersstatus');
Route::get('frontenduseredit/{id}', [UsersController::class, 'frontenduseredit'])->name('frontenduseredit');
Route::post('usersajax', [UsersController::class, 'usersajax'])->name('usersajax');
Route::post('cartusersajax', [UsersController::class, 'cartusersajax'])->name('cartusersajax');
Route::post('userlogsusersajax', [UsersController::class, 'userlogsusersajax'])->name('userlogsusersajax');
Route::post('userupdate/{id}', [UsersController::class, 'userupdate'])->name('userupdate');
Route::post('useraddressajax', [UsersController::class, 'useraddressajax'])->name('useraddressajax');
Route::get('usersingleview/{id}',[UsersController::class,'usersingleview'])->name('usersingleview');
Route::get('usersdelete/{id}',[UsersController::class,'usersdelete'])->name('usersdelete');

// Media
Route::get('media/media',[MediaController::class,'media'])->name('media');
Route::post('mediacreate',[MediaController::class,'mediacreate'])->name('mediacreate');
Route::post('mediaajax',[MediaController::class,'mediaajax'])->name('mediaajax');
Route::get('mediadelete/{id}',[MediaController::class,'mediadelete'])->name('mediadelete');
Route::get('mediaedit/{id}', [MediaController::class, 'mediaedit'])->name('mediaedit');
Route::post('mediaupdate/{id}', [MediaController::class, 'mediaupdate'])->name('mediaupdate');

// Wallet Manager
Route::get('wallet/wallet_manager',[WalletManagerController::class,'walletmanager'])->name('walletmanager');
Route::get('wallet/wallet_managersingleview',[WalletManagerController::class,'walletmanagersingleview'])->name('walletmanagersingleview');

});

//Frontend

Route::get('/',[FrontendController::class,'index'])->name('index');

//My Account
Route::get('my-account',[FrontendController::class,'myaccount'])->name('myaccount');
Route::get('profile-update',[FrontendController::class,'profileupdate'])->name('profileupdate');
Route::post('userprofileedit',[FrontendController::class,'userprofileedit'])->name('userprofileedit');
Route::get('change-password',[FrontendController::class,'userchangepassword'])->name('userchangepassword');
Route::post('userchangepasswordupdate',[FrontendController::class,'userchangepasswordupdate'])->name('userchangepasswordupdate');

Route::get('address',[FrontendController::class,'address'])->name('address');
Route::get('address-add',[FrontendController::class,'addressadd'])->name('addressadd');
Route::get('addressdelete/{id}',[FrontendController::class,'addressdelete'])->name('addressdelete');
Route::get('address-edit/{id}',[FrontendController::class,'addressedit'])->name('addressedit');
Route::post('addressupdate/{id}',[FrontendController::class,'addressupdate'])->name('addressupdate');
Route::post('addresscreate',[FrontendController::class,'addresscreate'])->name('addresscreate');

//Email and Mobile Number Verify
Route::post('updatewithotp',[FrontendController::class,'updatewithotp'])->name('updatewithotp');
Route::post('updateotpexpire',[FrontendController::class,'updateotpexpire'])->name('updateotpexpire');
Route::post('verifyotp',[FrontendController::class,'verifyotp'])->name('verifyotp');
Route::post('updatewithpassword',[FrontendController::class,'updatewithpassword'])->name('updatewithpassword');

//Search
Route::post('serchproduct',[FrontendController::class,'serchproduct'])->name('serchproduct'); 
Route::get('search',[FrontendController::class,'search'])->name('search'); 
// Add this (inside web.php, middleware 'auth' expected if needed)

Route::get('ordersucsess',[FrontendController::class,'ordersucsess'])->name('ordersucsess'); 

//Cart
Route::post('addtocart',[CartController::class,'addtocart'])->name('addtocart');
Route::post('cartmodel',[CartController::class,'cartmodel'])->name('cartmodel');
Route::post('quantityupdate',[CartController::class,'quantityupdate'])->name('quantityupdate');
Route::get('cartdelete/{id}',[CartController::class,'cartdelete'])->name('cartdelete');
Route::get('cart', [CartController::class, 'cart'])->name('cart');

//Checkout
Route::get('checkout',[CheckoutController::class,'checkout'])->name('checkout');
Route::post('applypromocode',[CheckoutController::class,'applypromocode'])->name('applypromocode');
Route::post('ajaxchangeuser',[CheckoutController::class,'ajaxchangeuser'])->name('ajaxchangeuser');
Route::post('ajaxdeliverhere', [CheckoutController::class, 'ajaxdeliverhere'])->name('ajaxdeliverhere');



//Login//
Route::get('login',[FrontendLoginController::class,'login'])->name('login');
Route::post('loginwithotp',[FrontendLoginController::class,'loginwithotp'])->name('loginwithotp');
Route::post('loginotpexpire',[FrontendLoginController::class,'loginotpexpire'])->name('loginotpexpire');
Route::post('verifyotp',[FrontendLoginController::class,'verifyotp'])->name('verifyotp');

//Login With Password//
Route::post('loginwithpassword',[FrontendLoginController::class,'loginwithpassword'])->name('loginwithpassword');

//googlelogin//
Route::get('googlelogin',[FrontendLoginController::class,'googlelogin'])->name('googlelogin');
Route::get('GoogleAPIconfig',[FrontendLoginController::class,'GoogleAPIconfig'])->name('GoogleAPIconfig');

//Logout
Route::get('logout', [FrontendLoginController::class, 'logout'])->name('logout');

//Register
Route::get('register',[FrontendLoginController::class,'register'])->name('register');
Route::post('validationregister',[FrontendLoginController::class,'validationregister'])->name('validationregister');
Route::post('registercreate',[FrontendLoginController::class,'registercreate'])->name('registercreate');



// aboutus
Route::get('aboutus',[FrontendController::class,'aboutus'])->name('aboutus');
Route::post('order',[FrontendController::class,'order'])->name('order');
Route::get('notfound',[FrontendController::class,'notfound'])->name('notfound');
//Newsletter 
Route::post('newsletteradd',[FrontendController::class,'newsletteradd'])->name('newsletteradd');
//Index 1 Location
Route::post('commonlocation',[FrontendController::class,'commonlocation'])->name('commonlocation'); 
Route::post('googlelocation',[FrontendController::class,'googlelocation'])->name('googlelocation'); 
Route::post('homesection',[FrontendController::class,'homesection'])->name('homesection');
Route::post('ajaxformation',[FrontendController::class,'ajaxformation'])->name('ajaxformation');


// blog and blog details
Route::get('blog',[FrontendBlogController::class,'blog'])->name('blog');
Route::get('blog_details',[FrontendBlogController::class,'blog_details'])->name('blog_details');



// service and service details///
Route::get('service/{slug}',[FrontendServiceController::class,'service'])->name('service');
Route::get('service-details/{slug}',[FrontendServiceController::class,'servicedetails'])->name('servicedetails');



// Service Plan
Route::get('plan-details/{slug}',[ServiceplanController::class,'serviceplan'])->name('serviceplan');

// contactus
Route::get('contactus',[ContactusController::class,'contactus'])->name('contactus');
Route::post('contactenquiry',[ContactusController::class,'contactenquiry'])->name('contactenquiry');
//Store
Route::get('store',[FrontendController::class,'store'])->name('store');