
@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

  <!--favicon-->

  @include('backend/include/head')
@include('backend/include/datatableajax/tablelink')


  <title> Single View Service  Plan</title>
</head>

<body>
  <!--wrapper-->
  <div class="wrapper">
    <!--sidebar wrapper -->
    @include('backend/include/sidebar')
    <!--end sidebar wrapper -->
    <!--start header -->
    @include('backend/include/header')
    <!--end header -->

    <!--start page wrapper -->
    <div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-list-ul me-1"></i>
          <span>Single View Service Plan</span>
        </div>
      </div>
      <div class="page-content">

        <div class="card">
				<div class="row g-0">
<div class="col-md-4 border-end">
    @php
        $multipleImages = json_decode($serviceplan->multiple_image, true);
        $allImages = !empty($multipleImages) ? array_merge([$serviceplan->image], $multipleImages) : [$serviceplan->image];
    @endphp

    <!-- Slider Container -->
    <div class="position-relative border rounded mb-3" style="height: 300px; overflow: hidden;">
        <!-- Main Image wrapped in Fancybox link -->
        <a id="mainImageLink" 
           href="{{ asset('uploads/serviceplan/' . $allImages[0]) }}" 
           data-fancybox="gallery" 
           data-caption="">
            <img id="mainPreview" 
                 src="{{ asset('uploads/serviceplan/' . $allImages[0]) }}" 
                 class="img-fluid w-100 h-100" 
                 style="object-fit: cover;" 
                 alt="Main Image">
        </a>

        <!-- Prev Button -->
        <button onclick="changeImage(-1)" 
                class="position-absolute top-50 start-0 translate-middle-y"
                style="z-index: 2; background: transparent; border: none; font-size: 2rem; color: white;">
            <i class='bx bx-chevron-left'></i>
        </button>

        <!-- Next Button -->
        <button onclick="changeImage(1)" 
                class="position-absolute top-50 end-0 translate-middle-y"
                style="z-index: 2; background: transparent; border: none; font-size: 2rem; color: white;">
            <i class='bx bx-chevron-right'></i>
        </button>
    </div>

    <!-- Thumbnails -->
    <div class="d-flex overflow-auto gap-2 p-2">
        @foreach ($allImages as $index => $img)
            <img src="{{ asset('uploads/serviceplan/' . $img) }}" 
                 width="70" 
                 class="border rounded cursor-pointer thumb-image"
                 onclick="setImage({{ $index }})" 
                 alt="Thumbnail">
        @endforeach
    </div>

    <!-- Hidden Fancybox Links for all images (except the main one) -->
    @foreach ($allImages as $index => $img)
        @if($index != 0)
            <a href="{{ asset('uploads/serviceplan/' . $img) }}" 
               data-fancybox="gallery" 
               data-caption="" 
               style="display: none;"></a>
        @endif
    @endforeach
</div>





					  <div class="col-md-8">
						<div class="card-body">
  <h4 class="card-title ms-2 ">{{ $serviceplan->title }}</h4>

						 <!-- <div class="d-flex gap-3 py-3">-->
							<!--<div class="cursor-pointer">-->
							<!--	<i class='bx bxs-star text-warning'></i>-->
							<!--	<i class='bx bxs-star text-warning'></i>-->
							<!--	<i class='bx bxs-star text-warning'></i>-->
							<!--	<i class='bx bxs-star text-warning'></i>-->
							<!--	<i class='bx bxs-star text-secondary'></i>-->
							<!--  </div>	-->
							<!--  <div>142 reviews</div>-->
							<!--  <div class="text-success"><i class='bx bxs-cart-alt align-middle'></i> 134 orders</div>-->
						 <!-- </div>-->
<br>
<div class="mb-3">
  <h4 class="fw-bold text-muted mb-0 d-flex ms-3 align-items-end flex-wrap">

    ₹{{ $serviceplan->def_price }}

    <span class="d-flex flex-column align-items-start ms-3" style="line-height: 1;">
      <small class="text-success" style="font-size: 0.7rem;">MRP</small>
      <small class="text-decoration-line-through text-danger fs-6">₹{{ $serviceplan->mrp_price	 }}</small>
    </span>
  </h4>
</div>






						<hr>
						  <p class="card-text fs-6"></p>
<div class="mb-4">
        <!--<h5 class="mb-0 text-dark">Service Plan Details</h5>-->
    <div class="card-body">
        @php
            $serviceName = \App\Models\Service::where('id', $serviceplan->service_id)->value('title');
            $subserviceName = \App\Models\Subservice::where('id', $serviceplan->subservice_id)->value('title');
            $childserviceName = \App\Models\ChildService::where('id', $serviceplan->childservice_id)->value('title');
        @endphp

        <dl class="row mb-0">
            <dt class="col-sm-4 text-warning">Service</dt>
            <dd class="col-sm-8">{{ $serviceName }}</dd>

            <dt class="col-sm-4 text-warning">Sub Service</dt>
            <dd class="col-sm-8">{{ $subserviceName }}</dd>

            <dt class="col-sm-4 text-warning">Child Service</dt>
            <dd class="col-sm-8">{{ $childserviceName ?? 'NA' }}</dd>

            <dt class="col-sm-4 text-warning">Image Description</dt>
            <dd class="col-sm-8">{{ $serviceplan->img_description }}</dd>
            
            
<dt class="col-sm-4 text-warning">Video Link</dt>
<dd class="col-sm-8">
    @if(!empty($serviceplan->video_link))
        <a href="{{ $serviceplan->video_link }}" target="_blank">{{ $serviceplan->video_link }}</a>
    @else
        <span class="text-muted">No video link</span>
    @endif
</dd>

        </dl>
    </div>
</div>

						</div>
					  </div>
					</div>
                    <!--<hr/>-->
					<div class="card-body">
						<ul class="nav nav-tabs nav-primary mb-0" role="tablist">
							<li class="nav-item" role="presentation">
								<a class="nav-link active" data-bs-toggle="tab" href="#primaryhome" role="tab" aria-selected="true">
									<div class="d-flex align-items-center">
										<div class="tab-icon"><i class='bx bx-comment-detail font-18 me-1'></i>
										</div>
										<div class="tab-title"> Description </div>
									</div>
								</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" data-bs-toggle="tab" href="#primaryprofile" role="tab" aria-selected="false">
									<div class="d-flex align-items-center">
										<div class="tab-icon"><i class='bx bx-bookmark-alt font-18 me-1'></i>
										</div>
										<div class="tab-title">Meta Tags</div>
									</div>
								</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" data-bs-toggle="tab" href="#primarycontact" role="tab" aria-selected="false">
									<div class="d-flex align-items-center">
										<div class="tab-icon"><i class='bx bx-star font-18 me-1'></i>
										</div>
										<div class="tab-title">Short Description</div>
									</div>
								</a>
							</li>
							<li class="nav-item" role="presentation">
								<a class="nav-link" data-bs-toggle="tab" href="#primaryreviews" role="tab" aria-selected="false">
									<div class="d-flex align-items-center">
										<div class="tab-icon"><i class='bx bx-star font-18 me-1'></i>
										</div>
										<div class="tab-title">Reviews</div>
									</div>
								</a>
							</li>
						</ul>
						<div class="tab-content pt-3">
							<div class="tab-pane fade show active" id="primaryhome" role="tabpanel">
								<p>{!! $serviceplan->description !!}</p>
								<!--<p>Raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse. Mustache cliche tempor, williamsburg carles vegan helvetica. Reprehenderit butcher retro keffiyeh dreamcatcher synth. Cosby sweater eu banh mi, qui irure terry richardson ex squid. Aliquip placeat salvia cillum iphone. Seitan aliquip quis cardigan american apparel, butcher voluptate nisi.</p>-->
							</div>
							<div class="tab-pane fade" id="primaryprofile" role="tabpanel">
                                <div class="mt-2"> <span class="fw-bold">&bull; Meta Title</span>
                                    <p class="ps-2">{{ $serviceplan->meta_title }}</p>
                                </div>
                                <div class="mt-2"> <span class="fw-bold">&bull; Meta Keyword</span>
                                    <p class="ps-2">{{ $serviceplan->meta_keyword }}</p>
                                </div>
                                <div class="mt-2"> <span class="fw-bold">&bull; Meta Description</span>
                                    <p class="ps-2">{{ $serviceplan->meta_description }}</p>
                                </div>
							</div>
							<div class="tab-pane fade" id="primarycontact" role="tabpanel">
								<p>{{ $serviceplan->short_description }}</p>
							</div>
							<div class="tab-pane fade" id="primaryreviews" role="tabpanel">
								<p>NA</p>
							</div>
						</div>
					</div>

				  </div>



      </div>
    </div>
   


    




    @include('backend/include/footer')
    @include('backend/include/datatableajax/tablescript')
    
<script>
    let allImages = @json($allImages);
    let currentIndex = 0;

    function changeImage(direction) {
        currentIndex += direction;

        if (currentIndex < 0) currentIndex = allImages.length - 1;
        if (currentIndex >= allImages.length) currentIndex = 0;

        updateMainImage();
    }

    function setImage(index) {
        currentIndex = index;
        updateMainImage();
    }

    function updateMainImage() {
        let newSrc = "{{ asset('uploads/serviceplan') }}/" + allImages[currentIndex];

        // Update image
        document.getElementById('mainPreview').src = newSrc;

        // Update Fancybox link
        const link = document.getElementById('mainImageLink');
        link.href = newSrc;
        link.setAttribute('');
    }
</script>



</body>

</html>
























