
@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Service Plan Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-git-compare me-1 mb-1 "></i>
        <span class="">Service Plan Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
							<form class="row g-3 needs-validation" onsubmit="return myckediter()" novalidate method="post" action="{{ asset('backend/serviceplanupdate/' . Crypt::encrypt($serviceplandata->id)) }}" enctype="multipart/form-data">
								    @csrf
								    
								    	<div class="col-md-4">
										<label for="bsValidation1" class="form-label"> Services<span class="text-danger" >*</span></label>
                                            <select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id" required>
                                            <option value="">Select Option </option>
                                            @foreach($service as $data)
                                            <option value="{{$data->id}}" @if($serviceplandata->service_id == $data->id) selected @endif>{{$data->title}}</option>
                                            @endforeach
                                            </select>
					
									</div>
									<div class="col-md-4">
										<label for="bsValidation1" class="form-label"> Subservices<span class="text-danger" >*</span></label>
									
									<select class='form-control @error('subcategory') is-invalid @enderror' name="subservice_id" id="subservice_id" required>
                                    {!! serviceOptions('subservice', $serviceplandata->subservice_id ?? '') !!}
									</select>
									</div>
									
										<div class="col-md-4">
										<label for="bsValidation1" class="form-label"> Child Service</label>
									
									<select class='form-control ' name="childservice_id" id="childservice_id" >
									    {!! serviceOptions('childservice', $serviceplandata->childservice_id ?? '') !!}
									</select>
									</div>

								<div class="col-md-6">
										<label for="bsValidation1" class="form-label">Title<span class="text-danger" >*</span></label>
										<input type="text" class="form-control @error('title') is-invalid @enderror" id="title" value="{{$serviceplandata->title}}"   name="title" required>
								
								</div>	
						<div class="col-md-6">
										<label for="bsValidation1" class="form-label">Slug<span class="text-danger" >*</span></label>
										<input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug"  value="{{$serviceplandata->slug}}"  name="slug" required>
										<div id="slug-error" class="text-danger" ></div>
										<div class="invalid-feedback">
										@error('slug')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
									</div>
	                                <div class="col-md-6">
										<label for="bsValidation2" class="form-label">Video </label>
										<input  type="file" class="form-control  " id="bsValidation2" name="video">
									<a href=" {{ asset('uploads/serviceplan/'.$serviceplandata->video) }}" target="_blank">{{ asset('uploads/serviceplan/'.$serviceplandata->video) }}</a>
									
									
									
									</div>
<div class="col-md-6">
    <label for="video_link" class="form-label">Video Link</label>
    <input type="url" class="form-control" value="{{ $serviceplandata->video_link }}" id="video_link" name="video_link">
</div>									
								
							<div class="col-md-4">
										<label for="bsValidation2" class="form-label">Image<span class="text-danger" >(Only Upload Jpg,Png,WEBP)</span></label>
										<div class="d-flex">
										<input data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" id="bsValidation2" name="image"  accept=".jpg,.png" >
										 @if(isset($serviceplandata->image))
										<a href="{{asset('uploads/serviceplan/'.$serviceplandata->image)}}" data-fancybox="image" data-caption=""><img src="{{asset('uploads/serviceplan/'.$serviceplandata->image)}}" alt="image"style=" width: 50px;height:38px; margin-left: 10px !important;
                                 padding: 0 !important;" ></a> @endif  
                                 </div>
									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('image')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
									</div>
									
<div class="col-md-4">
    <label for="bsValidation2" class="form-label">
        Multiple Image 
        <span class="text-danger">( Jpg, Png, WEBP)</span>
    </label>
    <div class="d-flex ">
        <input data-value="imageerror2" type="file"  class="form-control image"  id="multiple_image"  name="multiple_image[]" multiple    accept=".jpg,.png,.webp">

        @if(isset($serviceplandata->multiple_image))
            @php
               
                $images = is_array($serviceplandata->multiple_image) ? 
                          $serviceplandata->multiple_image : 
                          json_decode($serviceplandata->multiple_image, true);


                if(!is_array($images)){
                    $images = explode(',', $serviceplandata->multiple_image);
                }
            @endphp

            @foreach($images as $img)
                <a href="{{ asset('uploads/serviceplan/'.$img) }}"  data-fancybox="gallery" data-caption=""><img src="{{ asset('uploads/serviceplan/'.$img) }}" alt="image"style="width: 50px; height: 38px; margin: 5px; object-fit: cover;"></a>
            @endforeach
        @endif  
    </div>

    <div class="error-message" id="imageerror1" style="color: red;"></div>
</div>

									
										<div class="col-md-4">
    <label for="bsValidation5" class="form-label"> Image Description <span class="text-danger">*</span></label>
    
    <input type="text" class="form-control" id="img_description" name="img_description" value="{{$serviceplandata->img_description}}" required>
    
    
</div>

<div class="col-md-4">
    <label for="bsValidation5" class="form-label"> Default Price<span class="text-danger">*</span></label>
    <input type="text" class="form-control "  id="def_price" name="def_price"  value="{{$serviceplandata->def_price}}" oninput="this.value = this.value.replace(/[^0-9]/g, '')" required>
</div>

<div class="col-md-4">
    <label for="mrp_price" class="form-label">MRP<span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="mrp_price" name="mrp_price" value="{{$serviceplandata->mrp_price}}" oninput="this.value = this.value.replace(/[^0-9]/g, '')" required>
</div>

<div class="col-md-4">
    <label for="bsValidation5" class="form-label"> Ordering By<span class="text-danger">*</span></label>
    <input type="number" class="form-control " id="ordering_by" name="ordering_by" value="{{$serviceplandata->ordering_by}}"  required>
   
</div>
	<div class="col-md-12">
										<label for="bsValidation5" class="form-label"> Short Description<span class="text-danger">*</span></label>
								<textarea name="short_description"  id="short_description" class="form-control  "  required >{{$serviceplandata->short_description}}</textarea>
											
									</div>
								
								
								<div class="col-md-12">
										<label for="bsValidation5" class="form-label">Description</label>
								<textarea name="description"  id="description" class="form-control d-none "  ></textarea>
											<div id="editor-container" style="height: 160px; border: 1px solid #ced4da; border-radius: 4px;">{!!$serviceplandata->description!!}</div>
									</div>
									
									<div class="col-md-12">
										<label for="bsValidation1" class="form-label"> Meta Title <span class="text-danger">*</span></label>
										<input type="text" class="form-control " id="metatitle"  name="meta_title" value="{{$serviceplandata->meta_title}}" required >
										<div class="valid-feedback">
										@error('metatitle')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
									</div>
									<div class="col-md-6">
										<label for="bsValidation1" class="form-label">Meta Keyword</label>
											<textarea   class="form-control "  name="meta_keyword"  >{{$serviceplandata->meta_keyword}}</textarea>
									</div>
										<div class="col-md-6">
										<label for="bsValidation5" class="form-label"> Meta Description</label>
									<textarea   class="form-control "  name="meta_description" > {{$serviceplandata->meta_description}}</textarea>
										<div class="invalid-feedback">
											@error('metadescription')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										</div>
									</div>
									

									
								




								
									<div class="col-md-12">
										<div class="d-md-flex d-grid align-items-center gap-3">
											<button type="submit" id="submit-btn" class="btn btn-primary px-4">Update</button>
										
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>


  


	
	<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>	



@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/dynamicvalidation/slugvalidation')
@include('backend/include/subservicebychildservice/subservicebychildservice')


<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#subservice_id');
    initSelect2('#childservice_id');
  });
</script>

</body>

</html>


		










