@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

  <!--favicon-->

  @include('backend/include/head')
@include('backend/include/datatableajax/tablelink')


  <title>Product Single View Page</title>
</head>

<body>
  <!--wrapper-->
  <div class="wrapper">
    <!--sidebar wrapper -->
    @include('backend/include/sidebar')
    <!--end sidebar wrapper -->
    <!--start header -->
    @include('backend/include/header')
    <!--end header -->

    <!--start page wrapper -->
<div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-package  me-1"></i>
          <span>Product Single View Page</span>
        </div>
      </div>
<div class="container my-5 product-page">
    <div class="card shadow-sm p-4">
        <div class="row g-4">
            <!-- Left: Image Gallery -->
            <div class="col-md-5">
                @php
                    $multipleImages = json_decode($productdata->multiple_image, true);
                    $allImages = !empty($multipleImages) ? array_merge([$productdata->image], $multipleImages) : [$productdata->image];
                @endphp

                <div class="d-flex" style="height: 350px;">
                    <!-- Vertical Thumbnails -->
                    <div class="me-3 d-flex flex-column gap-3 thumbnails-container">
                        @foreach ($allImages as $index => $img)
                            <img 
                                src="{{ asset('uploads/product/' . $img) }}" 
                                width="60" height="60" 
                                class="thumb-image border rounded {{ $index === 0 ? 'selected' : '' }}" 
                                onclick="setImage({{ $index }})"
                                alt="Thumbnail">
                        @endforeach
                    </div>

                    <!-- Main Image with Prev/Next -->
                    <div class="position-relative border rounded flex-grow-1 main-image-container">
                        <a id="mainImageLink" href="{{ asset('uploads/product/' . $allImages[0]) }}" data-fancybox="gallery">
                            <img 
                                id="mainPreview" 
                                src="{{ asset('uploads/product/' . $allImages[0]) }}" 
                                class="img-fluid main-image" 
                                alt="Main Image">
                        </a>

        <button onclick="changeImage(-1)" 
                class="position-absolute top-50 start-0 translate-middle-y"
                style="z-index: 2; background: transparent; border: none; font-size: 2rem; color: white;">
            <i class='bx bx-chevron-left'></i>
        </button>

        <!-- Next Button -->
        <button onclick="changeImage(1)" 
                class="position-absolute top-50 end-0 translate-middle-y"
                style="z-index: 2; background: transparent; border: none; font-size: 2rem; color: white;">
            <i class='bx bx-chevron-right'></i>
        </button>
                    </div>
                </div>

                <!-- Hidden Fancybox Links -->
                @foreach ($allImages as $index => $img)
                    @if($index != 0)
                        <a href="{{ asset('uploads/product/' . $img) }}" data-fancybox="gallery" style="display: none;"></a>
                    @endif
                @endforeach
            </div>

            <!-- Right: Product Details -->
<div class="col-md-7 product-details">

    {{-- Product Title --}}
    <h3 class="mb-3 ms-1 product-title">{{ $productdata->product_item }}</h3>

    {{-- Price Section --}}
    <div class="mb-4 ps-1">
        <h4 class="fw-bold text-dark d-flex align-items-end flex-wrap">
            ₹{{ $productdata->default_price }}

            <span class="d-flex flex-column align-items-start ms-3" style="line-height: 1;">
                <small class="text-muted" style="font-size: 0.75rem;">MRP</small>
                <small class="text-decoration-line-through text-danger">₹{{ $productdata->mrp_price }}</small>
            </span>
        </h4>
    </div>

    {{-- Info Boxes --}}
    @php
        $serviceName = \App\Models\Service::where('id', $productdata->service_id)->value('title');
        $subserviceName = \App\Models\Subservice::where('id', $productdata->subservice_id)->value('title');
        $brandName = \App\Models\Brand::where('id', $productdata->brand_id)->value('brand_name');
    @endphp

    <div class="row g-3 mb-4">
        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Service</small>
                <div class="fw-semibold">{{ $serviceName }}</div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Sub Service</small>
                <div class="fw-semibold">{{ $subserviceName }}</div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Brand</small>
                <div class="fw-semibold">{{ $brandName ?? 'NA' }}</div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Image Description</small>
                <div class="fw-semibold">{{ $productdata->img_description }}</div>
            </div>
        </div>
    </div>

    {{-- Optional: Quantity and Cart Buttons --}}
    <!--
    <!--<div class="d-flex align-items-center gap-3 mb-3">-->
    <!--    <div class="d-flex align-items-center border rounded px-2">-->
    <!--        <button class="btn btn-outline-secondary btn-sm" onclick="decrementQty()">−</button>-->
    <!--        <input type="text" class="form-control text-center mx-2 qty-input border-0" value="1" style="width: 60px;">-->
    <!--        <button class="btn btn-outline-secondary btn-sm" onclick="incrementQty()">+</button>-->
    <!--    </div>-->

    <!--    <button class="btn btn-warning px-4">Add to Cart</button>-->
    <!--    <button class="btn btn-outline-danger"><i class="fa fa-heart"></i></button>-->
    <!--</div>-->

</div>

        </div>

<!-- Tabs Section -->
<div class="mt-5">

    <!-- Tab Navigation -->
    <ul class="nav nav-tabs border-bottom border-2 mb-0" role="tablist">
        <li class="nav-item">
            <a class="nav-link active text-dark fw-semibold" data-bs-toggle="tab" href="#desc" role="tab">
                Description
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark fw-semibold" data-bs-toggle="tab" href="#meta" role="tab">
                Meta Tags
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark fw-semibold" data-bs-toggle="tab" href="#reviews" role="tab">
                Reviews
            </a>
        </li>
    </ul>

    <!-- Tab Contents in Box Style -->
    <div class="tab-content bg-transparent p-0">

        <!-- Description Box -->
        <div class="tab-pane fade show active" id="desc" role="tabpanel">
            <div class="bg-white border rounded p-4 mt-3">
                <div>{!! $productdata->description !!}</div>
            </div>
        </div>

        <!-- Meta Tags Box -->
        <div class="tab-pane fade" id="meta" role="tabpanel">
            <div class="bg-white border rounded p-4 mt-3">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2"><strong>Meta Title:</strong> {{ $productdata->meta_title }}</li>
                    <li class="mb-2"><strong>Meta Keywords:</strong> {{ $productdata->meta_keyword }}</li>
                    <li><strong>Meta Description:</strong> {{ $productdata->meta_description }}</li>
                </ul>
            </div>
        </div>

        <!-- Reviews Box -->
        <div class="tab-pane fade" id="reviews" role="tabpanel">
            <div class="bg-white border rounded p-4 mt-3">
                <p class="text-secondary">NA</p>
            </div>
        </div>

    </div>
</div>

    </div>
</div>

  </div>
</div>


   


    




    @include('backend/include/footer')
    @include('backend/include/datatableajax/tablescript')
    

<script>
    let allImages = @json($allImages);
    let currentIndex = 0;

    function changeImage(direction) {
        currentIndex += direction;

        if (currentIndex < 0) currentIndex = allImages.length - 1;
        if (currentIndex >= allImages.length) currentIndex = 0;

        updateMainImage();
    }

    function setImage(index) {
        currentIndex = index;
        updateMainImage();
    }

    function updateMainImage() {
        let newSrc = "{{ asset('uploads/product') }}/" + allImages[currentIndex];

        // Update image
        document.getElementById('mainPreview').src = newSrc;

        // Update Fancybox link
        const link = document.getElementById('mainImageLink');
        link.href = newSrc;
        link.setAttribute('');
    }
</script>

</body>

</html>
