

@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Partner Register</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-home-alt me-1 mb-1"></i>
        <span>Partner</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                <!-- Nav tabs -->
                <div class="card">
                    <!-- Tabs Header -->
                    <div class="bg-light border-bottom-0 pb-0 px-0">
                        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
                            @if(permission(session('SUPERADMIN_ID'), '32', 'action_view'))
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                                    View
                                </button>
                            </li>
                            @endif

                            @if(permission(session('SUPERADMIN_ID'), '32', 'action_add'))
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                                    Add
                                </button>
                            </li>
                            @endif

                           
                           

                           
                        </ul>
                    </div>

                    <!-- Tabs Content -->
                    <div class="card-body p-4">
                        <div class="tab-content" id="settingsTabContent">

                            <!-- Tab 1: View -->
                            <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="basic25" class="table table-striped dataTable border table-bordered no-footer" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Mobile Number</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Tab 2: Add -->
                            <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
                                <form class="row g-3 needs-validation" id="formatDistrict-update" method="POST" enctype="multipart/form-data" action="{{ asset('backend/partneradd') }}" novalidate>
                                    @csrf
                                    <section class="mb-4">
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label for="email" class="form-label">Name<span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-transparent"><i class='bx bxs-user'></i></span>
                                                    <input type="text" class="form-control" id="name" name="name" required>
                                                </div>
                                            </div>

                                            <div class="col-md-4 mb-3">
                                                <label for="email" class="form-label">Email<span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-transparent"><i class='bx bxs-envelope'></i></span>
                                                    <input type="email" class="form-control" oninput="this.value = this.value.replace(/\s+/g, '')" id="email" name="email" required>
                                                </div>
                                            </div>

                                            <div class="col-md-4 mb-3">
                                                <label for="mobile_number" class="form-label">Mobile Number<span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-transparent"><i class='bx bxs-phone'></i></span>
                                                    <input type="text" class="form-control" id="mobile_number" name="mobile_number" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '')" required>
                                                </div>
                                            </div>

                                            <div class="col-md-4 mb-3">
                                                <label for="dob" class="form-label">ID Proof Select<span class="text-danger">*</span></label>
                                              <select name="id_proof_select" class="form-control">
  <option value="">Select ID Proof</option>
  @foreach($id_proof_select as $Data)
  <option value="{{$Data->id}}">{{$Data->title}}</option>
 @endforeach
</select>

                                            </div>
                                           <div class="col-md-4 mb-3">
    <label for="id_proof" class="form-label">ID Proof<span class="text-danger">*</span></label>
    <input type="file" class="form-control" id="id_proof" name="id_proof[]" multiple required>
</div>
                                            <div class="col-md-4 mb-3">
                                                <label for="id_number" class="form-label">ID Number<span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" id="id_number" name="id_number" required>
                                            </div>

                                           
                                             <div class="col-md-4 mb-3">
                                                <label for="dob" class="form-label">DOB<span class="text-danger">*</span></label>
                                                <input type="text" class="form-control datepicker" id="dob" name="dob" required>
                                            </div>


                                            <div class="col-md-4 mb-3">
                                                <label for="id_proof" class="form-label">Profile<span class="text-danger">*</span></label>
                                                <input data-value="imageerror1" type="file" class="form-control image" id="bsValidation2" name="profile" required accept=".jpg,.png">
                                                <div class="error-message" id="imageerror1" style="color: red;"></div>
                                            </div>

                                            <div class="col-md-4 mb-3">
                                                <label for="partner_code" class="form-label">Partner Code<span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" id="partner_code" name="partner_code" required>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label for="type" class="form-label">Salary Status <span class="text-danger">*</span></label>
                                                    <select class="form-control" id="type" name="salary_status" required>
                                                        <option value="">Select</option>
                                                        <option value="1">Salary</option>
                                                        <option value="2">Commission</option>
                                                    </select>
                                                </div>

                                                <div id="salaryFirst" style="display:none;" class="col-md-6 mb-3">
                                                    <label class="form-label">Salary <span class="text-danger">*</span></label>
                                                    <input class="form-control" id="salary" onkeyup="salarycalculation()" type="number" name="salary" required>
                                                </div>

                                                <div id="salaryMore" style="display:none;" class="row w-100 mx-0">
                                                    <div class="col-md-4 mb-2">
                                                        <label class="form-label">Total Days<span class="text-danger">*</span></label>
                                                        <input class="form-control" id="total_days" type="number" onkeyup="salarycalculation()" name="total_days" required>
                                                    </div>
                                                    <div class="col-md-4 mb-2">
                                                        <label class="form-label">Per Days Salary <span class="text-danger">*</span></label>
                                                        <input class="form-control" id="per_day_salary" type="text" readonly name="per_day_salary" required>
                                                    </div>
                                                    <div class="col-md-4 mb-2">
                                                        <label class="form-label">Per Day Hourly <span class="text-danger">*</span></label>
                                                        <input class="form-control" id="per_day_hourly" type="text" onkeyup="salarycalculation()" name="per_day_hourly" required>
                                                    </div>
                                                    <div class="col-md-4 mb-2">
                                                        <label class="form-label">Per Hours Salary <span class="text-danger">*</span></label>
                                                        <input id="per_hours_salary" type="text" readonly name="per_hours_salary" class="form-control" required>
                                                    </div>
                                                    <div class="col-md-4 mb-2">
                                                        <label class="form-label">Take breack hours <span class="text-danger">*</span></label>
                                                        <input type="number" name="take_breack_hours" class="form-control" required>
                                                    </div>
                                                </div>

                                                <div id="commissionInput" style="display:none;" class="col-md-6 mb-3">
                                                    <label class="form-label">Commission <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="commission" oninput="this.value=this.value.replace(/[^0-9]/g,'')" required>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <label for="countries" class="form-label"> Countries<span class="text-danger">*</span></label>
                                                <select class="form-control" name="countries" id="countries" required>
                                                    <option value="">Select Countries</option>
                                                    @foreach($country as $countryData)
                                                    <option value="{{$countryData->countries_id }}">{{ $countryData->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="col-md-6">
                                                <label for="state" class="form-label">State<span class="text-danger">*</span></label>
                                                <select name="state" class="form-select" id="state" required>
                                                    <option value="">Select State</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mt-3">
                                                <label for="city" class="form-label">City<span class="text-danger">*</span></label>
                                                <select name="city" class="form-select" id="city" required>
                                                    <option value="">Select City</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mt-3">
                                                <label for="pincode" class="form-label">Pincode<span class="text-danger">*</span></label>
                                                <select name="pincode[]" class="form-select" id="pincode" data-placeholder="Choose anything" required multiple>
                                                    <option value="">Select Pincode</option>
                                                </select>
                                            </div>

                                            <div class="col-12 text-end mt-2">
                                                <button class="btn btn-primary" type="submit" name="submit" value="submit">
                                                    Submit
                                                </button>
                                            </div>
                                        </div>
                                    </section>
                                </form>
                            </div>

                          

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



    
<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
 @include('backend/include/statebycity/statebycity')
 

<script>
$(document).on('click', '.editbtn', function () {
    var row = $(this).data('partner'); // Comes from data-partner in HTML

    // Fill form inputs
    $('#id').val(row.id);
    $('#edit_name').val(row.name);
    $('#edit_email').val(row.email);
    $('#edit_mobile_number').val(row.mobile_number);
    $('#edit_pincode').val(row.pincode);
    $('#edit_service_name').val(row.service_name);
    $('#edit_subservice_name').val(row.subservice_name);
    $('#edit_address').val(row.address);
});
</script>


    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic25").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/partnerviewajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
          },
          columns: [
            { data: "id" },
            { data: "name" },
            { data: "email" },
            { data: "number" },
            { data: "status" },
            { data: "action" }
          ],
        });
      });



    </script>

    <script>
      $(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
        let status = $(this).prop('checked') ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
          type: "POST",
          url: "{{ asset('backend/partnerstatus') }}",
          data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
          },
          success: function (response) {
            console.log("Status updated", response);
          },
          error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
          }
        });
      });
    </script>

    <script>
      document.addEventListener("DOMContentLoaded", function () {
        if (document.getElementById('description')) {
          CKEDITOR.replace('description');
        }
        if (document.getElementById('edit_content')) {
          CKEDITOR.replace('edit_content');
        }
      });


    </script>
    
    <script>
       $( '#pincode' ).select2( {
        theme: "bootstrap-5",
        width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
        placeholder: $( this ).data( 'placeholder' ),
        closeOnSelect: false,
    } );
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
 
   
  });
</script>
<script>
const type = document.getElementById('type');
const salaryFirst = document.getElementById('salaryFirst');
const salaryMore = document.getElementById('salaryMore');
const commissionInput = document.getElementById('commissionInput');

type.onchange = e => {
  const v = e.target.value;
  salaryFirst.style.display = salaryMore.style.display = commissionInput.style.display = 'none';
  document.querySelectorAll('#salaryFirst input, #salaryMore input, #commissionInput input')
    .forEach(i => i.removeAttribute('required'));

  if (v === '1') {
    salaryFirst.style.display = 'block';
    salaryMore.style.display = 'flex';
    document.querySelectorAll('#salaryFirst input, #salaryMore input')
      .forEach(i => i.setAttribute('required', 'required'));
  } else if (v === '2') {
    commissionInput.style.display = 'block';
    document.querySelector('#commissionInput input').setAttribute('required', 'required');
  }
};
</script>
<script>
    function salarycalculation(value){
        var salary = $('#salary').val();
        var total_days = $('#total_days').val();
        var per_day_hourly = $('#per_day_hourly').val();
         $("#per_day_salary").val(salary/total_days);
         $("#per_hours_salary").val(Math.round((salary/total_days)/per_day_hourly * 100) / 100);
    }
</script>
<script>
    	$(".datepicker").flatpickr();
</script>
</body>

</html>




