@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>
<!-- Required meta tags -->

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Order</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class='bx bxs-plus-square me-1'></i>

        <span>Order add</span>
    </div>
</div>
<div class="page-content">
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <form class="needs-validation" novalidate=""
                action="https://develop.localpintu.com/admin/services/order_add_action" method="POST"
                enctype="multipart/form-data">
                <div class="card">
                    <div class="card-body p-3 row">
                        <div class="col-12">
                            <h5 class="mb-0">User Details</h5>
                            <hr>
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <label for="usernumbar" class="form-label">User Number</label>
                            <input class="form-control" id="usernumbar" value="" name="number" required=""
                                oninput="javascript: if (this.value.length &gt; this.maxLength) this.value = this.value.slice(0, this.maxLength);"
                                type="number" maxlength="10">
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <label for="username" class="form-label">User Name</label>
                            <input type="text" class="form-control" id="username" name="name" value="" required="">
                            <input type="hidden" class="form-control" id="lead_id" name="lead_id" value="">
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <label for="email" class="form-label">User Email</label>
                            <input type="email" class="form-control" id="email" name="email">
                        </div>

                    </div>
                </div>
                <div class="card">
                    <div class="card-body p-3 row">
                        <div class="col-12 mt-0">
                            <h5 class="mb-0">Address Details</h5>
                            <hr>
                        </div>

                        <div class="col-md-6">
                                                <label for="countries" class="form-label"> Countries<span class="text-danger">*</span></label>
                                                <select class="form-control" name="countries" id="countries" required>
                                                    <option value="">Select Countries</option>
                                                    @foreach($country as $countryData)
                                                    <option value="{{$countryData->countries_id }}">{{ $countryData->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="col-md-6">
                                                <label for="state" class="form-label">State<span class="text-danger">*</span></label>
                                                <select name="state" class="form-select" id="state" required>
                                                    <option value="">Select State</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mt-3">
                                                <label for="city" class="form-label">City<span class="text-danger">*</span></label>
                                                <select name="city" class="form-select" id="city" required>
                                                    <option value="">Select City</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mt-3">
                                                <label for="pincode" class="form-label">Pincode<span class="text-danger">*</span></label>
                                                <select name="pincode" class="form-select" id="pincode" required >
                                                    <option value="">Select Pincode</option>
                                                </select>
                                            </div>

                        <div class="col-lg-4 col-md-6">
                            <label for="name" class="_1osQq7 -FxG57 mt-3">Address Type</label>
                            <div class="col-lg-6 d-flex mt-1">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="addresstype" value="1" checked=""
                                        id="home" required="">
                                    <label class="form-check-label" for="home">Home</label>
                                </div>
                                <div class="form-check" style="margin-left: 27px;">
                                    <input class="form-check-input" type="radio" name="addresstype" value="2" id="work"
                                        required="">
                                    <label class="form-check-label" for="work">Work</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 mt-2">
                            <label class="form-label">Address</label>
                            <textarea type="text" class="form-control" id="address" name="address"
                                required=""></textarea>
                        </div>
                        <div class="col-md-12 mt-2">
                            <label class="form-label">Live Address</label>
                            <textarea type="text" class="form-control" name="admin_live_address" id="admin_live_address"
                                required=""></textarea>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body p-3 row">
                        <div class="col-12 mt-0">
                            <h5 class="mb-0">Services Details</h5>
                            <hr>
                        </div>
                     	<div class="col-md-4">
										<label for="bsValidation1" class="form-label"> Services<span class="text-danger" >*</span></label>
									<select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id" required>
        <option value="">Select Option </option>
        @foreach($service as $data)
        <option value="{{$data->id}}">{{$data->title}}</option>
        @endforeach
    </select>
									
									</div>
									<div class="col-md-4">
										<label for="bsValidation1" class="form-label"> Subservices<span class="text-danger" >*</span></label>
									
									<select class='form-control @error('subcategory') is-invalid @enderror' name="subservice_id" id="subservice_id" required>
									    <option value="" selected disable >Select Service</option>
									</select>
									</div>
									<div class="col-md-4">
										<label for="bsValidation1" class="form-label"> Child Service</label>
									
									<select class='form-control ' name="childservice_id" id="childservice_id" >
									    <option value="" selected disable >Select Sub Service</option>
									</select>
									</div>
                        <div class="col-lg-12 my-2">
                            <ul class="list-unstyled">
                                <li class="row"><span class="col-6"><b>Plan Name</b></span><span
                                        class="col-3"><b>Quantity</b></span><span class="col-3"><b>Price</b></span></li>
                            </ul>

                            <ul class="ps-3" id="setplan"></ul>
                            <hr>
                            <ul class="ps-3" id="addsetplan"></ul>

                        </div>
                        <div class="col-lg-4 col-md-6 my-2">
                            <label for="inputFirstName" class="form-label">Service Date</label>
                            <input type="text" id="startdate" class="form-control datepicker " name="startdate" required />
                        </div>

                        <div class="col-lg-4 col-md-6 my-2">
                            <label for="inputFirstName" class="form-label">Service Time</label>
                            <select class="form-control" name="time" required="">
                                <option value="" selected="true" disabled="disabled">Select</option>
                                <option value="1">8:00 AM To 10:00 AM</option>
                                <option value="2">10:00 AM To 12:00 PM</option>
                                <option value="3">12:00 PM To 2:00 PM</option>
                                <option value="4">2:00 PM To 4:00 PM</option>
                                <option value="5">4:00 PM To 6:00 PM</option>
                                <option value="6">6:00 PM To 8:00 PM</option>
                                <option value="7">8:00 PM To 10:00 PM</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body p-3 row">
                        <div class="col-12 mt-0">
                            <h5 class="mb-0">Payment Details</h5>
                            <hr>
                        </div>
                        <div class="col-lg-4 col-md-6 my-2">
                            <label for="inputFirstName" class="form-label">Payment Status</label>
                            <select class="form-control " name="paymentstatus" id="paymentstatus" required="">
                                <option value="" selected="true" disabled="disabled">Select</option>
                                <option value="2">Paid</option>
                                <option value="1">Un Paid</option>
                            </select>
                        </div>
                        <div class="col-lg-4 col-md-6 my-2" style="display:none" id="paymentmodede">
                            <label for="inputFirstName" class="form-label">Payment Mode</label>
                            <select class="form-control " name="paymentmode" id="paymentmode">
                                <option value="" selected="true" disabled="disabled">Select</option>
                                <option value="Online">Online</option>
                                <option value="Cash">Cash</option>
                            </select>
                        </div>

                        <div class="col-lg-4 col-md-6 my-2">
                            <label for="inputFirstName" class="form-label">Partner</label>
                            <select class="form-control " name="partner" id="partner">
                                <option value="" selected="true" disabled="disabled">Select</option>
                            </select>
                        </div>

                        <div class="col-12 mt-3">
                            <div class=""><button type="submit" class="btn btn-primary px-5"
                                    value="submit">Submit</button></div>
                        </div>
                    </div>
                </div>
            </form>


        </div>
    </div>
</div>
</div>




</div>

<script>
    $(document).ready(function(){
 $('#paymentstatus').change(function(){
  var paymentstatus = $('#paymentstatus').val();
// alert(paymentstatus);
 if(paymentstatus==2){
     $("#paymentmodede").show();
 }else{
      $("#paymentmodede").hide();
 }
 });
    });
</script>
 <script>
    $(document).ready(function() {
        let startDatePicker = flatpickr("#startdate", {
            dateFormat: "d-m-Y",
            minDate: "today", 
            onChange: function(selectedDates, dateStr, instance) {
               
                endDatePicker.set("minDate", dateStr);
            }
        });

       
    });
    

</script>

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
    initSelect2('#service_id');
    initSelect2('#subservice_id');
    initSelect2('#childservice_id');
  
  });
</script>


@include('backend/include/footer')
 @include('backend/include/statebycity/statebycity')
@include('backend/include/datatableajax/tablescript')
    @include('backend/include/subservicebychildservice/subservicebychildservice')







</body>

</html>