




@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Brands Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-buildings me-1"></i>
        <span class="">Brand Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/brandsupdate/' . Crypt::encrypt($branddata->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">
        <!-- Service Select -->
									<div class="col-md-6 mb-3">
										<label for="bsValidation1" class="form-label"> Services<span class="text-danger" >*</span></label>
									<select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id" required>
    <option value="">Select Option</option>
    @foreach($services as $data)
<option value="{{ $data->id }}" {{ $branddata->service_id == $data->id ? 'selected' : '' }}>
    {{ $data->title }}
</option>
    @endforeach
    </select>
									
									</div>
									<div class="col-md-6 mb-3">
										<label for="bsValidation1" class="form-label"> Subservices<span class="text-danger" >*</span></label>
									<select class='form-control select2 @error('subcategory') is-invalid @enderror' value="{{$branddata->subservice_id}}" name="subservice_id" id="subservice_id" required>
									   {!! serviceOptions('subservice', $branddata->subservice_id ?? '') !!}

									</select>
									</div>

        <!-- Brand Name -->
<div class="col-md-6 mb-3">
  <label for="brand_name" class="form-label">Brand Name<span class="text-danger">*</span></label>
  <input type="text" class="form-control" id="title" name="brand_name" value="{{$branddata->brand_name}}" placeholder="" required>
      <div id="brand_name-error" class="text-danger"></div>
  <div class="invalid-feedback">
    @error('brand_name')
      <span class="alert text-danger">{{ $message }}</span>
    @enderror
  </div>
</div>

<!-- Slug -->
<div class="col-md-6 mb-3">
  <label for="slug" class="form-label">Slug<span class="text-danger">*</span></label>
  <input type="text"  class="form-control @error('slug') is-invalid @enderror" id="slug" value="{{$branddata->slug}}"  name="slug" required>
  <div id="slug-error" class="text-danger"></div>
  <div class="invalid-feedback">
    @error('slug')
      <span class="alert text-danger">{{ $message }}</span>
    @enderror
  </div>
</div>


<div class="col-md-4 mb-3">
    <label for="brand_logo" class="form-label">Brand Logo 
        <span class="text-danger">*(JPG, PNG, WEBP)</span>
    </label>
    
    <div class="input-group">
        <input 
            type="file" data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" 
            id="brand_logo" 
            name="brand_logo" 
            accept=".jpg,.jpeg,.png,.webp"
        >

        @if(isset($branddata->brand_logo))
            <a href="{{ asset('uploads/brands/' . $branddata->brand_logo) }}" 
               data-fancybox="brand_logo" 
               data-caption="Brand Logo">
                <img src="{{ asset('uploads/brands/' . $branddata->brand_logo) }}" 
                     alt="Brand Logo" 
                     style="width: 50px; height: 38px; margin-left: 10px;" />
            </a>
        @endif
    </div>

									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('brand_logo')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
</div>






        <!-- Tollfree Number -->
        <div class="col-md-4 mb-3">
          <label for="tollfree_number" class="form-label">Tollfree Number</label>
          <input type="text" class="form-control" id="tollfree_number" name="tollfree_number" value="{{$branddata->tollfree_number}}" maxlength="15" placeholder="" oninput="this.value=this.value.replace(/[^0-9\-]/g,'')">
        </div>
				<div class="col-md-4 mb-3">
					<label for="ordering_by" class="form-label">Ordering By <span class="text-danger">*</span></label>
					<input type="number" class="form-control @error('ordering_by') is-invalid @enderror"
						id="ordering_by" value="{{$branddata->ordering_by}}" name="ordering_by" required>
					<div class="invalid-feedback">
						@error('ordering_by')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>
       


<div class="col-md-12 mb-3">
  <label for="description" class="form-label">Description</label>
  <!-- Hidden field to store Quill HTML content on submit -->
  <textarea name="description" class="d-none" id="description">{{ $branddata->description }}</textarea>

  <!-- Editor container with fixed height and styling -->
  <div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;">{!!$branddata->description!!}</div>
</div>

        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Update
</button>
        </div>
      </div>
    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/dynamicvalidation/slugvalidation')
@include('backend/include/subservicebychildservice/subservicebychildservice')

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#subservice_id');
   
  });
</script>

</body>

</html>


		










