<!doctype html>
<html lang="en" class="semi-dark">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
@php
    $settings = DB::table('websitesettings')->first();
@endphp
<link rel="icon" href="{{ asset('uploads/websitesetting/' . $settings->fevicon) }}" type="image/png"/>
	<link href="{{asset('superadmin/assets/plugins/simplebar/css/simplebar.css')}}" rel="stylesheet"/>
	<link href="{{asset('superadmin/assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}}" rel="stylesheet" />
	<link href="{{asset('superadmin/assets/plugins/metismenu/css/metisMenu.min.css')}}" rel="stylesheet" />
	<link href="{{asset('superadmin/assets/css/pace.min.css')}}" rel="stylesheet" />
	<script src="{{asset('superadmin/assets/js/pace.min.js')}}"></script>
	<link href="{{asset('superadmin/assets/css/custome.css')}}" rel="stylesheet">
	<link href="{{asset('superadmin/assets/css/bootstrap.min.css')}}" rel="stylesheet">
	<link href="{{asset('superadmin/assets/css/bootstrap-extended.css')}}" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
	<link href="{{asset('superadmin/assets/css/app.css')}}" rel="stylesheet">
	<link href="{{asset('superadmin/assets/css/icons.css')}}" rel="stylesheet">
	<title>Local Pintu</title>
</head>

<body class="usb1">
  <style>
 .usb1 {
  background-image: url('{{asset('superadmin/assets/images/otpbg.jpg')}}');
  background-size: cover;
  background-repeat: no-repeat;
  background-position: center center;
  /*min-height: 100vh;*/
  background-attachment: fixed;
}

.custom-signin-btn {
  background-color: #ff9800;
  color: white;
  transition: background-color 0.3s ease;
  border: none;
}

.custom-signin-btn:hover {
  background-color: #e68900;
}

.navbar{
    background: #ff9800 !important;
}

    </style>
<div class="wrapper ">
		<header class="login-header shadow">
			<nav class="navbar navbar-expand-lg navbar-light rounded-0 bg-white fixed-top rounded-0 shadow-none border-bottom">
				<div class="container-fluid me-3">
					<a class="navbar-brand" href="#">
						<img src="{{ asset('uploads/websitesetting/' . $website->header_logo) }}" width="30" alt="" />
					</a>
					<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent1" aria-controls="navbarSupportedContent1" aria-expanded="false" aria-label="Toggle navigation"> <span class="navbar-toggler-icon"></span>
					</button>
					<div class="collapse navbar-collapse" id="navbarSupportedContent1">
						<ul class="navbar-nav ms-auto mb-2 mb-lg-0">
							<li class="nav-item"> <a class="nav-link text-white active" aria-current="page" href="#"><i class='bx bx-home-alt me-1'></i>Home</a>
							</li>
							<li class="nav-item"> <a class="nav-link text-white" href="#"><i class='bx bx-user me-1'></i>About</a>
							</li>
							<li class="nav-item"> <a class="nav-link text-white" href="#"><i class='bx bx-category-alt me-1'></i>Features</a>
							</li>
							<li class="nav-item"> <a class="nav-link text-white" href="#"><i class='bx bx-microphone me-1'></i>Contact</a>
							</li>
						</ul>
					</div>
				</div>
			</nav>
		</header>
<div class="d-flex align-items-center justify-content-center min-vh-100 bg-light">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-6 col-lg-5">

        <!-- Forgot Password Card -->
        <div class="card shadow border-0 mt-4" id="forgotPasswordForm">
          <div class="card-body p-4">
            <div class="text-center mb-3">
              <img src="{{ asset('uploads/websitesetting/' . $website->header_logo) }}" style="height: 60px;">
            </div>
            <h4 class="mb-3 text-center">Forgot Password</h4>
            <form method="POST" action="{{asset('backend/login_process')}}">
              @csrf
              <div class="mb-3">
                <label>Email / Mobile</label>
                <div class="input-group input-group-md">
                  <span class="input-group-text border border-warning bg-transparent"><i class='bx bxs-envelope'></i></span>
                  <input type="text" class="form-control border border-warning" name="email" id="inputEmailAddress" placeholder="Enter Email/Number" required>
                </div>
              </div>
              <div class="d-grid">
                <button type="button" id="forgotBtn" class="btn text-white custom-signin-btn">Submit</button>
              </div>
            </form>
            <div class="titletextfontmassage mt-2"></div>
          </div>
        </div>

        <!-- OTP Verification Card -->
      <div class="card my-5 shadow-none border" id="otpFormCard">
    <div class="card-body">
        <div class="p-4">

            <!-- Logo -->
            <div class="col-12 text-center mb-2">
                <img src="{{ asset('uploads/websitesetting/' . $website->header_logo) }}"
                    alt="Logo" style="height: 60px;">
            </div>

            <!-- Title -->
            <div class="text-center me-3 mb-4">
                <h5>OTP Authentication</h5>
                <p class="mb-0">Enter the 6 digit OTP sent to your Email or Number.</p>
            </div>

            <!-- OTP Form -->
            <div class="form-body">
                <form class="row g-3" id="otpForm" method="POST" action="{{ asset('backend/otpverification') }}">
                    @csrf

                    <div class="row justify-content-center">
                        <div class="col-10">
                            <label for="otp" class="form-label">OTP</label>
                            <div class="d-flex justify-content-between gap-2">
                                <input type="text" name="otp[]" maxlength="1"
                                    class="form-control text-center border border-warning otp-input" required>
                                <input type="text" name="otp[]" maxlength="1"
                                    class="form-control text-center border border-warning otp-input" required>
                                <input type="text" name="otp[]" maxlength="1"
                                    class="form-control text-center border border-warning otp-input" required>
                                <input type="text" name="otp[]" maxlength="1"
                                    class="form-control text-center border border-warning otp-input" required>
                                <input type="text" name="otp[]" maxlength="1"
                                    class="form-control text-center border border-warning otp-input" required>
                                <input type="text" name="otp[]" maxlength="1"
                                    class="form-control text-center border border-warning otp-input" required>
                            </div>

                            <input type="hidden" name="otphide" id="otp" value="">
                        </div>

                        <!-- Resend (optional) -->
                        <div class="col-md-12 text-end">
                            
                        </div>

                        <!-- Submit Button -->
                        <div class="col-10 mt-2">
                            <div class="d-grid">
                                <button type="button" class="btn text-white custom-signin-btn">
                                    Submit
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="titletextfontmassage mt-2"></div>
            </div>
            <!-- End OTP Form -->

        </div>
    </div>
</div>


        <!-- Change Password Card -->
        <div class="card shadow border-0 mt-4" id="changePasswordCard">
          <div class="card-body p-4">
            <div class="text-center mb-4">
              <h3 class="text-dark">Change Password</h3>
              <p class="text-muted mb-0">Enter your new password</p>
            </div>
            <form class="needs-validation" id="changePasswordForm" action="{{ asset('backend/forgotchangepassword') }}" method="POST" novalidate>
              @csrf
              <div class="mb-3">
                <label for="inputChoosePassword" class="form-label">Password <span class="text-danger">*</span></label>
                <div class="input-group" id="show_hide_password">
                  <span class="input-group-text border-warning"><i class='bx bxs-lock-open'></i></span>
                  <input type="password" class="form-control border-warning" id="inputChoosePassword" name="password" placeholder="Enter Password" required>
                  <span class="input-group-text border-warning toggle-password" style="cursor: pointer;">
                    <i class='bx bx-hide'></i>
                  </span>
                </div>
              </div>
              <div class="d-grid">
                <button type="submit" class="btn text-white custom-signin-btn">Update</button>
              </div>
            </form>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<footer class="w-auto shadow-none border-top p-2 text-center fixed-bottom" style="background-color: #2e55a2;">
  <p class="mb-0 text-white">&copy;{{ $website->copyright }}</p>
</footer>

<script src="{{asset('superadmin/assets/js/jquery.min.js')}}"></script>
<script>
$(document).ready(function () {
  // Hide OTP & Change Password by default
  $("#otpFormCard").hide();
  $("#changePasswordCard").hide();

  // Forgot Password Click
  $("#forgotBtn").click(function () {
    let email = $("#inputEmailAddress").val();
    let _token = $('input[name="_token"]').val();

    if (email.trim() === "") {
      alert("Please enter email or mobile number");
      return false;
    }

    $.ajax({
      type: "POST",
      url: "{{ route('backend.login_process') }}",
      dataType: "json",
      data: { _token: _token, email: email, type_action: "forgot" },
      beforeSend: function () {
        $("#forgotBtn").prop("disabled", true).text("Please wait...");
      },
      success: function (response) {
        if (response.status === "success") {
          $("#forgotPasswordForm").hide();
          $("#otpFormCard").show();
          $("input[name='otphide']").val(email);
          $(".titletextfontmassage").html('<div class="alert alert-success">' + response.message + '</div>');
        } else {
          $(".titletextfontmassage").html('<div class="alert alert-danger">' + response.message + '</div>');
        }
      },
      complete: function () {
        $("#forgotBtn").prop("disabled", false).text("Submit");
      }
    });
  });

  // OTP Submit
  $("#otpForm button").click(function () {
    let otp = $("input[name='otp[]']").map(function () { return $(this).val(); }).get().join('');
    let email = $("input[name='otphide']").val();
    let _token = $('input[name="_token"]').val();

    if (otp.length !== 6) {
      alert("Please enter a valid 6-digit OTP");
      return false;
    }

    $.ajax({
      type: "POST",
      url: "{{ route('backend.forgetpasswordcheck') }}",
      dataType: "json",
      data: { _token: _token, email: email, otp: otp },
      success: function (response) {
        if (response.status === "success") {
          $("#otpFormCard").hide();
          $("#changePasswordCard").show();
        } else {
          $(".titletextfontmassage").html('<div class="alert alert-danger">' + response.message + '</div>');
        }
      }
    });
  });

  // OTP Auto Focus
  document.querySelectorAll('.otp-input').forEach((input, index, inputs) => {
    input.addEventListener('input', function () {
      this.value = this.value.replace(/[^0-9]/g, '');
      if (this.value.length === 1 && index < inputs.length - 1) {
        inputs[index + 1].focus();
      }
    });
    input.addEventListener('keydown', function (e) {
      if (e.key === 'Backspace' && !this.value && index > 0) {
        inputs[index - 1].focus();
      }
    });
  });
});
</script>
</body>
</html>
