@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Store</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-store me-1"></i>

        <span>Store</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">
    <!-- Tabs Header -->
    <div class="bg-light border-bottom-0 pb-0 px-0">
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @if(permission(session('SUPERADMIN_ID'), '23', 'action_view'))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                    View
                </button>
            </li>
            @endif
            @if(permission(session('SUPERADMIN_ID'), '23', 'action_add'))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                    Add
                </button>
            </li>
            @endif
        </ul>
    </div>

    <!-- Tabs Content -->
    <div class="card-body p-4">

            <div class="tab-content" id="settingsTabContent">
<div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>name</th>
            <th>number</th>
            <th>email</th>
            <th>Time</th>
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>

                <!-- Tab 2: Logo & Images -->
<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{asset('backend/storecreate')}}" enctype="multipart/form-data" novalidate>
    @csrf
<section class="mb-4">
  <div class="row">

    <div class="col-md-6 mt-2">
      <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
      <input type="text" class="form-control" id="title" name="name" required>
    </div>
   
										<div class="col-md-6 mt-2">
										<label for="bsValidation1" class="form-label">Slug<span class="text-danger" >*</span></label>
										<input type="text" class="form-control " id="slug"  name="slug" required>
										<div id="slug-error" class="text-danger" ></div>
									</div>

    <div class="col-md-4 mt-2">
      <label for="number" class="form-label">Number <span class="text-danger">*</span></label>
      <input type="text" class="form-control" id="number" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10)" name="number" required>
    </div>

    <div class="col-md-4 mt-2">
      <label for="whatsapp" class="form-label">WhatsApp Number</label>
      <input type="tel" class="form-control" id="whatsapp" oninput="this.value = this.value.replace(/[^0-9]/g, '')" maxlength="10" name="whatsapp">
    </div>
    
    <div class="col-md-4 mt-2">
      <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
      <input type="email" class="form-control" id="email" name="email" required>
    </div>
    
    <div class="col-md-6 mt-2">
      <label for="latitude" class="form-label">Latitude</label>
      <input type="text" class="form-control" id="latitude" oninput="this.value = this.value.replace(/[^0-9]/g, '')" maxlength="10" name="latitude">
    </div>

    <div class="col-md-6 mt-2">
      <label for="longitude" class="form-label">Longitude</label>
      <input type="text" class="form-control" id="longitude" oninput="this.value = this.value.replace(/[^0-9]/g, '')" name="longitude">
    </div>

    <div class="col-md-3 mt-2">
      <label for="countries" class="form-label">Countries <span class="text-danger">*</span></label>
      <select class="form-select" name="countries" id="countries" required>
        <option value="">Select Countries</option>
@foreach($country as $countryData)
    <option value="{{$countryData->countries_id}}" >
        {{$countryData->name}}
    </option>
@endforeach
      </select>
    </div>

    <div class="col-md-3 mt-2">
      <label for="state" class="form-label">State <span class="text-danger">*</span></label>
      <select class="form-select" name="state" id="state" required>
        <option value="">Select State</option>
      </select>
    </div>

    <div class="col-md-3 mt-2">
      <label for="city" class="form-label">City <span class="text-danger">*</span></label>
      <select class="form-select" name="city" id="city" required>
        <option value="">Select City</option>
      </select>
    </div>

    <div class="col-md-3 mt-2">
      <label for="pincode" class="form-label">Pincode <span class="text-danger">*</span></label>
      <select class="form-select" name="pincode" id="pincode" required>
        <option value="">Select Pincode</option>
      </select>
    </div>
    
  <div class="col-md-6 mt-2">
    <label for="start_time" class="form-label">Start Time</label>
    <input type="text" class="form-control time-picker" name="start_time" id="start_time" />
  </div>

  <!-- End Time -->
  <div class="col-md-6 mt-2">
    <label for="end_time" class="form-label">End Time</label>
    <input type="text" class="form-control time-picker" name="end_time" id="end_time" />
  </div>

<div class="col-md-12 mt-2">
  <label for="multiple-select-field" class="form-label">Close</label>
  <select class="form-select" id="multiple-select-field" name="close" multiple required>
    <option value="Monday">Monday</option>
    <option value="Tuesday">Tuesday</option>
    <option value="Wednesday">Wednesday</option>
    <option value="Thursday">Thursday</option>
    <option value="Friday">Friday</option>
    <option value="Saturday">Saturday</option>
    <option value="Sunday">Sunday</option>
  </select>
</div>



    <div class="col-12 mt-2">
      <label for="map_url" class="form-label">Map URL</label>
      <textarea class="form-control" id="map_url" name="map_url" rows="3"></textarea>
    </div>

    <div class="col-12 mt-2">
      <label for="address" class="form-label">Address<span class="text-danger">*</span></label>
      <textarea class="form-control" id="address" name="address" rows="3" required></textarea>
    </div>
    
	<div class="col-md-12 mt-3">
		<div class="d-md-flex d-grid align-items-center gap-3">
			<button type="submit" id="submit-btn" class="btn btn-primary px-4">Submit</button>
		</div>
    </div>
  </div>

</section>


  </form>
</div>

            </div>
    </div>
</div>

            </div>
        </div>
        <!--end row-->
    </div>
</div>

<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/statebycity/statebycity')
@include('backend/include/dynamicvalidation/slugvalidation')
@include('backend/include/subservicebychildservice/subservicebychildservice')

<script>
  $(document).ready(function() {
    $('#multiple-select-field').select2({
      placeholder: "",
      width: '100%'
    });
  });
</script>

    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic21").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/storeajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
          },
          columns: [
            { data: "id" },
            { data: "name" },
            { data: "number" },
            { data: "email" },
            { data: "time_range" },
            { data: "status" },
            { data: "action" }
          ],
        });
      });



    </script>







  <script>
      $(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
        let status = $(this).prop('checked') ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
          type: "POST",
          url: "{{ asset('backend/storestatus') }}",
          data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
          },
          success: function (response) {
            console.log("Status updated", response);
          },
          error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
          }
        });
      });
    </script>


 	<script>
		$(".time-picker").flatpickr({
				enableTime: true,
				noCalendar: true,
				dateFormat: "H:i",
			});
	</script>  
<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
  });
</script>

</body>

</html>
