@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
 
@include('backend/include/datatableajax/tablelink')

<title>Pincode</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->

<div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-map me-1 mb-1"></i>
          <span>Pincode</span>
        </div>
      </div>
      <div class="page-content">



        <div class="row">
          <div class="col-xl-12">
            <div class="card">
              <div class="bg-light border-bottom-0 pb-0 px-0">
                <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                    @if(permission(session('SUPERADMIN_ID'), '21', 'action_view'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab"
                      data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                      View
                    </button>
                  </li>
                  @endif
                  @if(permission(session('SUPERADMIN_ID'), '21', 'action_add'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo"
                      type="button" role="tab" aria-controls="logo" aria-selected="false">
                      Add
                    </button>
                  </li>
                  @endif
                </ul>
              </div>

	<div class="switcher-wrapper">
          	    @if(permission(session('SUPERADMIN_ID'), '21', 'action_view'))
		<div class="switcher-btn"> <i class='bx bx-filter-alt'></i>
@endif
		</div>
		 <div class="card">
		  <div class="card-header text-capitalize usbb d-flex align-items-center">
		      
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>
		<div class="switcher-body">
		
		<div class="row">
		  
			
			
			 @php
                        
                         if(!empty($_GET['countries'])){
	         $filtercountries=$_GET['countries'];
	        }else{
	         $filtercountries="";
	        }
                         if(!empty($_GET['state'])){
	         $filterstate=$_GET['state'];
	        }else{
	         $filterstate="";
	        }
	               if(!empty($_GET['city'])){
	         $filtercity=$_GET['city'];
	        }else{
	         $filtercity="";
	        }
	        @endphp
                   <form class="row g-3 needs-validation" id="formatDistrict-update" method="get" action="" novalidate>
								 
      <div class="col-md-12 m-0">
          	
                               <label class="form-label" for="role">Countries <span class="text-danger">*</span></label>
                                <select class=" form-control"  name="countries" id="filtercountries" required>
                                    <option value="">Select Countries</option>
                                 @foreach($country as $countryData)
    <option value="{{ $countryData->countries_id }}"
        @if(trim($filtercountries) == trim($countryData->countries_id)) selected @endif>
        {{ $countryData->name }}
    </option>
@endforeach
                                                                        
                                                                    </select>
                            </div>
                            <div class="col-md-12 ">
                                <label for="bsValidation1" class="form-label">State <span class="text-danger">*</span></label>
                                        <select name="state" class="form-select" id="filterstate" required>
                                          {!! locationOptions('state', $filterstate ?? '') !!}
                                        </select>
                            </div>
                            <div class="col-md-12 ">
                           
                                <label for="bsValidation1" class="form-label">City</label>
                                        <select name="city" class="form-select" id="filtercity" >
                                           {!! locationOptions('city', $filtercity ?? '') !!}
                                        </select>
                            </div>
                            
                           
										 <div class="modal-footer">
        
        <button type="submit" class="btn btn-primary">Apply</button>
      </div>
                            </form>
		</div>
		</div>
		</div>
	</div>
              <div class="card-body ">
                <div class="tab-content" id="settingsTabContent">
                  <!-- Tab 1: Logo & Images -->
                  <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">

                    <div class="card-body">
                     <form id="editEmailTemplateForm" class="row g-3 needs-validation" novalidate method="POST" action="{{ asset('backend/pincodecreate') }}">
                         @csrf
    <div class="row">
    <div class="col-md-4 mb-3">
    <label for="bsValidation7" class="form-label">Countries <span class="text-danger" >*</span></label>
    <select class=" form-control"  name="country" id="countries" required>
    <option value="">Select Countries</option>
    @foreach($country as $countryData)
    <option value="{{$countryData->countries_id }}" >{{$countryData->name}}</option>
    @endforeach
    </select>
    </div>
    
    <div class="col-md-4 mb-3">
    <label for="bsValidation8" class="form-label">State<span class="text-danger" >*</span></label>
    <select name="state" class="form-select" id="state" required>
    <option value="">Select State</option>
    </select>
    </div>
    
    
    <div class="col-md-4 mb-3">
    <label for="bsValidation9" class="form-label">City<span class="text-danger" >*</span></label>
    <select name="city" class="form-select" id="city"required>
    <option value="">Select City</option>
    </select>
    </div>
    
				<!-- Ordering By -->
<div class="col-md-3 mb-3" style="display: none;">
	<label for="ordering_by" class="form-label">Ordering By</label>
	<input type="number" class="form-control @error('ordering_by') is-invalid @enderror"
		id="ordering_by" name="ordering_by">
</div>

    
    <div class="col-md-12 mb-3">
    <label for="pincode" class="form-label">Pincode <span class="text-danger" >*</span></label>
    <input type="text" class="form-control" oninput="this.value = this.value.replace(/[^0-9]/g, '')" id="pincode"  name="pincode" data-role="tagsinput" required>
    
    </div>  
          <div class="col-12 text-end mt-3">
              <button type="submit" class="btn btn-primary">Submit</button>
          </div>
    </div>
   
        
    </form>
                    </div>

                  </div>


                  <!-- Tab 2: Other Settings -->
                  <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
                    <div class="card-body">
                     	<div class="table-responsive">
							<table id="basic21" class="table table-striped  dataTable border table-bordered no-footer " style="width:100%">
								<thead>
									<tr class="hello1">
    							  <th>ID</th>
                                            <!--<th>Ordering By</th>-->
                                            <th>Countries</th>
                                            <th>States</th>
                                            <th>Cities</th>
                                            <th>Pincode</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                           
    								    
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>

        </div>


      </div>
    </div>
   

     
    <!-- Loader HTML -->

<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>
<style>
    .switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 18% !important;
}
</style>
	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/statebycity/statebycity')



 <script>
	    $(document).ready(function(){
   
    $.ajaxSetup({
    headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
    });  

    $('#basic21').DataTable({
          @include('backend.include.datatableajax.datatablefilter')
        'processing': false,
        'serverSide': true,
        'serverMethod': 'POST',
        'ajax': {
        'url': "{{asset('backend/pincodeajax')}}",
           data: function (d) {
    d.filtercountries = $('#filtercountries').val();
    d.filterstate = $('#filterstate').val();
    d.filtercity = $('#filtercity').val();
},
        beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
        },
        'columns': [
            { data: 'id' },
            // { data: 'ordering_by' },
            { data: 'country' },
            { data: 'state' },
            { data: 'city' },
            { data: 'pincode' },
			{ data: 'status' },
			{ data: 'action' },
        ]
    });
});
	</script>





<script>
    $(document).on('change', '.status-toggle', function () {
        let status = $(this).prop('checked') ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
            type: "POST",
            dataType: "json",
            url: "{{ url('backend/pincodestatus') }}", 
            data: {
                status: status,
                id: userId,
                _token: '{{ csrf_token() }}',
            },
            success: function (data) {
                console.log("AJAX Success: ", data);
            },
            error: function (error) {
                console.log("AJAX Error: ", error);
                alert("Error occurred!");
            }
        });
    });
</script>

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#filtercountries');
    initSelect2('#filterstate');
    initSelect2('#filtercity');
   
  });
</script>

</body>

</html>