    
    @include('backend/include/custom')
    <!doctype html>
    <html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <head>
    
    <style>
    .nav-pills .nav-link.active {
    color: #fff !important;
    background-color: #ff9800 !important;
    padding: 4px 10px !important;
    }
    
    .nav-pills .nav-link {
    background: 0 0;
    border: 0;
    border-radius: var(--bs-nav-pills-border-radius);
    padding: 4px 10px;
    color: #1f1e1c;
    font-weight: 500;
    font-size: 16px;
    }
    
    .nav-link:hover {
    color: #ff9800 !important;
    }
    
    .detail-row
 {
    display: flex
;
    justify-content: space-between;
    padding: 8px 0;
    border-bottom: 1px dashed #ddd;
}

      .content-cell {
    max-width: 239; 
}

.content-cell .short-text {
    display: inline-block;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.content-cell .full-text {
    display: block; 
    white-space: normal;
    margin-top: 5px;
}


    
    </style>
    
    
    <!--favicon-->
    
    @include('backend/include/head')
    @include('backend/include/datatableajax/tablelink')
    
    <title>Lead</title>
    </head>
    
    <body>
    <!--wrapper-->
    <div class="wrapper">
    <!--sidebar wrapper -->
    @include('backend/include/sidebar')
    <!--end sidebar wrapper -->
    <!--start header -->
    @include('backend/include/header')
    <!--end header -->
    
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
            <i class='bx bx-target-lock'></i>
            <span>Leads</span>
        </div>
    </div>
    <div class="page-content">

        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="bg-light border-bottom-0 pb-0 px-0">
                        <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                            @if(permission(session('SUPERADMIN_ID'), '13', 'action_view'))
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab"
                                    data-bs-target="#others" type="button" role="tab" aria-controls="others"
                                    aria-selected="true">
                                    View
                                </button>
                            </li>
                            @endif
                            @if(permission(session('SUPERADMIN_ID'), '13', 'action_add'))
                            <li class="nav-item" role="presentation">
                                <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab"
                                    data-bs-target="#logo" type="button" role="tab" aria-controls="logo"
                                    aria-selected="false">
                                    Add
                                </button>
                            </li>
                            @endif
                        </ul>
                    </div>

                    <div class="card-body ">
                        <div class="tab-content" id="settingsTabContent">
                            <!-- Tab 1: Add Lead -->
                            <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
                                
                               <div class="card-body">
    <form class="row g-3 needs-validation" onsubmit="return myckediter()" novalidate method="POST" action="{{asset('backend/leadscreate')}}" enctype="multipart/form-data">
    @csrf
   
    <div class="col-md-6">
    <label for="status" class="form-label">Status</label>
    <select name="status" class="form-select" id="status">
        <option value="">Select Status</option>
        <option value="1">In Progress</option>
        <option value="2">Approved</option>
        <option value="3">Not Responded</option>
        <option value="4">Reject</option>
        <option value="5">Hold</option>
    </select>
</div>

<div class="col-md-6">
    <label for="source" class="form-label">Source</label>
    <select name="source" class="form-select" id="source">
        <option value="">Select Source</option>
        <option value="1">Business</option>
        <option value="2">Client</option>
    </select>
</div>
    <div class="col-md-4">
    <label for="bsValidation2" class="form-label">Name</label>
    <input type="text" class="form-control"  id=""  name="name">
    
    </div>
    
    <div class="col-md-4">
    <label for="bsValidation3" class="form-label">Phone Number<span class="text-danger" >*</span></label>
    <input type="text" class="form-control"  id=""  name="phone" required oninput="this.value = this.value.replace(/[^0-9]/g, '')" maxlength = "10">
    
    </div>
    
    <div class="col-md-4">
    <label for="bsValidation4" class="form-label">Email Address</label>
    <input type="text" class="form-control"  id="email_address"  name="email_address" oninput="this.value = this.value.replace(/\s+/g, '')">
    
    </div>
        <div class="col-md-12">
    <label for="bsValidation1" class="form-label">Tag</label>
    <input type="text" class="form-control"  id="tags"  name="tags" data-role="tagsinput">
    </div>
 	<div class="col-md-3">
	     <label for="bsValidation5" class="form-label"> Countries</label>
   <select class=" form-control"  name="countries" id="countries">
                                    <option value="">Select Countries</option>
                                    @foreach($country as $countryData)
                                                                        <option value="{{$countryData->countries_id }}" >{{$countryData->name}}</option>
                                                                        @endforeach
                                                                        
                                                                    </select>
   
</div>
	<div class="col-md-3">
   <label for="bsValidation1" class="form-label">State</label>
                                        <select name="state" class="form-select" id="state">
                                            <option value="">Select State</option>
                                        </select>
   
</div>
	<div class="col-md-3">
 
                                <label for="bsValidation1" class="form-label">City</label>
                                        <select name="city" class="form-select" id="city">
                                            <option value="">Select City</option>
                                        </select>
   
</div>
	<div class="col-md-3">
 
                             <label for="bsValidation1" class="form-label">Pincode</label>
                              <select name="pincode" class="form-select" id="pincode">
                                            <option value="">Select Pincode</option>
                                        </select>
   
</div>
    
    <div class="col-md-6">
    <label for="bsValidation5" class="form-label">Position</label>
    <input type="text" class="form-control"  id=""  name="position">
    
    </div>
    
    <div class="col-md-6">
    <label for="bsValidation6" class="form-label">Company</label>
    <input type="text" class="form-control"  id=""  name="company">
    
    </div>
 
  
    
    
    
    <div class="col-md-12">
    <label for="bsValidation11" class="form-label">Address </label>
    <textarea   class="form-control "   name="address" id="" ></textarea>
    
    </div>
    
    
    <div class="col-md-6">
    <label for="bsValidation12" class="form-label">Website</label>
    <input type="text" class="form-control"  id=""  name="website">
    
    </div>
    
    
    <div class="col-md-6">
    <label for="bsValidation13" class="form-label">Lead Value</label>
    <input type="number" class="form-control"  id=""  name="lead_value" >
    
    </div>
    
    
    
    <div class="col-md-12">
    <label for="bsValidation14" class="form-label">Description</label>
  	<textarea name="description" class="d-none"  id="description"   ></textarea>
									<div id="editor-container"  style="height: 160px; border: 1px solid #ced4da; border-radius: 4px;"></div>
    </div>
    

 									<div class="col-md-12 pt-5 mt-5">
										<div class="d-md-flex d-grid align-items-center gap-3 mt-3">
											<button type="submit" id="submit-btn" class="btn btn-primary px-4">Submit</button>
										
										</div>
									</div>
    </form>
    </div>
                            </div>

                            <!-- Tab 2: View Leads -->
                            <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="basic21" class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Number</th>
                                                    <th>Email</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Edit Modal -->
                      <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      
      <!-- Header -->
      <div class="modal-header p-2 usbb">
        <h5 class="modal-title text-white" id="editModalLabel">Lead </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <!-- Body -->
      <div class="modal-body">
        <ul class="nav nav-pills mb-3" role="tablist">
          <li class="nav-item" role="presentation">
            <a class="nav-link active" data-bs-toggle="pill" href="#primary-pills-home" role="tab">
              <div class="d-flex align-items-center">
                <div class="tab-icon"> <i class="bx bx-user-circle me-2"></i></div>
                <div class="tab-title">Lead Details</div>
              </div>
            </a>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" data-bs-toggle="pill" href="#primary-pills-profile" role="tab">
              <div class="d-flex align-items-center">
                <div class="tab-icon"><i class="bx bx-user-pin font-18 me-1"></i></div>
                <div class="tab-title">Reminder</div>
              </div>
            </a>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" data-bs-toggle="pill" href="#primary-pills-contact" role="tab">
              <div class="d-flex align-items-center">
                <div class="tab-icon"><i class="bx bx-microphone font-18 me-1"></i></div>
                <div class="tab-title">Follow Up</div>
              </div>
            </a>
          </li>
        </ul>

        <!-- Tab Content -->
        <div class="tab-content" id="pills-tabContent">
          <!-- Lead Details -->
          <div class="tab-pane fade active show" id="primary-pills-home" role="tabpanel">
            @include('backend/lead/leadsingleview')
          </div>

          <!-- Reminder -->
          <div class="tab-pane fade" id="primary-pills-profile" role="tabpanel">
            <div class="row">
  <div class="col-md-6">
    <div class="card-body">
         <form class="row g-3 needs-validation" id="formatDistrict-updatereminder" onsubmit="return myckediter()" novalidate method="POST" action="{{asset('backend/remindercreate')}}" enctype="multipart/form-data">
        <div class="row">
        @csrf
        
          @csrf
        <input type="hidden" name="id" id="followup_id" />
        @php
 $remindertypeId = App\Models\reminder_type::where('id', 1)
                        ->where('status','1')
                        ->value('id');
@endphp
<input type="hidden" name="reminder_type" id="reminder_type"
       value="{{$remindertypeId}}"
       class="form-control" placeholder="Enter Reminder Type" required>
        <input type="hidden" name="id" id="reminderid" />

        <div class="col-md-12">
          <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
          <input type="text" class="form-control" id="titlereminder" name="title" required>
        </div>

        <div class="col-md-6 mt-3">
          <label for="file" class="form-label">File</label>
          <div class="d-flex">
          <input type="file" class="form-control image" data-value="imageerror1" id="filereminder" name="file" accept=".jpg,.jpeg,.png,.webp" />
               <img id="image-show" src="" alt="Preview" class="ms-1" style="width: 14%; display:none;" data-fancybox="image" data-caption="">
          </div>
          <div class="error-message" id="imageerror1" style="color: red;"></div>
        </div>

        <div class="col-md-6 mt-3">
          <label for="reminderInput" class="form-label">Select Date & Time</label>
          <input type="text" class="form-control date-time" name="reminder_datetime" id="reminderdate" required>
        </div>

        <div class="col-md-12 mt-3">
          <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
          <input type="email" class="form-control" id="emailreminder" name="email" data-role="tagsinput" required>
        </div>

        <div class="col-md-12 mt-3">
          <label for="content" class="form-label">Content</label>
        <textarea name="content" class="form-control" id="contentreminder" required></textarea>
        </div>

        <div class="col-md-12 mt-3">
          <button type="submit" id="submitreminder" class="btn btn-primary px-4">Submit</button>
        </div>
      </div>
      </form>
    </div>
  </div>
   <div class="col-md-6">
              
    <div class="card-body">
        <div class="table-responsive">
      	    <table id="basic22" class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
								<thead>
									<tr>
										<th>ID</th>
										<th>Title</th>
									    <th>Status</th>
									     <th>Action</th>
									</tr>
								</thead>
								<tbody>
								</tbody>
			</table>
        </div>
    </div>
          </div>
</div>
          </div>

          <!-- Followup -->
          <div class="tab-pane fade" id="primary-pills-contact" role="tabpanel">
            
           <div class="row">
  <div class="col-md-6">
    <div class="card-body">
          <form class="row g-3 needs-validation" id="formatDistrict-update" onsubmit="return myckediter()" novalidate method="POST" action="{{asset('backend/followup')}}" enctype="multipart/form-data">

        <div class="row">
      
        <div class="col-md-6">
          <label for="startdate" class="form-label">Start Date<span class="text-danger">*</span></label>
          <input type="text" id="startdate" class="form-control date-time" name="startdate" required />
        </div>

        <div class="col-md-6">
          <label for="enddate" class="form-label">End Date<span class="text-danger">*</span></label>
          <input type="text" id="enddate" class="form-control date-time" name="enddate" required />
        </div>

      <div class="col-md-12 mt-2">
    <label for="content" class="form-label">Content<span class="text-danger">*</span></label>
    <textarea name="content" class="form-control" id="contentfollowup" required></textarea>
</div>

        <div class="col-md-12 mt-3">
          <button type="submit" id="submitBtn" class="btn btn-primary px-4">Submit</button>
        </div>
        </div>
      </form>
     
    </div>
  </div>
   <div class="col-md-6">
              <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="followup" class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
                                            <thead>
                                                <tr>
                                                  	<th>ID</th>
										<th>Start/End Date</th>
										<th>Content</th>
									     <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>

          </div>

</div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

    
    
    <div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
    </div>
    
    
    
    
    
    
    @include('backend/include/footer')
    @include('backend/include/datatableajax/tablescript')
    @include('backend/include/statebycity/statebycity')
<!--Lead-->
    <script>
    $(document).ready(function(){
    
    $.ajaxSetup({
    headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
    });  
    
    $('#basic21').DataTable({
    @include('backend.include.datatableajax.datatablefilter')
    'processing': false,
    'serverSide': true,
    'serverMethod': 'POST',
    'ajax': {
    'url': "{{asset('backend/leadsajax')}}",
    beforeSend: function () {
    $('#loader').show(); 
    },
    complete: function () {
    $('#loader').hide(); 
    
    }
    },
    'columns': [
    { data: 'id' },
    { data: 'name' },
    { data: 'phone' },
    { data: 'email_address' },
    { data: 'status' },
    { data: 'action' },
    ]
    });
    });
    </script>
 
     	<script>
	    	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/leadstatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
    });
});
	</script>  

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
       initSelect2('#status');
    initSelect2('#source');

  });
</script>
<!--Lead-->

<!--//Follow Up-->
 <script>
    $(document).ready(function(){
    
    $.ajaxSetup({
    headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
    });  
    
    $('#followup').DataTable({
    @include('backend.include.datatableajax.datatablefilter')
    'processing': false,
    'serverSide': true,
    'serverMethod': 'POST',
    'ajax': {
    'url': "{{asset('backend/followupajax')}}",
    beforeSend: function () {
    $('#loader-followup').show(); 
    },
    complete: function () {
    $('#loader-followup').hide(); 
    
    }
    },
    'columns': [
    { data: 'id' },
    { data: 'dates' },
    { data: 'content' },
    { data: 'action' },
    ]
    });
    });
    </script>
<script>
   $(".date-time").flatpickr({
				enableTime: true,
				dateFormat: "Y-m-d H:i",
		});
</script>
<script>
 document.addEventListener('click', function(e){
    if(e.target.classList.contains('read-more')){
        let cell = e.target.closest('.content-cell');
        cell.querySelector('.short-text').classList.toggle('d-none');
        cell.querySelector('.full-text').classList.toggle('d-none');

        e.target.innerText = e.target.innerText === "Read More" ? "Read Less" : "Read More";
    }
});

</script>

<script>
function followupedit(row){
    $('#loader').show();

    if(row.id !== ''){ // id check properly
        $('#loader').hide();

        var url = "{{asset('backend/followupdate/')}}";
        $('#formatDistrict-update').attr('action', url);

        $('#startdate').val(row.startdate);
        $('#enddate').val(row.enddate);
        document.getElementById('contentfollowup').value = row.content;

     document.getElementById('submitBtn').innerText = "Update";
        $('#followup_id').val(row.id);
    }
}
</script>


<!--//Reminder-->

  <script>
     $(document).ready(function(){
    
     $.ajaxSetup({
     headers: {
     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
     }
     });  
    
     $('#basic22').DataTable({
     @include('backend.include.datatableajax.datatablefilter')
     'processing': false,
     'serverSide': true,
     'serverMethod': 'POST',
     'ajax': {
     'url': "{{asset('backend/reminderajax')}}",
     beforeSend: function () {
     $('#loader').show(); 
     },
     complete: function () {
     $('#loader').hide(); 
    
     }
     },
     'columns': [
     { data: 'id' },
     { data: 'title'},
     { data: 'status' },
     { data: 'action' },
    ]
     });
    });
     </script>
     
     
<script>

function reminderedit(row){
    $('#loader').show();

    if(row.id !== ''){
        $('#loader').hide();

        var url = "{{asset('backend/reminderupdate/')}}";
        $('#formatDistrict-updatereminder').attr('action', url);
        $('#titlereminder').val(row.title);
         $('#emailreminder').tagsinput('removeAll');
        if(row.email){
            row.email.split(',').forEach(function(email){
                $('#emailreminder').tagsinput('add', email.trim());
            });
        }
        $('#reminderdate').val(row.datetime);
        document.getElementById('contentreminder').value = row.content;

        if(row.file){ 
            $('#image-show').attr('src', '/uploads/reminder/' + row.file).show();
        } else {
            $('#image-show').hide();
        }
        document.getElementById('submitreminder').innerText = "Update";

        $('#reminderid').val(row.id);
    }
}
</script>


    </body>
    
    </html>
    
    
    
    
    
