<script>
$(document).ready(function () {

    function initServiceDropdown(serviceSelector, subserviceSelector, childserviceSelector, brandSelector) {
        // ---- Service Change ----
        $(serviceSelector).change(function () {
            const serviceId = $(this).val();

            if (serviceId) {
                $.ajax({
                    url: '{{ url("subservicebychildservice") }}',
                    method: 'GET',
                    data: { service_id: serviceId },
                    beforeSend: function () { $('#loader').show(); },
                    success: function (response) {
                        if (response.subservices && response.subservices.length) {
                            let options = '<option value="" disabled selected>Select Sub Services</option>';
                            response.subservices.forEach(item => {
                                options += `<option value="${item.id}">${item.title}</option>`;
                            });
                            $(subserviceSelector).html(options);
                        } else {
                            $(subserviceSelector).html('<option value="">No Subservices Available</option>');
                        }

                        $(childserviceSelector).html('<option value="">Select Subservice First</option>');
                        $(brandSelector).html('<option value="">Select Subservice First</option>');
                    },
                    error: function () {
                        $(subserviceSelector).html('<option value="">Error loading subservices</option>');
                    },
                    complete: function () { $('#loader').hide(); }
                });
            } else {
                $(subserviceSelector).html('<option value="">Select Service First</option>');
                $(childserviceSelector).html('<option value="">Select Subservice First</option>');
                $(brandSelector).html('<option value="">Select Subservice First</option>');
            }
        });

        // ---- Subservice Change ----
        $(subserviceSelector).change(function () {
            const subserviceId = $(this).val();

            if (subserviceId) {
                $.ajax({
                    url: '{{ url("subservicebychildservice") }}',
                    method: 'GET',
                    data: { subservice_id: subserviceId },
                    beforeSend: function () { $('#loader').show(); },
                    success: function (response) {
                        // ---- Childservices ----
                        if (response.childservice && response.childservice.length) {
                            let childOptions = '<option value="" disabled selected>Select Child Service</option>';
                            response.childservice.forEach(item => {
                                childOptions += `<option value="${item.id}">${item.title}</option>`;
                            });
                            $(childserviceSelector).html(childOptions);
                        } else {
                            $(childserviceSelector).html('<option value="">No Child Service Available</option>');
                        }

                        // ---- Brands ----
                        if (response.brands && response.brands.length) {
                            let brandOptions = '<option value="" disabled selected>Select Brand</option>';
                            response.brands.forEach(item => {
                                brandOptions += `<option value="${item.id}">${item.brand_name}</option>`;
                            });
                            $(brandSelector).html(brandOptions);
                        } else {
                            $(brandSelector).html('<option value="">No Brands Available</option>');
                        }
                    },
                    error: function () {
                        $(childserviceSelector).html('<option value="">Error loading childservice</option>');
                        $(brandSelector).html('<option value="">Error loading brands</option>');
                    },
                    complete: function () { $('#loader').hide(); }
                });
            } else {
                $(childserviceSelector).html('<option value="">Select Subservice First</option>');
                $(brandSelector).html('<option value="">Select Subservice First</option>');
            }
        });
    }

    // ---- Call function for Add form ----
    initServiceDropdown('#service_id', '#subservice_id', '#childservice_id', '#brand_id');

    // ---- Call function for Filter form ----
    initServiceDropdown('#filterservice_id', '#filtersubservice_id', '#filterchildservice_id', '#filterbrand_id');

});
</script>
