@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Page Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-package me-1"></i>
        <span class="">Page Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/pageupdate/' . Crypt::encrypt($page->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">

				<!-- Product Item -->
				<div class="col-md-6 mb-3">
					<label for="title" class="form-label">Title<span class="text-danger">*</span></label>
					<input type="text" class="form-control @error('title') is-invalid @enderror"
						id="title" value="{{ $page->title }}" name="title" required>
				</div>
<!-- Page URL -->
<div class="col-md-6 mb-3">
    <label for="page_url" class="form-label">Page URL</label>
    <input type="text" class="form-control @error('page_url') is-invalid @enderror"
           id="page_url" name="page_url" value="{{ $page->page_url }}" value="" placeholder="">
</div>
<div class="col-md-6 mb-3">
    <label for="image" class="form-label">Image
        <span class="text-danger">*(JPG, PNG, WEBP)</span>
    </label>
    
    <div class="input-group">
        <input 
            type="file" data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" 
            id="image" 
            name="image" 
            accept=".jpg,.jpeg,.png,.webp"
            >

        @if(isset($page->image))
            <a href="{{ asset('uploads/page/' . $page->image) }}" 
               data-fancybox="image" 
               data-caption="Brand Logo">
                <img src="{{ asset('uploads/page/' . $page->image) }}" 
                     alt="Brand Logo" 
                     style="width: 50px; height: 38px; margin-left: 10px;" />
            </a>
        @endif
    </div>

									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('image')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
</div>

<!-- Banner Image -->
<div class="col-md-6 mb-3">
    <label for="banner" class="form-label">Banner Image
        <span class="text-danger">*(JPG, PNG, WEBP)</span>
    </label>
    
    <div class="input-group">
        <input 
            type="file" data-value="imageerror1" type="file" class="form-control image @error('banner') is-invalid @enderror" 
            id="banner" 
            name="banner" 
            accept=".jpg,.jpeg,.png,.webp"
        >

        @if(isset($page->banner))
            <a href="{{ asset('uploads/page/' . $page->banner) }}" 
               data-fancybox="banner" 
               data-caption="">
                <img src="{{ asset('uploads/page/' . $page->banner) }}" 
                     alt="" 
                     style="width: 50px; height: 38px; margin-left: 10px;" />
            </a>
        @endif
    </div>

									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('banner')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
</div>


<div class="col-md-12 mb-3">
  <label for="description" class="form-label">Description</label>
  <!-- Hidden field to store Quill HTML content on submit -->
  <textarea name="description" class="d-none" id="description">{{ $page->description }}</textarea>

  <!-- Editor container with fixed height and styling -->
  <div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;">{!!$page->description!!}</div>
</div>
  <div class="col-md-6 mb-3">
    <label for="meta_title" class="form-label">Meta Title</label>
    <input type="text" name="meta_title" id="meta_title" class="form-control" value="{{ $page->meta_title }}" placeholder="">
  </div>

  <div class="col-md-6 mb-3">
    <label for="meta_keyword" class="form-label">Meta Keywords</label>
    <input type="text" name="meta_keyword" id="meta_keyword" class="form-control" value="{{ $page->meta_keyword }}" placeholder="">
  </div>
    <div class="col-md-12 mb-3">
    <label for="meta_description" class="form-label">Meta Description</label>
    <textarea name="meta_description" id="meta_description" class="form-control" rows="3" placeholder="">{{ $page->meta_description }}</textarea>
  </div>
        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Update
</button>
        </div>
      </div>
    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
	




</body>

</html>