
@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Pages</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-file me-1"></i>

        <span>Pages</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">
    <!-- Tabs Header -->
    <div class="bg-light border-bottom-0 pb-0 px-0">
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @if(permission(session('SUPERADMIN_ID'), '18', 'action_view'))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                    View
                </button>
            </li>
            @endif
            @if(permission(session('SUPERADMIN_ID'), '18', 'action_add'))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                    Add
                </button>
            </li>
            @endif
        </ul>
    </div>

    <!-- Tabs Content -->
    <div class="card-body p-4">

            <div class="tab-content" id="settingsTabContent">
<div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Title</th>
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>

                <!-- Tab 2: Logo & Images -->
<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">


  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{asset('backend/pagecreate')}}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">

				<!-- Product Item -->
				<div class="col-md-6 mb-3">
					<label for="title" class="form-label">Title<span class="text-danger">*</span></label>
					<input type="text" class="form-control @error('title') is-invalid @enderror"
						id="title" name="title" required>
				</div>
<!-- Page URL -->
<div class="col-md-6 mb-3">
    <label for="page_url" class="form-label">Page URL<span class="text-danger">*</span></label>
    <input type="text" class="form-control @error('page_url') is-invalid @enderror"
           id="page_url" name="page_url" value="" placeholder="" required>
</div>

<div class="col-md-4 mb-3">
    <label for="image" class="form-label">Image<span class="text-danger">*(JPG, PNG, WEBP)</span></label>
    <input data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" id="image" name="image" accept=".jpg,.jpeg,.png,.webp" required>
		<div class="error-message" id="imageerror1" style="color: red;"></div>
			<div class="valid-feedback">
			@error('image')
            <span class="alert text-danger">{{ $message }}</span>
            @enderror
	    </div>
</div>
<!-- Banner Image -->
				<div class="col-md-4 mb-3">
					<label for="brand_logo" class="form-label">Banner Image<span class="text-danger">*(JPG, PNG,
							WEBP)</span></label>
					<input data-value="imageerror1" type="file"
						class="form-control image @error('banner') is-invalid @enderror" id="banner" name="banner"
						accept=".jpg,.jpeg,.png,.webp" required>
					<div class="error-message" id="imageerror1" style="color: red;"></div>
					<div class="valid-feedback">
						@error('banner')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>


<div class="col-md-4 mb-3">
    <label for="status" class="form-label">Status</label>
    <select class="form-select @error('status') is-invalid @enderror" id="delete_status" name="delete_status">
        <option value="">Select Status </option>
        <option value="">Active</option>
    </select>
</div>
<div class="col-md-12 mb-3">
  <label for="description" class="form-label">Description</label>
  <!-- Hidden field to store Quill HTML content on submit -->
  <textarea name="description" class="d-none" id="description"></textarea>

  <!-- Editor container with fixed height and styling -->
  <div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;"></div>
</div>
  <div class="col-md-6 mb-3">
    <label for="meta_title" class="form-label">Meta Title</label>
    <input type="text" name="meta_title" id="meta_title" class="form-control" value="" placeholder="">
  </div>

  <div class="col-md-6 mb-3">
    <label for="meta_keyword" class="form-label">Meta Keywords</label>
    <input type="text" name="meta_keyword" id="meta_keyword" class="form-control" value="" placeholder="">
  </div>
    <div class="col-md-12 mb-3">
    <label for="meta_description" class="form-label">Meta Description</label>
    <textarea name="meta_description" id="meta_description" class="form-control" rows="3" placeholder=""></textarea>
  </div>
        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Submit
</button>
        </div>
      </div>
    </section>
  </form>

</div>

            </div>
    </div>
</div>

            </div>
        </div>
        <!--end row-->
    </div>
</div>

<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')

    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic21").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/pageajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
          },
          columns: [
            { data: 'id' },
            { data: "title" },
            { data: "status" },
            { data: "action" }
          ],
        });
      });



    </script>
<script>
	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/pagestatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
        });
    });
</script>  

    

</body>

</html>