
@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Newsletter</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->

<style>
    
.switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 27% !important;
}

</style>
<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
<div class="breadcrumb-title d-flex align-items-center ms-3"><i class="bx bx-envelope me-1"></i><span>Newsletter</span></div>
</div>
<div class="page-content">
<div class="row">
<div class="col-xl-12 mx-auto">
        
        
<div class="switcher-wrapper">
    @if(permission(session('SUPERADMIN_ID'), '32', 'action_view'))
        <div class="switcher-btn">
            <i class='bx bx-filter-alt'></i>
        </div>
    @endif

    <div class="card">
        <div class="card-header text-capitalize usbb d-flex align-items-center">
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>

        <div class="switcher-body">
        @php
    $status = isset($_GET['status']) ? $_GET['status'] : '';
@endphp

<form class="row g-3 needs-validation" id="filterForm" novalidate style="margin-top: -16px;">
    <div class="col-md-12">
        <label for="status" class="form-label">Subscription Status</label>
        <select class="form-control" id="status" name="status">
            <option value="">Select Status</option>
            <option value="1" {{ $status === '1' ? 'selected' : '' }}>Subscribe</option>
            <option value="0" {{ $status === '0' ? 'selected' : '' }}>Unsubscribe</option>
        </select>
    </div>

    <div class="col-md-12"></div>
    <div class="col-md-8">
        <div>
            <button type="submit" id="submitBtn" class="btn btn-primary px-3">Apply</button>
        </div>
    </div>
</form>

        </div>
    </div>
</div>                   
<div class="card">
    <!-- Tabs Header -->
    <div class="bg-light border-bottom-0 pb-0 px-0">
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @if(permission(session('SUPERADMIN_ID'), '31', 'action_view'))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                    View
                </button>
            </li>
            @endif
            <!--@if(permission(session('SUPERADMIN_ID'), '31', 'action_add'))-->
            <!--<li class="nav-item" role="presentation">-->
            <!--    <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">-->
            <!--        Add-->
            <!--    </button>-->
            <!--</li>-->
            <!--@endif-->
        </ul>
    </div>

    <!-- Tabs Content -->
<div class="card-body p-4">
<div class="tab-content" id="settingsTabContent">
<div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
  <div class="card-body">
        <div class=" text-end">
            <button id="delete-selected" class="btn btn-danger btn-sm">Delete Selected</button>
        </div>
    <div class="table-responsive">
      <table id="basic31"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
          <th><input type="checkbox" class="mt-0 row-checkbox" id="select-all"><span class="ms-2">ID</span></th>
            <th>Username </th>
            <th>Email </th>
            <th> Newsletter Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>


<!--<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">-->
<!--	<form class="row g-3 needs-validation" onsubmit="return myckediter()" method="POST"-->
<!--		action="{{asset('backend/faqcreate')}}" enctype="multipart/form-data" novalidate>-->
<!--		@csrf-->
<!--		<section class="mb-4">-->
<!--			<div class="row">-->

<!--				<div class="col-md-12 mb-3">-->
<!--					<label for="question" class="form-label">Question <span class="text-danger">*</span></label>-->
<!--				    	<input type="text" class="form-control"-->
<!--						id="question" name="question" required>-->
<!--				</div>-->
			
			
<!--				<div class="col-md-12 mb-3">-->
<!--					<label for="answer" class="form-label">Answer</label>-->
<!--					<textarea name="answer" class="d-none" id="description"></textarea>-->
<!--					<div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;">-->
<!--					</div>-->
<!--				</div>-->


<!--				<div class="col-12 text-end">-->
<!--					<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">-->
<!--						Submit-->
<!--					</button>-->
<!--				</div>-->
<!--			</div>-->
<!--		</section>-->
<!--	</form>-->
<!--</div>-->

            </div>
</div>
</div>

</div>
</div>
        <!--end row-->
</div>
</div>

		
<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>






@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')




<script>
$(document).ready(function(){

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });  

    var table = $('#basic31').DataTable({
        @include('backend.include.datatableajax.datatablefilter')
        'processing': false,
        'serverSide': true,
        'serverMethod': 'POST',
        'ajax': {
            'url': "{{ asset('backend/newsletterajax') }}",
            data: function (d) {
                d.status = $('#status').val(); 
            },
            
             beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
        },
        'columns': [
            { data: 'id' },
            { data: "username" },
            { data: "email" },
            { data: "newsletterstatus" },
            { data: "action" }
        ]
    });
    
 

    $('#select-all').on('click', function(){
        var checked = this.checked;
        $('.row-checkbox').each(function(){
            this.checked = checked;
        });
    });

    $(document).on('change', '.row-checkbox', function(){
        if(!this.checked){
            $('#select-all').prop('checked', false);
        }
        if($('.row-checkbox:checked').length === $('.row-checkbox').length){
            $('#select-all').prop('checked', true);
        }
    });

});

</script>


 	<script>
	    	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let newsletter_status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/newsletterstatus') }}",
        data: {
            newsletter_status: newsletter_status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
    });
});
	</script>   
	
	
	<script>
$('#select-all').on('click', function() {
    $('.row-checkbox').prop('checked', this.checked);
});

// Delete Button click
$('#delete-selected').on('click', function() {
    var ids = [];
    $('.row-checkbox:checked').each(function() {
        ids.push($(this).val());
    });

    if (ids.length === 0) {
        alert("Please select at least one row!");
        return;
    }

    if (confirm("Are you sure you want to delete selected records?")) {
        $.ajax({
            url: "{{ route('backend.deletemultiplecitiesnewsletter') }}",
            type: "POST",
            data: {
                ids: ids,
                _token: "{{ csrf_token() }}"
            },
            success: function(res) {
                alert(res.message);
                $('#basic31').DataTable().ajax.reload(); 
            }
        });
    }
});
</script>

</body>

</html>










