@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Contact</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-file me-1"></i>

        <span>Contact</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">


  <div class="card-body">
       @if(permission(session('SUPERADMIN_ID'), '24', 'action_delete'))
       <div class=" text-end">
            <button id="delete-selected" class="btn btn-danger btn-sm">Delete Selected</button>
        </div>
        @endif
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
             <th><input type="checkbox" class="mt-0 row-checkbox" id="select-all"><span class="ms-2">ID</span> </th>
            <th>Name</th>
            <th>Email </th>
            <th>Phone Number</th>
            <!--<th>Message</th>-->
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>


            </div>
    </div>
</div>

            </div>


<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')


<script>
$('#select-all').on('click', function() {
    $('.row-checkbox').prop('checked', this.checked);
});

// Delete Button click
$('#delete-selected').on('click', function() {
    var ids = [];
    $('.row-checkbox:checked').each(function() {
        ids.push($(this).val());
    });

    if (ids.length === 0) {
        alert("Please select at least one row!");
        return;
    }

    if (confirm("Are you sure you want to delete selected records?")) {
        $.ajax({
            url: "{{ route('backend.deletemultiplecontact') }}",
            type: "POST",
            data: {
                ids: ids,
                _token: "{{ csrf_token() }}"
            },
            success: function(res) {
                alert(res.message);
                $('#basic21').DataTable().ajax.reload(); 
            }
        });
    }
});
</script>



    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic21").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/contactajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
          },
          columns: [
            { data: 'id' },
            { data: "name" },
            { data: "email" },
            { data: "number" },
            // { data: "message" },
            { data: "status" },
            { data: "action" }
          ],
        });
        
        $('#select-all').on('click', function(){
        var checked = this.checked;
        $('.row-checkbox').each(function(){
            this.checked = checked;
        });
    });


    $(document).on('change', '.row-checkbox', function(){
        if(!this.checked){
            $('#select-all').prop('checked', false);
        }
        if($('.row-checkbox:checked').length === $('.row-checkbox').length){
            $('#select-all').prop('checked', true);
        }
    });

      });



    </script>
<script>
	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/contactstatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
        });
    });
</script>  

    

</body>

</html>