<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_wallets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->unique();
            $table->unsignedBigInteger('role_id')->unique();
            $table->string('amount')->nullable();
            $table->string('credit_debit_type')->nullable()->comment('1 = credit, 2 = debit');
            $table->string('activity')->nullable();
            $table->string('table_name')->nullable();
            $table->string('tbl_primary_id')->nullable();
            $table->text('description')->nullable();
            $table->string('date_time')->nullable();
            $table->string('date_str')->nullable();
            $table->string('transaction_id')->nullable();
            $table->string('image')->nullable();
            $table->text('commant')->nullable();
            $table->string('payment_status')->nullable();
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_wallets');
    }
};
