<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_service_orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->nullable();
            $table->string('user_id')->nullable();
            $table->string('service_product_id')->nullable();
            $table->string('type')->nullable();
            $table->string('amount')->nullable();
            $table->string('quantity')->nullable();
            $table->string('vender_id')->nullable();
            $table->string('partner_id')->nullable();
            $table->string('city_id')->nullable();
            $table->text('serviceorder_id')->nullable();
            $table->string('orderprimary_id')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_service_orders');
    }
};
