<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Step 1: Existing NULL rows ko 0 se replace karo
        DB::table('extra_charges')
            ->whereNull('use_status')
            ->update(['use_status' => '0']);

        // Step 2: Column modify karo
        Schema::table('extra_charges', function (Blueprint $table) {
            $table->string('use_status')
                  ->default('0')
                  ->nullable(false)
                  ->comment('1 = paid, 0 = unpaid')
                  ->change();
        });
    }

    public function down(): void
    {
        Schema::table('extra_charges', function (Blueprint $table) {
            $table->string('use_status')
                  ->nullable()
                  ->default(null)
                  ->comment('1 = paid, 0 = unpaid')
                  ->change();
        });
    }
};
