<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_carts', function (Blueprint $table) {
            $table->id();
            $table->string('service_id')->nullable();
            $table->string('subservice_id')->nullable();
            $table->string('plan_product_id')->nullable();
            $table->string('city_id')->nullable();
            $table->string('user_id')->nullable();
            $table->string('type')->nullable();
            $table->string('price')->nullable();
            $table->string('quantity')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_carts');
    }
};
