<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('promocodes', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('promocode_type')->nullable();
            $table->string('pricr_per')->nullable();
            $table->string('promocode')->nullable();
            $table->string('user_id')->nullable();
            $table->string('use_range')->unique();
            $table->string('user_range')->unique();
            $table->string('startdate')->nullable();
            $table->string('enddate')->nullable();
            $table->string('ordering_by')->nullable();
            $table->string('countries')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('pincode')->nullable();
            $table->string('service_id')->nullable();
            $table->string('subservice_id')->nullable();
            $table->string('childservice_id')->nullable();
            $table->string('serviceplan_id')->nullable();
            $table->string('created_by')->nullable();
            $table->string('panel_id')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('tokan')->nullable();
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promocodes');
    }
};
