<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pages', function (Blueprint $table) {
        $table->string('image')->nullable()->after('user_id');
        $table->string('meta_title')->nullable()->after('image');
        $table->string('meta_keyword')->nullable()->after('meta_title');
        $table->string('meta_description')->nullable()->after('meta_keyword');
        $table->text('description')->nullable()->after('meta_description');
        $table->unsignedBigInteger('created_by')->nullable()->after('description');
        $table->unsignedBigInteger('panel_id')->nullable()->after('created_by');
        $table->string('tokan')->nullable()->after('panel_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            //
        });
    }
};
