<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_blogs', function (Blueprint $table) {
            $table->id();
            $table->string('category')->nullable();
            $table->string('service_id')->nullable();
            $table->string('subservice_id')->nullable();
            $table->string('title')->nullable();
            $table->string('user_id')->nullable();
            $table->string('slug')->unique();
            $table->string('tagline')->unique();
            $table->string('image')->nullable();
            $table->string('image_title')->nullable();
            $table->string('image_alt')->nullable();
            $table->string('banner')->nullable();
            $table->string('banner_title')->nullable();
            $table->string('banner_alt')->nullable();
            $table->string('meta_tag')->nullable();
            $table->string('meta_title')->nullable();
            $table->string('meta_keyboard')->nullable();
            $table->string('meta_description')->nullable();
            $table->text('description')->nullable();
            $table->string('created_by')->nullable();
            $table->string('panel_id')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('tokan')->nullable();
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_blogs');
    }
};
