<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl__products', function (Blueprint $table) {
            $table->id();
            $table->string('service_id')->nullable();
            $table->string('subservice_id')->nullable();
            $table->string('brand_id')->nullable();
            $table->string('product_item')->nullable();
            $table->string('user_id')->nullable();
            $table->string('slug')->nullable();
            $table->string('image')->nullable();
            $table->string('default_price')->nullable();
            $table->string('ordering_by')->nullable();
            $table->text('description')->nullable();
            $table->string('created_by')->nullable();
            $table->string('panel_id')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('tokan')->nullable();
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl__products');
    }
};
