<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_logs', function (Blueprint $table) {
            $table->id();
           $table->integer('activity_id')->nullable();
$table->string('curd_functions')->default('0');
$table->integer('user_id')->nullable();
$table->integer('role_id')->nullable();
$table->integer('feature_id')->nullable();
$table->string('table_name')->nullable();
$table->integer('table_primary_id')->nullable();
$table->longText('description')->nullable();
$table->longText('web_url')->nullable();
$table->string('date_time')->nullable();
$table->enum('status', ['0', '1'])->default('1');
$table->enum('logs_form', ['0', '1'])->default('1');
$table->string('ip')->nullable();
$table->string('strtotime')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_logs');
    }
};
