<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Models\superadmin;

class Testimonial extends Model
{
    use HasFactory;
    
 public static function testimonialajax($draw, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, $rowcount, $length, $start)
{
    $user_id = session('SUPERADMIN_ID');

    $canViewGlobal = permission($user_id, '26', 'action_globle_view');
    $canAccessCity = permission($user_id, '26', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($city->role == '1') {
        $query = DB::table('testimonials')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('testimonials')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('testimonials')->where('user_id', $user_id)->orderBy('id', 'ASC');
    } else {
        $query = DB::table('testimonials')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }

   if ($searchValue) {
    $query->where(function ($q) use ($searchValue) {
        $q->where('name', 'like', '%' . $searchValue . '%');

        
        if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}




    if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }
}   

    
    
}
