<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Tbl_Product extends Model
{
    use HasFactory;
  public static function productajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$filterData){
    $service = $filterData['filterservice_id'] ?? null;
    $subservice = $filterData['filtersubservice_id'] ?? null;
    $brand   = $filterData['filterbrand_id'] ?? null;
  $status     = isset($filterData['status']) ? (string)$filterData['status'] : null;
     

    $start   = $draw;
    $user_id = session('SUPERADMIN_ID');
    
    $roledata      = superadmin::where('id', $user_id)->first();
    $canViewGlobal = permission($user_id, '16', 'action_globle_view');
    $canAccessCity = permission($user_id, '16', 'action_globle_city');

    $city   = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($roledata->role == '1') {
        $query = DB::table('tbl__products')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('tbl__products')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('tbl__products')->where('tbl__products.id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('tbl__products')->where('tbl__products.id', $user_id)->orderBy('ordering_by', 'ASC');
    }

   
    if (!empty($service)) {
        $query->where('tbl__products.service_id', $service);
    }
    if (!empty($subservice)) {
        $query->where('tbl__products.subservice_id', $subservice);
    }
    if (!empty($brand)) {
        $query->where('tbl__products.brand_id', $brand);
    }
  if ($status !== null && $status !== '') {
    $query->where('tbl__products.status', $status);
}


    
    if ($searchValue) {
        $query->join('services', 'services.id', '=', 'tbl__products.service_id')
              ->join('subservices', 'subservices.id', '=', 'tbl__products.subservice_id')
              ->join('brands', 'brands.id', '=', 'tbl__products.brand_id')
              ->where(function ($q) use ($searchValue) {
                  $q->where('tbl__products.product_item', 'like', '%' . $searchValue . '%')
                    ->orWhere('services.title', 'like', '%' . $searchValue . '%')
                    ->orWhere('subservices.title', 'like', '%' . $searchValue . '%')
                    ->orWhere('brands.brand_name', 'like', '%' . $searchValue . '%');
              })
              ->select('tbl__products.*');
    }

    // Debugging SQL (optional)
    // dd($query->toSql(), $query->getBindings());

    if ($rowcount == 1) {
        $query->limit(10)->offset($start);
        return $query->get();
    } else {
        return $query->count();
    }
}
}
