<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Serviceallottedcity extends Model
{
    use HasFactory;
    
    //Service Allotted City
   public static function serviceallottedcityview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$length,$filterdata,$serviceid){
    $countriesfilter = $filterdata['countriesfilter'] ?? null;
    $statefilter     = $filterdata['statefilter'] ?? null;
    $cityfilter      = $filterdata['cityfilter'] ?? null;
  
    
    $user_id = session('SUPERADMIN_ID');
    $start   = $draw;
        
    $query = DB::table('serviceallottedcities as sac')
        ->leftJoin('tbl_cities as ci', 'ci.city_id', '=', 'sac.city_id')
        ->select(
            'sac.*',
            'ci.name as city_name'
        )
        ->where('sac.service_type','1')->where('serviceid',$serviceid)
        ->orderBy('sac.id', 'DESC');

 
    if (!empty($countriesfilter)) {
        $query->where('sac.countries_id', $countriesfilter);
    }
    if (!empty($statefilter)) {
        $query->where('sac.state_id', $statefilter);
    }
    if (!empty($cityfilter)) {
        $query->where('sac.city_id', $cityfilter);
    }
  

   
    if (!empty($searchValue)) {
        $query->where(function($q) use ($searchValue) {
            $q->where('ci.name', 'like', '%'.$searchValue.'%')
              ->orWhere('sac.id', 'like', '%'.$searchValue.'%');

            
            if (strtolower($searchValue) === 'active') {
                $q->orWhere('sac.status', 1);
            } elseif (strtolower($searchValue) === 'inactive') {
                $q->orWhere('sac.status', 0);
            }
        });
    }

    // Debug (optional)
    // $sql = $query->toSql();
    // $bindings = $query->getBindings();
    // foreach ($bindings as $binding) {
    //     $sql = preg_replace('/\?/', "'$binding'", $sql, 1);
    // }
    // dd($sql);

  
    if($rowcount == 1){
        $query->offset($start)->take($length);
        return $query->get();
    } else {
        return $query->count();    
    }
}

    
    
    
    
    //Sub Service Allotted 
    public static function subserviceallottedcityview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$length,$filterdata,$service_id,$subserviceid){
     $countriesfilter = $filterdata['countriesfilter'] ?? null;
     $statefilter = $filterdata['statefilter'] ?? null;
     $cityfilter = $filterdata['cityfilter'] ?? null;
    
     $user_id = session('SUPERADMIN_ID');
    
        $start = $draw;
        

$query = DB::table('serviceallottedcities as sac')
    ->leftJoin('tbl_cities as ci', 'ci.city_id', '=', 'sac.city_id')
    ->select(
        'sac.*',
        'ci.name as city_name'
    )
    ->orderBy('sac.id', 'DESC')->where('service_type','2')->where('serviceid',$subserviceid);


if (!empty($countriesfilter)) {
    $query->where('sac.countries_id', $countriesfilter);
}
if (!empty($statefilter)) {
    $query->where('sac.state_id', $statefilter);
}
if (!empty($cityfilter)) {
    $query->where('sac.city_id', $cityfilter);
}


if (!empty($searchValue)) {
    $query->where(function($q) use ($searchValue) {
        $q->where('ci.name', 'like', '%'.$searchValue.'%')
          ->orWhere('sac.id', 'like', '%'.$searchValue.'%'); 
           if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}

        
        $sql = $query->toSql();
        $bindings = $query->getBindings();
        
        foreach ($bindings as $binding) {
        $sql = preg_replace('/\?/', "'$binding'", $sql, 1);
        }
        
        if($rowcount == 1){
        // $query->limit(10)->offset($start);
        $query->offset($start)->take($length);
        return $query->get();
        }else{
        return $query->count();    
        }}
    
    //Child Service Allotted City
    public static function childserviceallottedcityview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$length,$filterdata,$service_id,$childservice_id){
     $countriesfilter = $filterdata['countriesfilter'] ?? null;
     $statefilter = $filterdata['statefilter'] ?? null;
     $cityfilter = $filterdata['cityfilter'] ?? null;
      $statusfilter    = $filterdata['statusfilter'] ?? null;
    
     $user_id = session('SUPERADMIN_ID');
    
        $start = $draw;
        

$query = DB::table('serviceallottedcities as sac')
    ->leftJoin('tbl_cities as ci', 'ci.city_id', '=', 'sac.city_id')
    ->select(
        'sac.*',
        'ci.name as city_name'
    )
    ->orderBy('sac.id', 'DESC')->where('service_type','3')->where('serviceid',$childservice_id);


if (!empty($countriesfilter)) {
    $query->where('sac.countries_id', $countriesfilter);
}
if (!empty($statefilter)) {
    $query->where('sac.state_id', $statefilter);
}
if (!empty($cityfilter)) {
    $query->where('sac.city_id', $cityfilter);
}

 if ($statusfilter !== null && $statusfilter !== '') {
        $query->where('sac.status', $statusfilter);
    }


if (!empty($searchValue)) {
    $query->where(function($q) use ($searchValue) {
        $q->where('ci.name', 'like', '%'.$searchValue.'%')
          ->orWhere('sac.id', 'like', '%'.$searchValue.'%'); 
           if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}

        
        
        if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }}
   
   //Service Plan Allotted City
   
    public static function serviceplanallottedcityview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$length,$filterdata,$service_id,$serviceplan_id){
     $countriesfilter = $filterdata['countriesfilter'] ?? null;
     $statefilter = $filterdata['statefilter'] ?? null;
     $cityfilter = $filterdata['cityfilter'] ?? null;
      $statusfilter    = $filterdata['statusfilter'] ?? null;
     $user_id = session('SUPERADMIN_ID');
    
        $start = $draw;
        

$query = DB::table('serviceallottedcities as sac')
    ->leftJoin('tbl_cities as ci', 'ci.city_id', '=', 'sac.city_id')
    ->select(
        'sac.*',
        'ci.name as city_name'
    )
    ->orderBy('sac.id', 'DESC')->where('service_type','4')->where('serviceid',$serviceplan_id);


if (!empty($countriesfilter)) {
    $query->where('sac.countries_id', $countriesfilter);
}
if (!empty($statefilter)) {
    $query->where('sac.state_id', $statefilter);
}
if (!empty($cityfilter)) {
    $query->where('sac.city_id', $cityfilter);
}
  if ($statusfilter !== null && $statusfilter !== '') {
        $query->where('sac.status', $statusfilter);
    }


if (!empty($searchValue)) {
    $query->where(function($q) use ($searchValue) {
        $q->where('ci.name', 'like', '%'.$searchValue.'%')
          ->orWhere('sac.id', 'like', '%'.$searchValue.'%'); 
           if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}

        
        // $sql = $query->toSql();
        // $bindings = $query->getBindings();
        
        // foreach ($bindings as $binding) {
        // $sql = preg_replace('/\?/', "'$binding'", $sql, 1);
        // }
        
        if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }}
    
     //Product  Allotted City//
    
    public static function productallottedcityview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$length,$filterdata,$service_id,$product_id){
     $countriesfilter = $filterdata['countriesfilter'] ?? null;
     $statefilter = $filterdata['statefilter'] ?? null;
     $cityfilter = $filterdata['cityfilter'] ?? null;
      $statusfilter    = $filterdata['statusfilter'] ?? null;
     $user_id = session('SUPERADMIN_ID');
    
        $start = $draw;
        

$query = DB::table('serviceallottedcities as sac')
    ->leftJoin('tbl_cities as ci', 'ci.city_id', '=', 'sac.city_id')
    ->select(
        'sac.*',
        'ci.name as city_name'
    )
    ->orderBy('sac.id', 'DESC')->where('service_type','5')->where('serviceid',$product_id);


if (!empty($countriesfilter)) {
    $query->where('sac.countries_id', $countriesfilter);
}
if (!empty($statefilter)) {
    $query->where('sac.state_id', $statefilter);
}
if (!empty($cityfilter)) {
    $query->where('sac.city_id', $cityfilter);
}
  if ($statusfilter !== null && $statusfilter !== '') {
        $query->where('sac.status', $statusfilter);
    }


if (!empty($searchValue)) {
    $query->where(function($q) use ($searchValue) {
        $q->where('ci.name', 'like', '%'.$searchValue.'%')
          ->orWhere('sac.id', 'like', '%'.$searchValue.'%'); 
           if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}

        
        // $sql = $query->toSql();
        // $bindings = $query->getBindings();
        
        // foreach ($bindings as $binding) {
        // $sql = preg_replace('/\?/', "'$binding'", $sql, 1);
        // }
        
        if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }}
}
