<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Service extends Model
{
    use HasFactory;
    
  public static function servicesajax($draw, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, $rowcount, $length, $start)
{
    $user_id = session('SUPERADMIN_ID');

    $canViewGlobal = permission($user_id, '5', 'action_globle_view');
    $canAccessCity = permission($user_id, '5', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($city->role == '1') {
        $query = DB::table('services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }

   if ($searchValue) {
    $query->where(function ($q) use ($searchValue) {
        $q->where('title', 'like', '%' . $searchValue . '%');

        
        if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}




    if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }
}

public function subservices()
    {
        return $this->hasMany(Subservice::class, 'service_id', 'id');
    }




}
