<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Pincode extends Model
{
    use HasFactory;
    
    
      public static function pincodeajax($draw, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, $rowcount, $length, $start,$filterData)
{
    $countries = $filterData['filtercountries'] ?? null;
    $state   = $filterData['filterstate'] ?? null;
    $city_id   = $filterData['filtercity'] ?? null;
    
    $user_id = session('SUPERADMIN_ID');

    $canViewGlobal = permission($user_id, '21', 'action_globle_view');
    $canAccessCity = permission($user_id, '21', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($city->role == '1') {
        $query = DB::table('pincodes')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('pincodes')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('pincodes')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('pincodes')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }


if (!empty($countries)) {
        $query->where('pincodes.country', $countries);
    }
    if (!empty($state)) {
        $query->where('pincodes.state', $state);
    }
    if (!empty($city_id)) {
        $query->where('pincodes.city', $city_id);
    }

   if ($searchValue) {
    $query->where(function ($q) use ($searchValue) {
        $q->where('pincode', 'like', '%' . $searchValue . '%');

        
        if (strtolower($searchValue) === 'active') {
            $q->orWhere('status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('status', '0');
        }
    });
}




    if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }
}
}