<?php

namespace App\Mail\Frontend;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class EnquiryMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    public $receiver;

    public function __construct(array $data, $receiver = 'owner')
    {
        $this->data = $data;          
        $this->receiver = $receiver;  
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: $this->data['subject'] ?? (
                $this->receiver === 'owner'
                    ? 'New Contact Enquiry'
                    : 'Thank You for Contacting Us'
            )
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'frontend.mail.contactenquiry.contactenquirymail',
            with: [
                'userdata' => $this->data,
                'receiver' => $this->receiver
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
