<?php

namespace App\Http\Controllers\frontend\login;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Websitesetting;
use App\Models\Additionalsetting;
use App\Models\User;
use App\Models\tbl_cart;
use App\Models\tbl_user_otpverifies;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Crypt;
use Laravel\Socialite\Facades\Socialite;

use Illuminate\Support\Facades\Hash;
class LoginController extends Controller
{
    //
    
    function login(){
        
      if(!empty(session('user_id'))){
           return redirect(asset('/'));
      }else{
           $data['allotted'] = Websitesetting::where('id', '1')->first();
           $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
           return view('frontend.login.login',$data)   ;
      }

    }
    
    
        
function register(){
     if(!empty(session('user_id'))){
        return redirect(asset('/'));
     }else{
        $data['allotted'] = Websitesetting::where('id', '1')->first();
        $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        return view('frontend.login.register',$data);
     }
}

public function validationregister(Request $request)
{
    $field = $request->field;
    $value = $request->value;

    if($field == 'email') {
        $exists = DB::table('users')->where('email', 'like', "%{$value}%")->exists();
    } elseif($field == 'phone_number') {
        $exists = DB::table('users')->where('phone_number', 'like', "%{$value}%")->exists();
    } else {
        $exists = false;
    }

    return response()->json(['exists' => $exists]);
}


public function registercreate(Request $request)
{
    $existingEmail = User::where('email', $request->email)->first();
    if ($existingEmail) {
        return redirect()->back()->with('error', 'Email already exist');
    }

    $existingNumber = User::where('phone_number', $request->phone_number)->first();
    if ($existingNumber) {
        return redirect()->back()->with('error', 'Number already exist');
    }



    $captcha = verifyRecaptcha($request->input('g-recaptcha-response'));
    if (!$captcha['success']) {
        return redirect()->back()->with('error', $captcha['message']);
    }
    

    $create = new User;
    $create->name = $request->name;
    $create->email = $request->email;
    $create->phone_number = $request->phone_number;

    $create->phonecode = ltrim($request->phonecode, '+');
    $create->remember_token = reandum_code('50');
    $create->password = Hash::make($request->password);
    $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save();

    $after = json_encode($create);
    $before = json_encode($create);
    insertLogsAPIuser($create->id, '6', 'Register', $create->id, '', '', $after, $before);

    return redirect(asset('login'))->with('success', 'User register successfully');
}



//Login With OTP


// Expire OTP route

function loginwithotp(Request $request)
{
    $now = Carbon::now('Asia/Kolkata');
    $number = $request->number; 
    $phonecode = $request->phonecode ?? '91';

    // Prevent duplicate OTP within 3 seconds
    $lastOtp = DB::table('tbl_user_otpverifies')
        ->where('mobile', $number)
        ->orderBy('id', 'desc')
        ->first();

    if ($lastOtp && (time() - $lastOtp->strtotime) < 3) {
        return response()->json([
            'results' => 'error',
           'message' => 'Maximum OTP attempts reached. Please try again after '.$otpDelay.' minutes.'
        ]);
    }

    $otp = '123456';
    // $otp = rand(100000, 999999);

    $settings = DB::table('websitesettings')->where('id','1')->first();
    $otpDelay = $settings->adminloginattempt_time ?? 1;

    $timestamp = strtotime(minusdatetimeuser($otpDelay));
    $countquery = DB::table('tbl_user_otpverifies')
        ->where('mobile', $number)
        ->where('strtotime', '>=', $timestamp)
        ->first();

    $count = $countquery ? $countquery->attempt : 0;

    if ($settings->user_multipal_attempt_status == '1' && $settings->admin_otp_attempt_count < $count) {
        return response()->json([
            'results' => 'error',
            'message' => 'Maximum OTP attempts reached. Please try again after '.$otpDelay.' minutes.'
        ]);
    }

    $attempt = $count <= 0 ? 1 : $count + 1;

    $record = DB::table('tbl_user_otpverifies')->where('mobile', $number)->first();

    if ($record) {
        DB::table('tbl_user_otpverifies')->where('mobile', $number)->update([
            'otp' => $otp,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'strtotime' => time(),
            'phonecode' => ltrim($phonecode, '+'),
            'updated_at' => $now->format('Y-m-d H:i:s'),
            'attempt' => $attempt,
            'iploging_attemptunit' => $attempt,
        ]);
    } else {
        DB::table('tbl_user_otpverifies')->insert([
            'mobile' => $number,
            'otp' => $otp,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'strtotime' => time(),
            'phonecode' => ltrim($phonecode, '+'),
            'created_at' => $now->format('Y-m-d H:i:s'),
            'updated_at' => $now->format('Y-m-d H:i:s'),
            'attempt' => $attempt,
            'iploging_attemptunit' => $attempt,
        ]);
    }
     $verify = Websitesetting::where('id', '1')->first();
    $verifytype = $verify->user_login_with_opt_apply;

    if ($verifytype == '1') {

    $sent = userverifyotpsend_messageApi('1', $phonecode.$number, 1, $otp);
    if (!$sent) {
        return response()->json([
            'results' => 'error',
            'message' => 'Failed to send OTP. Please try again later.'
        ]);
    }
}else {
        return response()->json([
            'results' => 'error',
            'message' => 'OTP login disabled. Please use password login.'
        ]);
    }
    

    return response()->json([
        'results' => 'success',
        'message' => 'OTP sent successfully. Expires in 60 seconds.',
    ]);
}


 function loginotpexpire(Request $request)
{
    $now = Carbon::now('Asia/Kolkata');
    $otp = '123456';
    // $otp = rand(100000, 999999);

    DB::table('tbl_user_otpverifies')->where('mobile', $request->number)->update([
        'otp' => $otp,
        'ip' => $_SERVER['REMOTE_ADDR'],
        'strtotime' => strtotime($now->format('Y-m-d H:i:s'))
    ]);

    return response()->json([
        'results' => 'expired',
        'message' => 'OTP Expired.',
    ]);
}

 function loginwithpassword(Request $request)
{
    $loginType = $request->loginType ?? '1';

    if($loginType == '1'){
        return $this->verifyotp($request);
    } elseif($loginType == '2'){
        $phone = $request->phone_number;
        $password = $request->password;

        $user = User::where('phone_number', $phone)->first();

        if(!$user){
            return response()->json([
                'success' => '0',
                'message' => 'Account not registered',
                'errorField' => 'phone'
            ]);
        }

        if(empty($password) || !Hash::check($password, $user->password)){
            return response()->json([
                'success' => '0',
                'message' => 'Invalid password',
                'errorField' => 'password'
            ]);
        }

    $after = json_encode($user);
    $before = json_encode($user);
    $adduser=$user->id;
    $user_id=$user->id;
    insertLogsAPIuser($user_id,'5','Login With Password',$adduser,'','',$after,$before); 
        session(['user_id' => $user->id]);
         $this->moveGuestCartToDB($user->id);

        return response()->json([
            'success' => '1',
            'successmsg' => 'Login Successfully',
        ]);
    }
}
function verifyotp(Request $request)
{
    $now = Carbon::now('Asia/Kolkata');
    $number = $request->number;
    $otp = $request->otp;

 
    if (empty($otp)) {
        return response()->json([
            'success' => '0',
            'message' => 'OTP is required',
            'errorField' => 'otp'
        ]);
    }

    $record = DB::table('tbl_user_otpverifies')->where('mobile', $number)->where('otp', $otp)->first();

    if ($record) {
        $user = User::where('phone_number', $number)->first();

        if (!$user) {
            $user = new User;
            $user->name = '';
            $user->email = '';
            $user->password = ''; 
            $user->remember_token = Str::random(50); 
            $user->ip = $_SERVER['REMOTE_ADDR']; 
            $user->strtotime = strtotime($now->format('Y-m-d H:i:s')); 
            $user->phone_number = $number;
            $user->phonecode = $record->phonecode;
            $user->save();
        }

        session(['user_id' => $user->id]);
         $this->moveGuestCartToDB($user->id);
                 $after = json_encode($user);
    $before = json_encode($user);
    $adduser=$user->id;
    $user_id=$user->id;
    insertLogsAPIuser($user_id,'5','Login With Otp',$adduser,'','',$after,$before); 

        return response()->json([
            'success' => '1',
            'successmsg' => 'Login Successfully'
        ]);
    } else {
        // Invalid OTP
        return response()->json([
            'success' => '0',
            'message' => 'Invalid OTP. Please try again.',
            'errorField' => 'otp'
        ]);
    }
}

private function moveGuestCartToDB($user_id)
{
    if(!isset($_COOKIE['cart_items'])) return;
    $now = Carbon::now('Asia/Kolkata');
    $items = json_decode($_COOKIE['cart_items'] ?? '[]', true);

    foreach($items as $plan_product_id => $cartItem){
        if(empty($cartItem['quantity'])) continue;

        // Check if already in DB
        $exists = tbl_cart::where('user_id', $user_id)->where('plan_product_id', $plan_product_id)->first();
        if($exists) continue;

        $cartData = [
            'plan_product_id' => $plan_product_id,
            'user_id'         => $user_id,
            'service_id'      => $cartItem['service_id'] ?? null,
            'subservice_id'   => $cartItem['subservice_id'] ?? null,
            'city_id'         => $cartItem['cityid'] ?? null,
            'type'            => $cartItem['type'] ?? null,
            'price'           => $cartItem['price'] ?? null,
            'quantity'        => $cartItem['quantity'],
            'ip'              => $_SERVER['REMOTE_ADDR'],
            'strtotime'       => strtotime($now->format('Y-m-d H:i:s')),
            'created_at'       =>$now->format('Y-m-d H:i:s'),
            'updated_at'       =>$now->format('Y-m-d H:i:s'),
        ];

        tbl_cart::insert($cartData);
    }

    // ==== Clear only cart_items cookie ====
    setcookie('cart_items', '', time() - 3600, '/');
}


    
 function logout(){
         session()->flush(); 
        return redirect(asset('login'))->with('success','Logout successfully.');
    }

//Google Login


 function GoogleAPIconfig(){
 
 return Socialite::driver('google')->redirect();
}



public function googlelogin(Request $request){
    $now = Carbon::now('Asia/Kolkata'); 
    try {
        $user = Socialite::driver('google')->stateless()->user();
    } catch (Throwable $e) {
        return redirect('login')->with('error', 'Google authentication failed.');
    }

    $userdata = User::where('email', $user->email)->first();

    if ($userdata) {
        $userdata->googleid = $user->id;
        $userdata->save();
    } else {
        $userdata = new User;
        $userdata->name = $user['given_name'] . $user['family_name'];
        $userdata->email = $user->email;
        $userdata->password = Hash::make(rand('999999','100000'));
        $userdata->ip = $_SERVER['REMOTE_ADDR'];
        $userdata->googleid = $user->id;
        $userdata->strtotime = strtotime($now->format('Y-m-d H:i:s'));
        $userdata->save();
    }

    // session me pura user store karo
    session()->put('google_user', $userdata->toArray()); 
    session()->put('user_id', $userdata->id);

    $this->moveGuestCartToDB($userdata->id);

    $after = json_encode($userdata);
    $before = json_encode($userdata);
    $adduser = $userdata->id;
    $user_id = $userdata->id;
    insertLogsAPIuser($user_id,'5','Google Login',$adduser,'','',$after,$before); 

    if(!empty(session('currenturl'))){
        return redirect(session('currenturl'))->with('success', 'Login Successfully');
    } else {
        return redirect(asset('/'))->with('success', 'Login Successfully');
    }
}

    
    
    
// public function googlelogin(Request $request){
//   $now = Carbon::now('Asia/Kolkata'); 
//          try {
//             $user = Socialite::driver('google')->stateless()->user();
//         } catch (Throwable $e) {
//             return redirect('login')->with('error', 'Google authentication failed.');
//         }

//         $userdata = User::where('email', $user->email)->first();

//         if ($userdata) {
           
//         $userdata->googleid=$user->id;
//         $userdata->save();
           
//         } else {
//         $userdata=new User;
//         $userdata->name=$user['given_name'].$user['family_name'];
//         $userdata->email=$user->email;
//         $userdata->password=Hash::make(rand('999999','100000'));
//         $userdata->ip=$_SERVER['REMOTE_ADDR'];
//         $userdata->googleid=$user->id;
//         $userdata->strtotime=strtotime($now->format('Y-m-d H:i:s'));
//         $userdata->save();
//         }
//         session()->put('user_id', $userdata->id);
//         $this->moveGuestCartToDB($userdata->id);
//         $after = json_encode($userdata);
//      $before = json_encode($userdata);
//     $adduser=$userdata->id;
//     $user_id=$userdata->id;
//          insertLogsAPIuser($user_id,'5','Google Login',$adduser,'','',$after,$before); 
        
//         if(!empty(session('currenturl'))){
//         return redirect(session('currenturl'))->with('success', 'Login Successfully');
//         }else{
//         return redirect(asset('/'))->with('success', 'Login Successfully');
//         }
 
//     }
    
    


   
}

