<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Store;
use App\Models\Team;
use App\Models\Slider;
use App\Models\User;
use Carbon\Carbon;
use App\Models\Websitesetting;
use App\Models\Service;
use Illuminate\Support\Facades\Cookie;

use App\Models\Newsletter;
use App\Models\tbl_cart;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Hash;
use App\Models\Testimonial;
use App\Models\tbl_blog;
use App\Models\tbl_order;
use App\Models\tbl_service_order;
use App\Models\MyAddress;
use App\Models\Serviceallottedcity;
use App\Models\Subservice;
use App\Models\Page;
use DB;


class FrontendController extends Controller
{
    public function index(){
        
    $data['settings'] = DB::table('additionalsettings')->where('id','1')->first();
    $data['slider'] = Slider::where('status', '1')->get();
    $data['blog'] = tbl_blog::where('status', '1')->limit(3)->get();
    $data['services'] = DB::table('services')
       // ->where('status', '1')
        ->orderBy('ordering_by', 'asc')
        ->get();
    return view('frontend.index', $data);
}

  //Index1
    function ordersucsess(){
        return view('frontend.ordersucsess');
    }

    
    //Index1
    function index1(){
        $data['slider']=Slider::where('status','1')->get();
        return view('frontend.index1',$data);
    }
    function index2(){
        $data['slider']=Slider::where('status','1')->get();
        return view('frontend.index2',$data);
    }
    function index3(){
        $data['slider']=Slider::where('status','1')->get();
        return view('frontend.index3',$data);
    }
    //Index1
    
    
    
   public function basiccheck(){
       
   if (!empty(session('user_id'))) {
       
     $data['cart'] = tbl_cart::where('user_id', session('user_id'))->get();
    }else{
        
        $data['cartcookies'] = json_decode($_COOKIE['cart_items'] ?? '[]', true);
   }
   $data['address']=MyAddress::where('user_id',session('user_id'))->orderBy('id','desc')->get();
   $data['allotted'] = Websitesetting::where('id', '1')->first();
   $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
   $data['userdata'] = DB::table('users')->where('status','1')->where('id',session('user_id'))->first();
   return view('frontend.basiccheck',$data);
  }




    
    
    
    function aboutus(){
        $data['about']=Page::where('status','1')->where('id','1')->first();
        $data['team']=Team::where('status','1')->get();
        $data['testimonial']=Testimonial::where('status','1')->get();
        return view('frontend.aboutus',$data);
    }
    
    function notfound(){
        return view('frontend.notfound');
    }
   
    function contact(){
        return view('frontend.contact');
    }
    function service(){
        return view('frontend.service');
    }

public function store(Request $request)
{
    $data['state'] = DB::table('tbl_states')->where('s_status', '1')->get();

    // Stores with join
    $data['store'] = DB::table('stores')
                        ->join('tbl_states', 'stores.state', '=', 'tbl_states.state_id')
                        ->join('tbl_cities', 'stores.city', '=', 'tbl_cities.city_id')->select('stores.*', 'tbl_states.name as state_name', 'tbl_cities.name as city_name')->when($request->state, function($query, $state) {
                            return $query->where('stores.state', $state);
                        })
                        ->when($request->city, function($query, $city) {
                            return $query->where('stores.city', $city);
                        })
                        ->where('stores.status', '1')
                        ->get();

    // Pass selected filters to view
    $data['filterstate'] = $request->state;
    $data['filtercity'] = $request->city;

    return view('frontend.store', $data);
}



public function serchproduct(Request $request)
{
    $products = $request->product;
    $cityid = cookiescity();

    // ===== SERVICES =====
    $service = Serviceallottedcity::join('services', 'services.id', '=', 'serviceallottedcities.serviceid')
        ->where('services.status', '1')
        ->where('serviceallottedcities.city_id', $cityid)
        ->where('serviceallottedcities.status', '1')
        ->where('serviceallottedcities.service_type', '1')
        ->where('services.title', 'like', '%' . $products . '%')
        ->get();

    // ===== PLANS =====
    $plans = Serviceallottedcity::join('service_plans', 'service_plans.id', '=', 'serviceallottedcities.serviceid')
        ->where('service_plans.status', '1')
        ->where('serviceallottedcities.city_id', $cityid)
        ->where('serviceallottedcities.status', '1')
        ->where('serviceallottedcities.service_type', '4')
        ->where('service_plans.title', 'like', '%' . $products . '%')
        ->get();

    // ===== PRODUCTS =====
    $productList = Serviceallottedcity::join('tbl__products', 'tbl__products.id', '=', 'serviceallottedcities.serviceid')
        ->where('tbl__products.status', '1')
        ->where('serviceallottedcities.city_id', $cityid)
        ->where('serviceallottedcities.status', '1')
        ->where('serviceallottedcities.service_type', '5')
        ->where('tbl__products.product_item', 'like', '%' . $products . '%')
        ->inRandomOrder()
        ->get();

    $html = "<table class='table table-bordered'>";

    // ===== FIRST SHOW SERVICES =====
    if(count($service) > 0){
        $html .= '<tr><th>Services</th></tr>';
        foreach($service as $sdata){
               $serviceUrl = url('service/' . $sdata->slug);
            $html .= '<tr>
                        <td>
                            <a href="'.$serviceUrl.'" class="search-item text-dark" style="color:black !important;" data-id="'.$sdata->id.'">
                                '.$sdata->title.'
                            </a>
                        </td>
                      </tr>';
        }
    }

    // ===== THEN SHOW PLANS =====
    if(count($plans) > 0){
        $html .= '<tr><th>Plans</th></tr>';
        foreach($plans as $plan){
            $html .= '<tr>
                        <td>
                            <a href="javascript:void(0);" class="search-item text-dark" style="color:black !important;" data-id="'.$plan->id.'">
                                '.$plan->title.'
                            </a>
                        </td>
                      </tr>';
        }
    }

    // ===== THEN SHOW PRODUCTS =====
    if(count($productList) > 0){
        $html .= '<tr><th>Products</th></tr>';
        foreach($productList as $pdata){
            $html .= '<tr>
                        <td>
                            <a href="javascript:void(0);" class="search-item text-dark" style="color:black !important;" data-id="'.$pdata->id.'">
                                '.$pdata->product_item.'
                            </a>
                        </td>
                      </tr>';
        }
    }

    $html .= "</table>";

   if(count($service) == 0 && count($plans) == 0 && count($productList) == 0){
    $html = "
    <div style='
        display:flex; 
        align-items:center; 
        justify-content:center; 
        flex-direction:column;
        padding:25px 15px;
        margin-top:10px;
        background:linear-gradient(145deg, #ffffff, #f6f8fc);
        border-radius:12px;
        box-shadow:0 4px 12px rgba(0,0,0,0.08);
        transition:all 0.3s ease;
    '>
        <i class='fa fa-search' style='
            font-size:36px; 
            color:#2e55a2;
            margin-bottom:12px;
            text-shadow:0 0 10px rgba(46,85,162,0.2);
            animation:pulse 1.8s infinite ease-in-out;
        '></i>
        <p style='
            font-size:16px; 
            font-weight:600; 
            color:#333; 
            margin:0;
            letter-spacing:0.3px;
        '>
            No results found
        </p>
        <div style='
            width:60px; 
            height:3px; 
            background:linear-gradient(90deg, #2e55a2, #f37101);
            margin-top:8px; 
            border-radius:2px;
        '></div>

        <style>
            @keyframes pulse {
                0% { transform: scale(1); opacity: 1; }
                50% { transform: scale(1.08); opacity: 0.9; }
                100% { transform: scale(1); opacity: 1; }
            }
        </style>
    </div>";
}


    return response()->json(['data' => $html]);
}


public function addtocart(Request $request)
{
    $plan_id = $request->plan_id;
    $quantity = $request->quantity ?? 1;
    $user_id = session('user_id') ?? null;

    $plan = Serviceallottedcity::leftJoin('service_plans', 'service_plans.id', '=', 'serviceallottedcities.serviceid')
        ->where('serviceallottedcities.serviceid', $plan_id)
        ->where('serviceallottedcities.status', '1')
        ->where('serviceallottedcities.service_type', '4')
        ->first([
            'serviceallottedcities.*',
            'service_plans.service_id',
            'service_plans.subservice_id',
        ]);

    if ($plan) {
        $type = 4;
        $price = $plan->price ?? null;
        $service_id = $plan->service_id;
        $subservice_id = $plan->subservice_id;
        $plan_product_id = $plan->serviceid;
        $city_id = $plan->city_id;
    } else {
        $product = Serviceallottedcity::leftJoin('tbl__products', 'tbl__products.id', '=', 'serviceallottedcities.serviceid')
            ->where('serviceallottedcities.serviceid', $plan_id)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '5')
            ->first([
                'serviceallottedcities.*',
                'tbl__products.service_id',
                'tbl__products.subservice_id',
               
            ]);

        if (!$product) {
            $items_count = $user_id 
                ? Cart::where('user_id', $user_id)->count() 
                : (!empty($_COOKIE['cart_items']) ? count(json_decode(stripslashes($_COOKIE['cart_items']), true)) : 0);

            return response()->json([
                'error' => '0',
                'successmsg' => 'Plan/Product not found',
                'items' => $items_count
            ]);
        }

        $type = 5;
        $price = $product->price ?? null;
        $service_id = $product->service_id;
        $subservice_id = $product->subservice_id;
        $plan_product_id = $product->serviceid;
        $city_id = $product->city_id;
    }

    if ($user_id) {
        // Logged-in user
        $cartdata = Cart::where('user_id', $user_id)->where('plan_product_id', $plan_product_id)->first();

        if ($cartdata) {
            $items_count = Cart::where('user_id', $user_id)->count();
            return response()->json([
                'error' => '0',
                'successmsg' => 'Product Already Exist',
                'items' => $items_count
            ]);
        }

        $cart = new Cart;
        $cart->plan_product_id = $plan_product_id;
        $cart->user_id = $user_id;
        $cart->service_id = $service_id;
        $cart->subservice_id = $subservice_id;
        $cart->city_id = $city_id;
        $cart->type = $type;
        $cart->price = $price;
        $cart->quantity = $quantity;
        $cart->ip = $_SERVER['REMOTE_ADDR'];
        $cart->strtotime = CurrentTimestamp()['strtotime'];
        $cart->save();

        if (!empty($_COOKIE['cart_items'])) {
            $saved_cart_items = json_decode(stripslashes($_COOKIE['cart_items']), true);
            foreach ($saved_cart_items as $pid => $item) {
                $exists = Cart::where('user_id', $user_id)
                              ->where('plan_product_id', $pid)
                              ->first();
                if (!$exists) {
                    $c = new Cart;
                    $c->plan_product_id = $pid;
                    $c->user_id = $user_id;
                    $c->service_id = $item['service_id'];
                    $c->subservice_id = $item['subservice_id'];
                    $c->city_id = $item['city_id'];
                    $c->type = $item['type'];
                    $c->price = $item['price'];
                    $c->quantity = $item['quantity'];
                    $c->ip = $_SERVER['REMOTE_ADDR'];
                    $c->strtotime = CurrentTimestamp()['strtotime'];
                    $c->save();
                }
            }
            setcookie('cart_items', '', time() - 3600, '/');
        }

        $items_count = Cart::where('user_id', $user_id)->count();

        return response()->json([
            'success' => '1',
            'successmsg' => 'Successfully Added To Cart',
            'items' => $items_count
        ]);

    } else {
        $time = time() + 365*24*60*60;
        $saved_cart_items = !empty($_COOKIE['cart_items']) ? json_decode(stripslashes($_COOKIE['cart_items']), true) : [];

        if (array_key_exists($plan_product_id, $saved_cart_items)) {
            return response()->json([
                'error' => '0',
                'successmsg' => 'Product Already Exist',
                'items' => count($saved_cart_items)
            ]);
        }

        $saved_cart_items[$plan_product_id] = [
            'service_id' => $service_id,
            'subservice_id' => $subservice_id,
            'city_id' => $city_id,
            'type' => $type,
            'price' => $price,
            'quantity' => $quantity
        ];

        setcookie('cart_items', json_encode($saved_cart_items), $time, '/');

        return response()->json([
            'success' => '1',
            'successmsg' => 'Successfully Added To Cart',
            'items' => count($saved_cart_items)
        ]);
    }
}

///Account 

function myaccount(){
  
    if(!empty(session('user_id'))){
      $data['userdata']=User::where('id',session('user_id'))->first();
      return view('frontend.account.myaccount',$data);
      }
      else{
          return redirect(asset('login'))->with('error','Please Login');
      }
}

function profileupdate(){
  
    if(!empty(session('user_id'))){
      $data['userdata']=User::where('id',session('user_id'))->first();
      $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
      $data['allotted'] = Websitesetting::where('id', '1')->first();
      return view('frontend.account.profileedit',$data);
      }
      else{
          return redirect(asset('login'))->with('error','Please Login');
      }
}

function userchangepassword(){
    
   if(!empty(session('user_id'))){
       
      return view('frontend.account.changepassword');
      }
      else{
          return redirect(asset('login'))->with('error','Please Login');
      }
}

function userchangepasswordupdate(Request $request){
   
    $userId = session('user_id');
    $user = User::where('id', $userId)->first();

    if(!$user){
        return redirect()->back()->with('error', 'User not found');
    }

    if(!Hash::check($request->old_password, $user->password)){
        return redirect()->back()->with('error', 'Old password is incorrect');
    }

    if($request->new_password !== $request->confirm_password){
        return redirect()->back()->with('error', 'New Password and Confirm Password do not match');
    }
    $user->password = Hash::make($request->new_password);
    $user->save();

    return redirect()->back()->with('success', 'Change Password updated successfully');
}


function address(){
    
  if(!empty(session('user_id'))){
      
      $data['address']=MyAddress::where('status','1')->where('user_id',session('user_id'))->get();
           $data['allotted'] = Websitesetting::where('id', '1')->first();
          $data['userdata'] = User::where('id',session('user_id'))->first();
          $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
      return view('frontend.account.address',$data);
  }else{
      return redirect(asset('login'))->with('error','Please Login');
  }
}

// function addressadd(){

//       if(!empty(session('user_id'))){
     
//           return view('frontend.account.addressadd',$data);
//       }
//       else{
//           return redirect(asset('login'))->with('error','Please Login');
//       }
// }

function addresscreate(Request $request){
     $create= new MyAddress;
     $create->user_id=session('user_id');
     $create->first_name=$request->first_name;
     $create->last_name=$request->last_name??'';
     $create->email=$request->email??'';
     $create->phone_number=$request->phone_number2;
     $create->phonecode=ltrim($request->phonecode2, '+');
     $create->countries=$request->countries;
     $create->state=$request->state;
     $create->city=$request->city;
     $create->pincode=$request->pincode;
     $create->address=$request->address;
     $create->company_name=$request->company_name;
     $create->gst_number=$request->gst_number;
     $create->ip = CurrentTimestamp()['ip'];
     $create->strtotime = CurrentTimestamp()['strtotime'];
     $create->created_at = CurrentTimestamp()['datetime'];
     $create->updated_at = CurrentTimestamp()['datetime'];
     $create->save();
     if($request->addresstype==1){
     return redirect(asset('address'))->with('success','Address add successfully');
    } else{
     return redirect()->back()->with('success',' Check Out Address add successfully');
    }
    
}

function addressdelete(Request $request){
    $id=Crypt::decrypt($request->id);
    $delete = MyAddress::find($id);
    $delete->delete();
    return redirect()->back()->with('success', 'Address delete successfully');
}


function addressupdate(Request $request){
     $id=Crypt::decrypt($request->id);
     $update=  MyAddress::where('id',$id)->first();
     $update->user_id=session('user_id');
     $update->first_name=$request->first_name;
     $update->last_name=$request->last_name??'';
     $update->email=$request->email??'';
     $update->phone_number=$request->phone_number3;
     $update->phonecode=ltrim($request->phonecode, '+');
     $update->countries=$request->countries;
     $update->state=$request->state;
     $update->city=$request->city;
     $update->pincode=$request->pincode;
     $update->address=$request->address;
     $update->company_name=$request->company_name;
     $update->gst_number=$request->gst_number;
     $update->ip = CurrentTimestamp()['ip'];
     $update->strtotime = CurrentTimestamp()['strtotime'];
     $update->created_at = CurrentTimestamp()['datetime'];
     $update->updated_at = CurrentTimestamp()['datetime'];
     $update->save();
     if($request->addresstype==1){
     return redirect(asset('address'))->with('success','Address update successfully');
    } else{
     return redirect()->back()->with('success',' Check Out Address update successfully');
    }
}


function addressedit(Request $request){
    
   $id=Crypt::decrypt($request->id);
   $data['address'] = MyAddress::where('id',$id)->first();
   $data['allotted'] = Websitesetting::where('id', '1')->first();
   $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
   return view('frontend.account.addressedit',$data);
}


public function userprofileedit(Request $request)
{
    $user_id = session('user_id');
    $update = User::where('id', $user_id)->first();

    if (!$update) {
        return redirect()->back()->with('error', 'User not found.');
    }
    $update->name = $request->name;
    $update->company_name = $request->company_name;
    $update->countries = $request->countries;
    $update->state = $request->state;
    $update->city = $request->city;
    $update->pincode = $request->pincode;
    $update->gst_number = $request->gst_number;
    $update->address = $request->address;
    $uploadPath = public_path('uploads/user');

    if ($request->hasFile('profile')) {
        if ($update->profile && file_exists($uploadPath . '/' . $update->profile)) {
            unlink($uploadPath . '/' . $update->profile);
        }

        $file = $request->file('profile');
        $extension = $file->getClientOriginalExtension();
        $imgName = 'profile_' . time() . '.' . $extension;
        $file->move($uploadPath, $imgName);
        $update->profile = $imgName;
    }

    $update->save();

    return redirect()->back()->with('success', 'Profile updated successfully');
}

public function updatewithotp(Request $request)
{
    $now = Carbon::now('Asia/Kolkata');
    $type = $request->type; // 1 = mobile, 2 = email
    $value = $request->value;

    if (!$value) {
        return response()->json([
            'results' => 'error',
            'message' => ($type == 1) ? 'Phone number is required.' : 'Email is required.'
        ]);
    }

    if ($type == 1) {
        $exists = DB::table('users')->where('phone_number', $value)->exists();
        if ($exists) {
            return response()->json([
                'results' => 'error',
                'message' => 'This phone number already exists.'
            ]);
        }
    } elseif ($type == 2) {
        $exists = DB::table('users')->where('email', $value)->exists();
        if ($exists) {
            return response()->json([
                'results' => 'error',
                'message' => 'This email already exists.'
            ]);
        }
    } else {
        return response()->json([
            'results' => 'error',
            'message' => 'Invalid type value.'
        ]);
    }


    $verify = Websitesetting::where('id', 1)->first();
    $verifytype = $verify->user_login_with_opt_apply ?? null;

    if ($verifytype == '1') {
      
        return userverifyUserOtp($value, $type);
    }

    return response()->json([
        'results' => 'error',
        'message' => 'OTP verification is disabled in settings.'
    ]);
}


public function updateotpexpire(Request $request)
{
    $now = Carbon::now('Asia/Kolkata');
    $type = $request->type; 
    $value = $request->value;

    if (!$value) {
        return response()->json([
            'results' => 'error',
            'message' => ($type == 1) ? 'Phone number is required.' : 'Email is required.'
        ]);
    }
    $otp = '123456';
//   $otp = rand(100000, 999999);
    $key = ($type == 1) ? 'mobile' : 'email';

    $exists = DB::table('tbl_user_otpverifies')->where($key, $value)->first();
    if ($exists) {
        DB::table('tbl_user_otpverifies')->where($key, $value)->update([
            'otp' => $otp,
            'strtotime' => CurrentTimestamp()['strtotime'],
            'updated_at' => $now->format('Y-m-d H:i:s')
        ]);

        return response()->json([
            'results' => 'expired',
            'message' => 'OTP Expired.'
        ]);
    } else {
        return response()->json([
            'results' => 'error',
            'message' => 'No OTP found for this ' . (($type == 1) ? 'mobile number.' : 'email.')
        ]);
    }
}



public function updatewithpassword(Request $request)
{
    $now = Carbon::now('Asia/Kolkata');
    $value = $request->number;           
    $otp = $request->otp;                 
    $type = $request->loginType;  // 1 = phone, 2 = email
    $phoneCode = $request->phone_code ?? null;

    if (empty($otp)) {
        return response()->json([
            'success' => '0',
            'message' => 'OTP is required',
            'errorField' => 'otp'
        ]);
    }

    if ($type == '2') { 
        $otpRecord = DB::table('tbl_user_otpverifies')->where('email', $value)->where('otp', $otp)->first();
        if (!$otpRecord) {
            return response()->json([
                'success' => '0',
                'message' => 'Invalid OTP. Please try again.',
                'errorField' => 'otp'
            ]);
        }

        $checkEmail = DB::table('users')->where('email', $value)->first();
        if ($checkEmail) {
            return response()->json([
                'success' => '0',
                'message' => 'This email is already registered.',
                'errorField' => 'number'
            ]);
        }

        DB::table('users')->where('id', session('user_id'))->update([
            'email' => $value,
            'verify_status' => 1
        ]);

        DB::table('tbl_user_otpverifies')->where('id', $otpRecord->id)->update([
            'verify_status' => 1,
            'updated_at' => $now->format('Y-m-d H:i:s')
        ]);

        return response()->json([
            'success' => '1',
            'successmsg' => 'Email verified & updated successfully.'
        ]);

    } elseif ($type == '1') { 
        $otpRecord = DB::table('tbl_user_otpverifies')->where('mobile', $value)->where('otp', $otp)->first();
        if (!$otpRecord) {
            return response()->json([
                'success' => '0',
                'message' => 'Invalid OTP. Please try again.',
                'errorField' => 'otp'
            ]);
        }

        $checkPhone = DB::table('users')->where('phone_number', $value)->first();
        if ($checkPhone) {
            return response()->json([
                'success' => '0',
                'message' => 'This phone number is already registered.',
                'errorField' => 'number'
            ]);
        }

        // Update phone only in users table
        DB::table('users')->where('id', session('user_id'))->update([
            'phone_number' => $value,
            'phonecode' => ltrim($phoneCode, '+'),
            'verify_status' => 1
        ]);

        return response()->json([
            'success' => '1',
            'successmsg' => 'Phone verified & updated successfully.'
        ]);

    } else {
        return response()->json([
            'success' => '0',
            'message' => 'Invalid login type.'
        ]);
    }
}


public function newsletterAdd(Request $request)
{
    $user_id=session('user_id');
    $email = trim($request->email);
    $now = Carbon::now('Asia/Kolkata'); 

    if (empty($email)) {
        return response()->json([
            'status' => false,
            'message' => 'Email is required.'
        ]);
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return response()->json([
            'status' => false,
            'message' => 'Enter a valid email address.'
        ]);
    }

    $newsletter = Newsletter::where('email', $email)->first();

    if ($newsletter) {
        if ($newsletter->newsletter_status == 1) {
            return response()->json([
                'status' => false,
                'message' => 'You are already subscribed to our newsletter.'
            ]);
        } else {
            
            $newsletter->newsletter_status = 1;
            $newsletter->user_id = $user_id;
            $newsletter->ip =  $_SERVER['REMOTE_ADDR'];
            $newsletter->strtotime = strtotime($now->format('Y-m-d H:i:s'));
            $newsletter->created_at = $now->format('Y-m-d H:i:s');
            $newsletter->updated_at = $now->format('Y-m-d H:i:s');
            $newsletter->save();

            return response()->json([
                'status' => true,
                'message' => 'Subscribed  successfully.'
            ]);
        }
    } else {
        Newsletter::create([
            'email' => $email,
            'ip' =>  $_SERVER['REMOTE_ADDR'],
            'user_id' =>  $user_id,
            'strtotime' =>strtotime($now->format('Y-m-d H:i:s')),
            'created_at' => $now->format('Y-m-d H:i:s'),
            'updated_at' => $now->format('Y-m-d H:i:s'),
            'newsletter_status' => 1
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Subscribed successfully!'
        ]);
    }
}

public function search(Request $request)
{
    $data = searchData($request->get('search'));
    $data['settings'] = DB::table('additionalsettings')->where('id','1')->first();
    return view('frontend.search', $data);
}

public function commonlocation(Request $request)
{
    

   
    $query = $request->input('query') ?? null;
    $slug = $request->slug ?? null;
     $searchmod = $request->searchmod;

    $settings = DB::table('additionalsettings')->where('id', '1')->first();
    $status = $request->status;
    $ajaxPageId = $request->ajaxpage_id;

    $location = getSettingsLocation();

    if ($status == '0') {
        $cookieLocation = json_decode(Cookie::get('current_location'), true);
        $latitude  = $cookieLocation['lat'] ?? $settings->latitude;
        $longitude = $cookieLocation['lng'] ?? $settings->longitude;
    } else {
        $latitude  = 26.9124;
        $longitude = 75.7873;
        // $latitude  = $request->latitude;
        // $longitude = $request->longitude;
        $location_api = $request->location_api ?? null; 
    }

    if ($settings->location_api == 2) {
        $result = googleapiloation($latitude, $longitude);
        if ($searchmod == '2') {
            $result = handleSearch($request);
        }else{
        
        $result = submithandleSearch($request);  
      
        }
    } else {
        $result = openstreetmaplocation($latitude, $longitude);
    }

  
      $cityId = $result['city_id'] ?? null;
      

    if ($settings->location_functlity == '1') {
        return response()->json([
            'status'     => 'success',
            'div_status' => '1',
            'city_id'    => $cityId,
        ]);
    } else {
        $sectionHtml1 = $sectionHtml2 = $sectionHtml3 = '';
        $servicedeatilsChildsection = $servicedeatilsSerivePlansection = $servicedeatilsSeriveProductsection = '';
        $Subservicesection = $productsection = $searchSetion =  $plan_product=$relatedplan='';
        
        // Header section
        $sectionHtmlli = $this->ajaxformation($cityId, 1, 1, 1);

        if ($ajaxPageId == '1') {
            $sectionHtml1 = $this->homesection($cityId, 1);
            $sectionHtml2 = $this->homesection($cityId, 2);
            $sectionHtml3 = $this->homesection($cityId, 3);
        } elseif ($ajaxPageId == '2') {
            // Pass slug explicitly to ajaxformation
            $servicedeatilsChildsection = $this->ajaxformation($cityId, 1, 1, 2, $slug);
            $servicedeatilsSerivePlansection = $this->ajaxformation($cityId, 2, 2, 2, $slug);
            $servicedeatilsSeriveProductsection = $this->ajaxformation($cityId, 3, 3, 2, $slug);
        } elseif ($ajaxPageId == '3') {
            $Subservicesection = $this->ajaxformation($cityId, 4, 4, 2, $slug);
            $productsection = $this->ajaxformation($cityId, 5, 5, 2, $slug);
        } elseif ($ajaxPageId == '4') {
            $searchSetion = $this->ajaxformation($cityId, 6, 6, 2,$query);
           
        
        } elseif ($ajaxPageId == '5') {
            $plan_product = $this->ajaxformation($cityId, 7, 7, 2,$slug);
            $relatedplan = $this->ajaxformation($cityId, 8, 8, 2,$slug);
           
        }

        return response()->json([
            'status'       => 'success',
            'div_status'   => '2',
            'city_id'      => $cityId,
            'section1'     => $sectionHtml1,
            'section2'     => $sectionHtml2,
            'section3'     => $sectionHtml3,
            'servicedeatilsChildsection'     => $servicedeatilsChildsection,
            'servicedeatilsSerivePlansection' => $servicedeatilsSerivePlansection,
            'servicedeatilsSeriveProductsection' => $servicedeatilsSeriveProductsection,
            'productsection' => $productsection,
            'searchSetion' => $searchSetion,
            'plan_product' => $plan_product,
            'relatedplan' => $relatedplan,
            'Subservicesection' => $Subservicesection,
            'header_html'  => $sectionHtmlli,
            'slug'         => $slug,
            'display_name' => $result['display_name'] ?? 'Select Location',
            'address'      => $result['address'] ?? [],
            'data'         => $result['data'] ?? [],
        ]);
    }
}


// ajaxformation function
function ajaxformation($cityId, $sectionIndex = 1, $type = 1, $viewType = '1', $slug = null, $query = null)
{
    $service = Service::join('serviceallottedcities as sac', 'sac.serviceid', '=', 'services.id')
        ->where('services.status', '1')
        ->where('sac.city_id', $cityId)
        ->where('sac.status', '1')
        ->where('sac.service_type', '1')
        ->select('services.title', 'services.slug')
        ->get();

    if ($service->isEmpty()) {
        return '<li><a href="javascript:void(0);" class="text-muted">No services available for this city.</a></li>';
    }

    $childservice = childservice($slug);
    $serviceplan = serviceplans($slug);
    $product = serviceproducts($slug);
    $singleserviceidproduct = singleserviceidproduct($slug);
    $subservice = servicesubservices($slug);
    $relatedserviceplan = relatedserviceplan($slug);
    $searchdata = searchData($query);

    $viewPath = $viewType == '2' ? "frontend.homesection.servicedetailspage" : "frontend.homesection.homeheader";


    return view($viewPath, [
        'service' => $service,
        'childservice' => $childservice,
        'serviceplan' => $serviceplan,
        'subservice' => $subservice,
        'searchdata' => $searchdata,
        'relatedserviceplan' => $relatedserviceplan,
        'singleserviceidproduct' => $singleserviceidproduct,
        'product' => $product,
        'cityId' => $cityId,
        'type' => $type,
        'sectionIndex' => $sectionIndex
    ])->render();
}


public function homesection($cityId = null, $sectionIndex = 1)
{
    if (!$cityId) {
        return '<div class="text-center text-warning p-4">City ID is required for section ' . $sectionIndex . '.</div>';
    }

    $setting = Websitesetting::first();

    if (!$setting || empty($setting->services)) {
        return '<div class="text-center text-muted p-4">Website settings not found or empty.</div>';
    }

    $dbServices = json_decode($setting->services, true);
    $value = $dbServices[$sectionIndex - 1] ?? 0;

    if (!$value || $value == 0) {
        return '<div class="text-center text-muted p-4">No service configured for section ' . $sectionIndex . '.</div>';
    }

    $service = Service::join('serviceallottedcities as sac', 'sac.serviceid', '=', 'services.id')
        ->where('services.id', $value)
        ->where('services.status', '1')
        ->where('sac.city_id', $cityId)
        ->where('sac.status', '1')
        ->where('sac.service_type', '1')
        ->select('services.id', 'services.title')
        ->first();

    if (!$service) {
        return '<div class="text-center text-warning p-4">No service found for section ' . $sectionIndex . ' (City ID: ' . $cityId . ').</div>';
    }

    $subservices = Serviceallottedcity::join('subservices', 'subservices.id', '=', 'serviceallottedcities.serviceid')
        ->where('subservices.service_id', $service->id)
        ->where('subservices.status', '1')
        ->where('serviceallottedcities.city_id', $cityId)
        ->where('serviceallottedcities.status', '1')
        ->where('serviceallottedcities.service_type', '2')
        ->select('subservices.*')
        ->get();

    if ($subservices->isEmpty()) {
        return '<div class="text-center text-warning p-4">No subservices found for this city (City ID: ' . $cityId . ').</div>';
    }

    return view("frontend.homesection.section{$sectionIndex}", [
        'service' => $service,
        'subservices' => $subservices,
        'cityId' => $cityId,
    ])->render();
}










function order(Request $request){

  $paymentmode = $request->paymentmode; 

    $product = $request->product; 
    $promocode = $request->promocode;
    $detail = $request->detail; 
    $userid = $request->user_id;
   
    $amounttopay = $request->amounttopay ?? 0;

    if(empty($product) || count($product) == 0){
        return response()->json(['status'=>'error','msg'=>'Product not found']);
    }

    if(empty($userid)){
        return response()->json(['status'=>'error','msg'=>'User ID Required']);
    }

    // User handling
    $user = User::where('id', $userid)->where('status', '1')->first();
    if(!$user){
        $user = new User;
        $user->email = $request->email ?? '';
        $user->name = $detail[0] ?? ''; // full name
        $user->phone_number = $detail[1] ?? '';
        $user->phonecode = $detail[2] ?? '91';
        $user->countries = $detail[3] ?? '';
        $user->state = $detail[4] ?? '';
        $user->city = $detail[5] ?? '';
        $user->pincode = $detail[6] ?? '';
        $user->company_name = $detail[7] ?? '';
        $user->gst_number = $detail[8] ?? '';
        $user->status = '1';
        $user->password = bcrypt('123456');
        $user->ip = CurrentTimestamp()['ip'];
        $user->strtotime = CurrentTimestamp()['strtotime'];
        $user->save();
    }
    $userid = $user->id;

    // Address handling
    if(!empty($detail[0])){
        $address = MyAddress::where('id', $detail[0])->where('user_id',$userid)->where('status','1')->first();
        if(!$address){
            $address = new MyAddress;
            $address->streetaddress = $detail[1] ?? '';
            $address->name = $detail[0] ?? ''; // full name
            $address->phone = $detail[2] ?? '';
            $address->userid = $userid;
            $address->ip = CurrentTimestamp()['ip'];
            $address->strtotime = CurrentTimestamp()['strtotime'];
            $address->save();
        }
        $useraddress = $address->id;
    } else {
        return response()->json(['status'=>'error','msg'=>'Address Not Found']);
    }

    // Create Order in tbl_order
    $order = new tbl_order;
    $order->orderid = rand(100000,999999);
    $order->user_id = $userid;
    $order->addressid = $useraddress;
    $order->bookingdate = CurrentTimestamp()['date'];
    $order->bookingtime = date('H:i:s');
    $order->paymentstatus = '0';
    $order->payment_mode = $paymentmode;
    $order->address = $address->streetaddress;
    $order->user_number = $user->phone_number;
    $order->user_name = $user->name; // full name
    $order->user_email = $user->email;
    $order->pincode = $address->pincode;
    $order->totalamount = $amounttopay;
    $order->ip = CurrentTimestamp()['ip'];
    $order->strtotime = CurrentTimestamp()['strtotime'];
    $order->save();

    $orderprimaryid = $order->id;

    foreach($product as $p){
        $serviceorder = new tbl_service_order;
        $serviceorder->order_id = $orderprimaryid;
        $serviceorder->user_id = $userid;
        $serviceorder->service_product_id = $p['id'] ?? null;
        $serviceorder->type = $p['type'] ?? null;
        $serviceorder->amount = $amounttopay;
        $serviceorder->serviceorder_id = rand(1000000000,9999999999);
        $serviceorder->quantity = $p['quantity'] ?? 1;
        $serviceorder->city_id = $p['city_id'] ?? null;
        $serviceorder->orderprimary_id = $orderprimaryid;
        $serviceorder->status = '1';
        $serviceorder->ip = $_SERVER['REMOTE_ADDR'];
        $serviceorder->strtotime = CurrentTimestamp()['strtotime'];
        $serviceorder->save();
    }

    return response()->json(['status'=>'success','msg'=>'Order placed successfully']);
}




}

