<?php

namespace App\Http\Controllers\backend\users;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use App\Models\User;
use App\Models\Websitesetting;
use App\Models\tbl_cart;
use App\Models\user_logs;
use App\Models\MyAddress;
use App\Models\tbl_permission;
use App\Models\Serviceallottedcity;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class UsersController extends Controller
{
    public function users(){
        return view('backend.users.users');
    }
    
    
   public function usersajax(Request $request){
    $filterData = [
        'name'   => $request->name,
        'email'  => $request->email,
        'number' => $request->number,
        'start'  => $request->start ?? 0,
        'length' => $request->length ?? 10
    ];

    $draw   = $request->draw ?? 0;
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $searchValue = $request->search['value'] ?? null;

    $usersdata = User::usersajax(
        $filterData['start'], 
        $searchValue, 
        $columnSortOrder, 
        $columnName, 
        $columnIndex, 
        null, 
        1, 
        $filterData
    );

    $userscount = User::usersajax(
        $filterData['start'], 
        $searchValue, 
        $columnSortOrder, 
        $columnName, 
        $columnIndex, 
        null, 
        0, 
        $filterData
    );

    $data = [];
    $user_id = session('SUPERADMIN_ID');

    foreach ($usersdata as $row) {
        $action = '<ul class="action d-flex m-0" style="list-style-type: none;">';  
        $action .= '<li class="list-unstyled ms-1">';
        if(permission($user_id,'16','action_edit')){
            $action .= '<a class="btn actionedit viewbtn btn-sm" href="' . asset('backend/usersingleview/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-show anji me-0"></i></a>';
        }
        $action .= '</li>';
        $action .= '<li class="list-unstyled">';
        if(permission($user_id,'19','action_delete')){
            $action .= '<a href="' . asset('backend/usersdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i></a>';
        }
        $action .= '</li>';
          $action .= '<li class="list-unstyled ms-1" > ';
   if(permission($user_id,'16','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/frontenduseredit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';
        $action .= '</ul>';
        
         if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
  $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                 data-fid="11"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        $data[] = [
            "id" => $row->id,
            "profile" => '<a href="' . (!empty($row->profile) ? asset('uploads/user/' . $row->profile) : asset('frontend/assets/image/user.png')) . 
                        '" data-fancybox="images"><img src="' . (!empty($row->profile) ? asset('uploads/user/' . $row->profile) : asset('frontend/assets/image/user.png')) . 
                        '" class="profile-img" style="width:36px;"></a>',
            "name" => !empty($row->name) ? $row->name : "N/A",
            "email" => (!empty($row->email) || !empty($row->phone_number)) ? 
                       (!empty($row->email) ? $row->email : "N/A") . '<br>' . 
                       (!empty($row->phone_number) ? (!empty($row->phonecode) ? '+' . $row->phonecode . ' ' : '') . $row->phone_number : "N/A")
                       : "N/A",
            "status" => $status,
            "action" => $action
        ];
    }

    $tot_rows = DB::table('users')->count();

    echo json_encode([
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $userscount,
        "data" => $data
    ]);
}



 function frontenduseredit(Request $request){
  
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '16', 'action_edit');
    if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['userdata']=User::where('id',$id)->first();
            $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        return view('backend.users.useredit',$data);
    }
     $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }
    
    
public function userupdate(Request $request)
{
    
     $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '16', 'action_edit');
    if ($hasPermission) { 
       $id = Crypt::decrypt($request->id);
    $existingMobile = User::where('phone_number', $request->phone_number)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Phone Number');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $existingEmail = User::where('email', $request->email)->where('id', '!=', $id)->first();
    if ($existingEmail) {
        $message = fleshmessage(6,1,'Email ID');
        return redirect()->back()->with($message['status'],$message['message']);
    }
 
    $update = User::findOrFail($id);

   
    $before = json_encode($update);

    $update->name = $request->name;
    $update->company_name = $request->company_name;
    $update->phone_number = $request->phone_number;
    $update->email = $request->email;
    $update->verify_status = $request->verify_status;
    $update->countries = $request->countries;
    $update->state = $request->state;
    $update->city = $request->city;
    $update->pincode = $request->pincode;
      $update->user_id = $user_id;
    $update->gst_number = $request->gst_number;
    $update->address = $request->address;
  

    if ($request->hasFile('profile')) {
      
        if ($update->profile && file_exists(public_path('uploads/user/' . $update->profile))) {
            unlink(public_path('uploads/user/' . $update->profile));
        }

        $imgName = time() . '_brand_logo.' . $request->profile->extension();
        $request->profile->move(public_path('uploads/user'), $imgName);
        $update->profile = $imgName;
    }
    $update->created_by=$user_id;
    $update->panel_id='1';

    $update->updated_at = CurrentTimestamp()['datetime'];
        $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->save();

  
    $after = json_encode($update);

    insertLogsAPI($user_id, '3', 'User Profile Update', '16', '', $update->id, '', '', $after, $before, '');

    $message = fleshmessage(3, 1, 'User Profile');
    return redirect(url('backend/users'))->with($message['status'],$message['message']);
}
 $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}
    
  public function usersstatus(Request $request) {
    $id = $request->id;
    $status = User::find($id);

    if (!$status) {
        return response()->json(['success' => false, 'message' => ' Brand  not found'], 404);
    }
    $status->status = $request->status;
    $status->save();

    return response()->json(['success' => true]);
}   
    
    
    
function usersingleview(Request $request){
    
    $id = Crypt::decrypt($request->id);
      $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '16', 'action_edit');
     if ($hasPermission) { 
        $data['userdata']=User::where('id',$id)->first();
           insertLogsAPI($user_id,'2',' Single View Product','17','','','','','','',''); 
        return view('backend.users.usersingleview',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    
}   

/*  Cart Work*/ 


public function cartusersajax(Request $request)
{
    $draw   = $request->draw ?? 0;
    $start  = $request->start ?? 0;
    $length = $request->length ?? 10;
    $userid = $request->user_id;

    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $searchValue = $request->search['value'] ?? null;

    $usersdata  = tbl_cart::cartusersajax($start, $searchValue, $columnSortOrder, $columnName, 1, $length, $userid);
    $userscount = tbl_cart::cartusersajax($start, $searchValue, $columnSortOrder, $columnName, 0, $length, $userid);

    $data = [];
    foreach ($usersdata as $row) {

        $item_name = "N/A";
        $price = "N/A";
        $service_name = "";
        $subservice_name = "";
        $serviceid = null;
        $subserviceid = null;

        $city = DB::table('tbl_cities')->where('city_id', $row->city_id)->first();

        if ($row->type == 4) {
            $servicePlan = Serviceallottedcity::join('service_plans', 'service_plans.id', '=', 'serviceallottedcities.serviceid')
                ->where('service_plans.id', $row->plan_product_id)
                ->where('serviceallottedcities.city_id', $row->city_id)
                ->where('serviceallottedcities.service_type', 4)
                ->first();

            if ($servicePlan) {
                $serviceid = $servicePlan->serviceid ?? null;
                $subserviceid = $servicePlan->subservice_id ?? null;

                $serviceplan = DB::table('service_plans')->where('id', $servicePlan->id)->first();

                $service_name = $serviceplan && $serviceplan->service_id
                    ? DB::table('services')->where('id', $serviceplan->service_id)->value('title')
                    : "";

                $subservice_name = $serviceplan && $serviceplan->subservice_id
                    ? DB::table('subservices')->where('id', $serviceplan->subservice_id)->value('title')
                    : "";

                $item_name = $servicePlan->title ?? "N/A";

                $price = $servicePlan->price ?? $serviceplan->price ?? "N/A";
            }
        } elseif ($row->type == 5) {
            $product = Serviceallottedcity::join('tbl__products', 'tbl__products.id', '=', 'serviceallottedcities.serviceid')
                ->where('tbl__products.id', $row->plan_product_id)
                ->where('serviceallottedcities.city_id', $row->city_id)
                ->where('serviceallottedcities.service_type', 5)
                ->first();

            if ($product) {
                $serviceid = $product->serviceid ?? null;
                $subserviceid = $product->subservice_id ?? null;

                $productData = DB::table('tbl__products')->where('id', $product->id)->first();

                $service_name = $productData && $productData->service_id
                    ? DB::table('services')->where('id', $productData->service_id)->value('title')
                    : "";

                $subservice_name = $productData && $productData->subservice_id
                    ? DB::table('subservices')->where('id', $productData->subservice_id)->value('title')
                    : "";

                $item_name = $productData->product_item ?? "N/A";

                $price = $product->price ?? $productData->price ?? "N/A";
            }
        }

        $service_display = "";
        if (!empty($service_name)) {
            $service_display .= '<span class="badge" style="background:#5D3FD3;">' . e($service_name) . '</span>';
        }
        if (!empty($subservice_name)) {
            if ($service_display) $service_display .= '<br>';
            $service_display .= '<span class="badge" style="background:#E91E63;">' . e($subservice_name) . '</span>';
        }

        $final_service_display = !empty($service_display) ? $service_display : "N/A";

        $days = "N/A";
        if (!empty($row->created_at)) {
            $diff = now()->diffInDays($row->created_at);

            if ($diff === 0) {
                $days = "Today";
            } elseif ($diff <= 30) {
                $days = $diff . " days ago";
            } else {
                // Skip if more than 30 days old
                continue;
            }
        }

        $data[] = [
            "id" => $row->id ?? "N/A",
            "service" => $final_service_display,
            "plan_product_id" => $item_name ?? "N/A",
            "city" => $city->name ?? "N/A",
            "price" => $price ?? "N/A",
            "quantity" => $row->quantity ?? "N/A",
            "days" => $days,
        ];
    }

    $tot_rows = DB::table('tbl_carts')
        ->where('user_id', $userid)
        ->where('created_at', '>=', now()->subDays(30)) 
        ->count();

    return response()->json([
        "draw" => intval($draw),
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $userscount,
        "data" => $data
    ]);
}



public function userlogsusersajax(Request $request)
{
    $draw   = $request->draw ?? 0;
    $start  = $request->start ?? 0;
    $length = $request->length ?? 10;
    $userid = $request->user_id;

    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $searchValue = $request->search['value'] ?? null;

    $usersdata  = user_logs::userlogsusersajax($start, $searchValue, $columnSortOrder, $columnName, 1, $length, $userid);
    $userscount = user_logs::userlogsusersajax($start, $searchValue, $columnSortOrder, $columnName, 0, $length, $userid);

    $data = [];
    foreach ($usersdata as $row) {

        $days = "N/A";
        if (!empty($row->created_at)) {
            $diff = now()->diffInDays($row->created_at);

            if ($diff === 0) {
                $days = "Today";
            } elseif ($diff <= 30) {
                $days = $diff . " days ago";
            } else {
              
                continue;
            }
        }
   $activity = DB::table('tbl_activities')->where('id', $row->activity_id)->first();
        $data[] = [
            "id" => $row->id ?? "N/A",
            "activity" => $activity->activity??"N/A",
            "curdfuntion" => $row->curd_functions ?? "N/A",
            "weburl" => $row->web_url ?? "N/A",
            "days" => $days,
        ];
    }

    $tot_rows = DB::table('user_logs')
        ->where('user_id', $userid)
        ->where('created_at', '>=', now()->subDays(30)) 
        ->count();

    return response()->json([
        "draw" => intval($draw),
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $userscount,
        "data" => $data
    ]);
}




function usersdelete(Request $request,$id){
        $id=Crypt::decrypt($id);
        $delete = User::findOrFail($id);
        $delete->delete();
    $message = fleshmessage(4,1,'User');
          return redirect()->back()->with($message['status'],$message['message']);
   
    }
    

function useraddressajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;
     $userid = $request->user_id ;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


        
        $housesurveydata = MyAddress::useraddressajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$userid);
        $housesurveycount = MyAddress::useraddressajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$userid);
 
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        
         $country = DB::table('tbl_countries')->where('countries_id',$row->countries)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Country = '<span>'.$country.'</span>';
     
         $state = DB::table('tbl_states')->where('state_id',$row->state)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $State = '<span>'.$state.'</span>';
     
         $city = DB::table('tbl_cities')->where('city_id',$row->city)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $City = '<span>'.$city.'</span>';

        $data[] = array(
            "id" => $row->id, 
          "name" => $row->first_name . ' ' . $row->last_name . '<br>+' . $row->phonecode . ' ' . $row->phone_number,

    	  "address" => 
    $row->address . '<br>' .
    $Country . ', ' . 
    $State . ', ' . 
    $City . ' - ' . 
    $row->pincode,

            "companyname" => $row->company_name,
            "gstnumber" => $row->gst_number
        );
    }
    
 
        $query = DB::table('my_addresses')->orderBy('id', 'DESC')->where('user_id',$userid);
   

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}





    
}
