<?php

namespace App\Http\Controllers\backend\settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use App\Models\tbl_logs;
use Crypt;
use App\Models\Websitesetting;
use Session;
use DB;
use Hash;
class SuperadminsettingsController extends Controller
{
public function profile(Request $request){
    $user_id = session('SUPERADMIN_ID');

    if (!$user_id) {
        return redirect()->route('login')->with('error', 'Session expired. Please login again.');
    }

    $data['profiledata'] = superadmin::where('id', $user_id)->first();
    $data['city'] = DB::table('tbl_cities')->where('city_status','1')->where('city_id', $data['profiledata']->city)->first();
    $data['state'] = DB::table('tbl_states')->where('s_status','1')->where('state_id', $data['profiledata']->state)->first();
    $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->where('countries_id', $data['profiledata']->countries)->first();
    return view('backend.settings.superadminsettings.superadminprofile', $data);
}



public function notifications(){
   $data['act'] = DB::table('tbl_activities')->where('status','1')->get();
   $data['userName'] = DB::table('superadmins')->where('status','1')->get();
    $data['features'] = DB::table('tbl_crud_features')->where('status','1')->get();
    return view('backend.settings.superadminsettings.notifications',$data);
}


function notificationsajax(Request $request){
    
     $filterData = [
         'feature'    => $request->feature,
        'username' => $request->username,
        'activities' => $request->activities,
    ];
    
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = tbl_logs::notificationsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$filterData);
        $housesurveycount = tbl_logs::notificationsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$filterData);
    }else{
        $housesurveydata = tbl_logs::notificationsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$filterData);
        $housesurveycount = tbl_logs::notificationsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$filterData);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
         $checkbox = '<input type="checkbox" class="row-checkbox" value="' . $row->id . '">';
         
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
          $action .= '<li class="list-unstyled">';
      if(permission($user_id,'30','action_delete')){
    $action .= '<a href="' . asset('backend/notificationdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';
              
$action .= '<li class="list-unstyled ms-1" style="margin: 0;">';

if ($row->read_status == 0) {
    $action .= '<button class="btn mark-read-btn btn-sm" 
                    style="background: linear-gradient(135deg, #FFA726, #FF7043); 
                           color: white; 
                           font-weight: 500; 
                           border-radius: 20px;" 
                    data-id="' . $row->id . '">
                    Unread
                </button>';
}

$action .= '</li>';
$action .= '</ul>';


$feature = DB::table('tbl_crud_features')->where('id', $row->feature_id)->first();
if (!empty($feature)) {
    $Featurename = '<span class="badge" 
                        style="background-color:#cfe2f3; 
                               color:#0b3d91; 
                               padding:4px 8px; 
                               border-radius:20px; 
                               font-weight:500; 
                               margin-right:6px; 
                               display:inline-block;">'
                    . e($feature->feature)
                    . '</span>';
} else {
    $Featurename = '';
}


$activity = DB::table('tbl_activities')->where('id', $row->activity_id)->first();
if (!empty($activity)) {
    $ActivityName = '<span class="badge" 
                        style="background-color:#f3e5f5; 
                               color:#4a148c; 
                               padding:4px 8px; 
                               border-radius:20px; 
                               font-weight:500; 
                               display:inline-block;">'
                    . e($activity->activity)
                    . '</span>';
} else {
    $ActivityName = '';
}


        $userid = DB::table('superadmins')->where('id', $row->user_id)->first();
        $userid = $userid ? $userid->firstname . ' ' . $userid->lastname : "";
        $userid = '<span>' . $userid . '</span>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        $data[] = array(
          "id" => $checkbox . " " . $row->id,
            "feature_id" => 
               $Featurename . $ActivityName,
            "username" => $userid,
            "curd_functions" => $row->curd_functions,
            "date_time" => $row->date_time,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '30', 'action_globle_view');
    $canAccessCity = permission($user_id, '30', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('tbl_logs')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('tbl_logs')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('tbl_logs')->where('user_id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('tbl_logs')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}



    
    
    
public function notificationstatus(Request $request) {
    $id = $request->id;
    $statusstatus = tbl_logs::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Notification not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     





public function notificationdelete(Request $request, $id)
{
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '1', 'action_delete');
        if ($hasPermission) { 
    $delete = tbl_logs::findOrFail($id);

    $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
        
         insertLogsAPI($user_id,'4','Notification Delete','1','',$adduser,'','',$after,$before,''); 
      $message = fleshmessage(4,1,'Notification');
          return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
} 



public function markRead(Request $request)
{
    try {
     
        $ids = collect($request->ids)->filter(function($id) {
            return is_numeric($id);
        })->values();

        if ($ids->isNotEmpty()) {
            DB::table('tbl_logs')
                ->whereIn('id', $ids)
                ->update(['read_status' => 1]);

            $message = 'Selected notifications marked as read successfully.';
        } else {
            DB::table('tbl_logs')
                ->where('read_status', 0)
                ->update(['read_status' => 1]);

            $message = 'All unread notifications marked as read successfully.';
        }

        return response()->json([
            'status' => true,
            'message' => $message
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}




public function markSingleRead(Request $request)
{
    $id = $request->id;

    try {
        $updated = DB::table('tbl_logs')
            ->where('id', $id)
            ->where('read_status', 0)
            ->update(['read_status' => 1]);

        if ($updated) {
            return response()->json([
                'status' => true,
                'message' => 'Notification marked as read successfully.'
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Already read or invalid notification.'
            ]);
        }
    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}





////    Change Password ///


    function changepassword(){
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '4', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Change Password View','4','','','','','','',''); 
        return view('backend.settings.superadminsettings.changepassword');
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }


function passwordupdate(Request $request){
     $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '4', 'action_edit');
    if ($hasPermission) { 
    $update = superadmin::where('id', $user_id)->first();
   if (!Hash::check($request->old_password, $update->password)) {
            return redirect()->back()->with('error', 'Your old password is incorrect.');
        }
    $before = json_encode($update);
        $update->password =  Hash::make($request->change_password);
        
        
        $update->panel_id='1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Change Password Update','4','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(3,1,'Change Password');
    return redirect()->back()->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
    ->with($messagepremission['status'], $messagepremission['message'])
    ->send();
}




 function deletemultiplenotification(Request $request)
{
    $ids = $request->ids;

    if (!empty($ids)) {
        $ids = array_filter($ids, function ($id) {
            return is_numeric($id);
        });

        if (!empty($ids)) {
            DB::table('tbl_logs')
                ->whereIn('id', $ids)
                ->delete();

            return response()->json([
                'status' => true,
                'message' => 'Selected records deleted successfully!'
            ]);
        }
    }

    return response()->json([
        'status' => false,
        'message' => 'No records selected!'
    ]);
}


}
