<?php

namespace App\Http\Controllers\backend\service;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\superadmin;


use App\Models\ChildService;
use App\Models\Serviceallottedcity;
use App\Models\Websitesetting;
use App\Models\Service;
use App\Models\ServicePlan;
use App\Models\Subservice;
use App\Models\tbl_permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class ServiceController extends Controller
{

   //Service  View// 
      function services(){
          
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '5', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Service View','5','','','','','','',''); 
    $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'5');
        return view('backend.service.services',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }
    
      //Service  View// 
    

  //Service Add//  
    
    function servicescreate(Request $request){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '5', 'action_add');
     if ($hasPermission) { 
     $existingMobile = Service::where('slug', $request->slug)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
     $existingMobile = Service::where('title', $request->title)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
         $user_id=session('SUPERADMIN_ID');

        $create=new Service;
        $create->title=$request->title;
        $create->user_id=$user_id;
        $create->slug = $request->slug;
      
        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/service'), $img);
        $create->image = $img;
          }
        $create->img_description=$request->img_description;
       
        $create->ordering_by=$request->ordering_by;
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->tokan=reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save();
      $after = json_encode($create);
     $before = json_encode($create);
    $adduser=$create->id;
    insertLogsAPI($user_id,'1','Service Add','5','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Service');
     return redirect(asset('backend/service/services'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
      //Service Add//  
    
    
   //Service Ajax// 
function servicesajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = Service::servicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Service::servicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = Service::servicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Service::servicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'5','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/servicesedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'5','action_delete')){
            $action .= '<a href="' . asset('backend/servicesdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
    
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'5','action_edit')){
            $action .= '   <a class="btn actionedit viewbtn btn-sm " href="' . asset('backend/serviceallottedcity/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-map anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '</ul>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        $data[] = array(
            "id" => $row->id, 
            "image" => '<a href="' . asset('uploads/service/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/service/' . $row->image) . '" style=" width: 36px;"></a>',
          "title" => '<span class="badge servicecolor" style="background:#5D3FD3;">'.$row->title.'</span>',

            "ordering_by" => $row->ordering_by,
            "status" => $status,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '5', 'action_globle_view');
    $canAccessCity = permission($user_id, '5', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}

//Service Ajax//

//Service Delete//    
    function servicesdelete(Request $request,$id){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '5', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
   
        $delete = Service::findOrFail($id);
      $image_path = public_path("uploads/service/{$delete->image}");
     
        
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
           
            unlink($image_path);
        }
        $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Service Delete','5','',$adduser,'','',$after,$before,''); 


        
     $message = fleshmessage(4,1,'Service');
          return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }
    //Service Delete//
    
    //Service Status//
  public function servicesstatus(Request $request) {
    $id = $request->id;
    $service = Service::find($id);
    if (!$service) {
        return response()->json(['success' => false, 'message' => 'Service not found'], 404);
    }
    $service->status = (string) $request->status;
    $service->save();
    updateStatus('service', $request->id, $request->status);
    return response()->json(['success' => true]);
}



//Service Status//

//Service Edit View//

 function servicesedit(Request $request){
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '5', 'action_edit');
     if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['servicedata']=Service::where('id',$id)->where('status','1')->first();
         $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'5');
        return view('backend.service.servicesedit',$data);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
     
    }
    //Service Edit View//
    
    //Service Update
   public function servicesupdate(Request $request){
       
       $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '5', 'action_edit');
     if ($hasPermission) { 
    $id = Crypt::decrypt($request->id);

    $existingMobile = Service::where('slug', $request->slug)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $existingMobile = Service::where('title', $request->title)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    
    $user_id = session('SUPERADMIN_ID');
   
    $update = Service::findOrFail($id);
    $before = json_encode($update);

    $update->title = $request->title;
    $update->slug = $request->slug;
    $update->user_id = $user_id;
   
    $update->img_description = $request->img_description;
   
    $update->ordering_by = $request->ordering_by;
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];

    if ($request->hasFile('image')) {
       
        if ($update->image && file_exists(public_path('uploads/service/' . $update->image))) {
            unlink(public_path('uploads/service/' . $update->image));
        }

      
        $img = preg_replace('/\.[^.]+$/', '', $update->image) . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/service'), $img);
        $update->image = $img;
    }

    $update->save();
      $after = json_encode($update);
       $adduser=$update->id;
    insertLogsAPI($user_id,'3','Service Update','5','',$adduser,'','',$after,$before,''); 

 $message = fleshmessage(3,1,'Service');
    return redirect(url('backend/service/services'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
}

//Service Update

  //Service alotted City//
   
function serviceallottedcity(Request $request){
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $id=Crypt::decrypt($request->id);
    $data['service']= Service::where('id',$id)->first();
   
     $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
    return view('backend.service.serviceallottedcity',$data);
}

public function serviceallottedcityadd(Request $request)
{
  
            $user_id   = session('SUPERADMIN_ID');
             $serviceId = $request->id;
            $countryId = $request->countries;
            $stateId   = $request->state;
            $cityId    = $request->city;
            $status    = $request->status;
        
            $ip        = CurrentTimestamp()['ip'];
            $strtotime = CurrentTimestamp()['strtotime'];
        
            $inserted = false;
            $updated  = false;

    if (!empty($cityId)) {
            $existing = Serviceallottedcity::where('city_id', $cityId)->where('service_type','1')->where('serviceid',$serviceId)->first();

        if ($existing) {
            $before = json_encode($existing);

            $existing->status    = $status ?? '1';
            $existing->ip        = $ip;
            $existing->strtotime = $strtotime;
            $existing->save();

            $after   = json_encode($existing);
            $adduser = $existing->id;

            insertLogsAPI($user_id,'2','Service Allotted City Update','5','',$adduser,'','',$after,$before,''); 
            $updated = true;

           
            if ($status == 0) {
            Serviceallottedcity::where('service_type', 2)->where('city_id', $existing->city_id)->update(['status' => '0']);
            Serviceallottedcity::where('service_type', 3)->where('city_id', $existing->city_id)->update(['status' => '0']);
            Serviceallottedcity::where('service_type', 4)->where('city_id', $existing->city_id)->update(['status' => '0']);
            }

        } else {
            $create = new Serviceallottedcity();
            $create->serviceid    = $serviceId;
            $create->service_type = '1';
            $create->countries_id = $countryId;
            $create->state_id     = $stateId;
            $create->city_id      = $cityId;
            $create->status       = $status ?? '1';
            $create->ip           = $ip;
            $create->strtotime    = $strtotime;
            $create->save();

            $after   = json_encode($create);
            $before  = json_encode([]);
            $adduser = $create->id;

            insertLogsAPI($user_id,'1','Service Allotted City Add','5','',$adduser,'','',$after,$before,''); 
            $inserted = true;

            
            if ($status == 0) {
            Serviceallottedcity::where('service_type', 2)->where('city_id', $create->city_id)->update(['status' => '0']);
            Serviceallottedcity::where('service_type', 3)->where('city_id', $create->city_id)->update(['status' => '0']);
            Serviceallottedcity::where('service_type', 4)->where('city_id', $create->city_id)->update(['status' => '0']);
            }
        }

    } else {
           $cities = DB::table('tbl_cities')->where('stateid', $stateId)->where('city_status','1')->get();

        foreach ($cities as $city) {
            $existing = Serviceallottedcity::where('city_id', $city->city_id)->where('service_type','1')->where('serviceid',$serviceId)->first();

            if ($existing) {
                $before = json_encode($existing);

                $existing->status    = $status ?? '1';
                $existing->ip        = $ip;
                $existing->strtotime = $strtotime;
                $existing->save();

                $after   = json_encode($existing);
                $adduser = $existing->id;

                insertLogsAPI($user_id,'2','Service Allotted City Update','5','',$adduser,'','',$after,$before,''); 
                $updated = true;

 
                if ($status == 0) {
                Serviceallottedcity::where('service_type', 2)->where('city_id', $existing->city_id)->update(['status' => '0']);
                Serviceallottedcity::where('service_type', 3)->where('city_id', $existing->city_id)->update(['status' => '0']);
                Serviceallottedcity::where('service_type', 4)->where('city_id', $existing->city_id)->update(['status' => '0']);
                }

            } else {
                $create = new Serviceallottedcity();
                $create->serviceid    = $serviceId;
                $create->service_type = '1';
                $create->countries_id = $countryId;
                $create->state_id     = $stateId;
                $create->city_id      = $city->city_id;
                $create->status       = $status ?? '1';
                $create->ip           = $ip;
                $create->strtotime    = $strtotime;
                $create->save();

                $after   = json_encode($create);
                $before  = json_encode([]);
                $adduser = $create->id;

                insertLogsAPI($user_id,'1','Service Allotted City Add','5','',$adduser,'','',$after,$before,''); 
                $inserted = true;

              
                if ($status == 0) {
                Serviceallottedcity::where('service_type', 2)->where('city_id', $create->city_id)->update(['status' => '0']);
                Serviceallottedcity::where('service_type', 3)->where('city_id', $create->city_id)->update(['status' => '0']);
                Serviceallottedcity::where('service_type', 4)->where('city_id', $create->city_id)->update(['status' => '0']);
                }
            }
        }
    }

    if ($updated) {
        $message = fleshmessage(3,1,'Service Allotted City');
        return redirect()->back()->with($message['status'],$message['message']);
    } elseif ($inserted) {
        $messagei = fleshmessage(2,1,'Service Allotted City');
        return redirect()->back()->with($messagei['status'],$messagei['message']);
    } else {
        return redirect()->back()->with('error', 'Something went wrong.');
    }
}








 function serviceallottedcityview(Request $request){
      $serviceid = $request->serviceid;
     $filterdata=[
         'countriesfilter'=>$request->countriesfilter,
         'statefilter'=>$request->statefilter,
         'cityfilter'=>$request->cityfilter,
        
         ];
         
       
    $draw= $request->draw;
    $rows = $request->start;
    $columnIndex = $request->order[0]['column'];
    $columnName = $request->columns[$columnIndex]['data'];
    $columnSortOrder = $request->order[0]['dir'];
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'];
    $searchValue = $request->search['value'];
    $length = $request->length;


 $user_id = session('SUPERADMIN_ID');
  $roledata = superadmin::where('id', $user_id)->first();
   
   

    $housesurveydata = Serviceallottedcity::serviceallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$filterdata,$serviceid);
    $housesurveycount = Serviceallottedcity::serviceallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$filterdata,$serviceid);
   
  
  
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
  $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    $action .= '<li class="list-unstyled " style="margin: 0;">';
   
    $action .= '<a href="' . asset('backend/serviceallottedcitydelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-2">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>
    </li>';
    
    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';


 $service = Service::where('id',$row->serviceid)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Servicename = '<span>'.$service.'</span>'; 
     
 $city =DB::table('tbl_cities')->where('city_id', $row->city_id)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $Cityname = '<span>'.$city.'</span>'; 
     
 $state =DB::table('tbl_states')->where('state_id', $row->state_id)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $Statename = '<span>'.$state.'</span>'; 
     
 $country =DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Countryname = '<span>'.$country.'</span>'; 
     
  
        
        
  
        
   $country = DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
        $countryName = $country->name ?? '';
        $countryName = '';

      
   
     $data[] = array(
    "id" => $i++, 
  
   "countries" => $Countryname,
   "state" => $Statename,
   "city" => $Cityname,
  


    
  
   "status" => $status,
    "action" => $action
);

    
    }
    

    $query = DB::table('serviceallottedcities')->orderBy('id', 'DESC')->where('service_type','1')->where('serviceid',$serviceid);



  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    }
    
public function serviceallottedcitystatus(Request $request)
{
    $id = $request->id;
    $newStatus = (string) $request->status; 

    // Find record by id
    $record = Serviceallottedcity::find($id);

    if (!$record) {
        return response()->json([
            'success' => false,
            'message' => 'Record not found'
        ], 404);
    }

   
    $record->status = $newStatus;
    $record->save();

    updateAllottedCityStatus('service', $record, $newStatus);

    return response()->json(['success' => true]);
}



public function subserviceallottedcitystatus(Request $request)
{
    $id = $request->id;
    $newStatus = (string) $request->status;

    // Find record by id
    $record = Serviceallottedcity::find($id);

    if (!$record) {
        return response()->json([
            'success' => false,
            'message' => 'Record not found'
        ], 404);
    }

    $result = updateAllottedCityStatus('subservice', $record, $newStatus);

    if (!$result['success']) {
        return response()->json([
            'success' => false,
            'message' => $result['message']
        ], 400);
    }

    // Save new status only if valid
    $record->status = $newStatus;
    $record->save();

    return response()->json(['success' => true]);
}





 function serviceallottedcitydelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
        $id=Crypt::decrypt($id);
        $delete = Serviceallottedcity::findOrFail($id);
        $delete->delete();
         $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Service Allotted City Delete','5','',$adduser,'','',$after,$before); 
    $message = fleshmessage(4,1,'Service Allotted City');
          return redirect()->back()->with($message['status'],$message['message']);
   
    }


//Sub Service Curd Function Start // 

/////Sub Service View start/////
 function subservice(){
      $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
 $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '6', 'action_view');
     if ($hasPermission) { 
         $data['service']=Service::where('status','1')->get();
          $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'6');
           insertLogsAPI($user_id,'2',' Sub Service View','6','','','','','','',''); 
        return view('backend.service.subservice',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    /////Sub Service View end/////
    
   //Sub Service Create start//
    
     function subservicecreate(Request $request){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '6', 'action_add');
     if ($hasPermission) { 
         $existingslug = Subservice::where('slug', $request->slug) ->where('service_id', $request->service_id)->first();
         if ($existingslug) {
              $message = fleshmessage(6,1,'Slug');
         return redirect()->back()->with($message['status'],$message['message']);
          }
         $existingTitle = Subservice::where('title', $request->title) ->where('service_id', $request->service_id)->first();
         if ($existingTitle) {
              $message = fleshmessage(6,1,'Title');
         return redirect()->back()->with($message['status'],$message['message']);
          }
        $user_id = session('SUPERADMIN_ID');

        $create=new Subservice;
        $create->title=$request->title;
        $create->service_id=$request->service_id;
        $create->user_id=$user_id;
        $create->slug=$request->slug;
        
        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/subservice'), $img);
        $create->image = $img;
          }
     
      if ($request->rightimage) {
        $rightimage = time() . 'rightimage.' . $request->rightimage->extension();
        $request->rightimage->move(public_path('uploads/subservice'), $rightimage);
        $create->rightimage = $rightimage;
          }
        $create->img_description=$request->img_description;
        $create->hsn_code=$request->hsn_code;
        $create->video=$request->video;
        $create->description_1=$request->description_1;
        $create->description_2=$request->description_2;
        $create->description_3=$request->description_3;
        $create->faq_4=$request->faq_4;
        $create->description_5=$request->description_5;
        $create->metatitle=$request->metatitle;
        $create->metakeyword=$request->metakeyword;
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->metakeyword=$request->metakeyword;
        $create->metadescription=$request->metadescription;
        $create->ordering_by=$request->ordering_by;
        $create->token=reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
        $create->save();
        $after = json_encode($create);
        $before = json_encode($create);
        $adduser=$create->id;
         insertLogsAPI($user_id,'1',' Sub Service Add','6','',$adduser,'','',$after,$before,''); 
          $message = fleshmessage(2,1,'Sub Service');
     return redirect(asset('backend/service/subservice'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }

 /// Sub Service Add end//

//Sub Service Ajax View start//
      function subserviceajax(Request $request){
   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $housesurveydata = Subservice::subserviceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $housesurveycount = Subservice::subserviceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $housesurveydata = Subservice::subserviceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $housesurveycount = Subservice::subserviceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
   if(permission($user_id,'6','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/subserviceedit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';

   

    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'6','action_delete')){
    $action .= '<a href="' . asset('backend/subservicedelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';

 $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'6','action_edit')){
            $action .= '   <a class="btn actionedit viewbtn btn-sm " href="' . asset('backend/subserviceallottedcity/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-map anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';

  $service = Service::where('id',$row->service_id)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Servicename = '<span>'.$service.'</span>'; 
   
     $data[] = array(
    "id" => $row->id, 
   "service_id" => $Servicename,
   "title" => $row->title,

    "video" => '<a href="' . asset('uploads/subservice/' . $row->video) . '"   target="_blank"><i class="fadeIn animated bx bx-video-plus h5"></i></a>',
    "image" => '<a href="' . asset('uploads/subservice/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/subservice/' . $row->image) . '" style=" width: 30px;"></a>',
   "ordering_by" => $row->ordering_by,
   "status" => $status,
    "action" => $action
);

    
    }
    
 $canViewGlobal = permission($user_id, '6', 'action_globle_view');
$canAccessCity = permission($user_id, '6', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;





if ($user_id == '1') {
    $query = DB::table('subservices')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('subservices')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('subservices')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');

} else {
    $query = DB::table('subservices')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
    
  


    
    //Sub Service Ajax View end//
    
 public function subservicestatus(Request $request)
{
    $subservice = Subservice::find($request->id);
    if (!$subservice) {
        return response()->json(['success' => false, 'message' => 'Sub Service not found'], 404);
    }

    $result = updateStatus('subservice', $request->id, $request->status);

    if (!$result['success']) {
        return response()->json([
            'success' => false,
            'message' => $result['message']
        ], 400);
    }

    return response()->json(['success' => true]);
}




function subservicedelete(Request $request,$id){
    
    $user_id = session('SUPERADMIN_ID');
  
    
     $hasPermission = permission($user_id, '6', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
   
        $delete = Subservice::findOrFail($id);
      $image_path = public_path("uploads/subservice/{$delete->image}");
      $video_path = public_path("uploads/subservice/{$delete->video}");
     
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
           
            unlink($image_path);
        }
         if (File::exists($video_path) && !File::isDirectory($video_path)) {
           
            unlink($video_path);
        }
        $delete->delete();
         $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
        
         insertLogsAPI($user_id,'4','Sub Services Delete','6','',$adduser,'','',$after,$before,''); 
      $message = fleshmessage(4,1,'Sub Services');
          return redirect()->back()->with($message['status'],$message['message']);
   
}
   $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }
    
    
     function subserviceedit(Request $request){
         $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '6', 'action_edit');
     if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['service']=Service::where('status','1')->get();
         $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'6');
        $data['subservicedata']=Subservice::where('id',$id)->first();
        return view('backend.service.subserviceedit',$data);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
     public function subserviceupdate(Request $request){
  
  $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '6', 'action_edit');
     if ($hasPermission) { 
       
    $id = Crypt::decrypt($request->id);

    $existingslug = Subservice::where('slug', $request->slug)->where('id','!=',$id)->first();
    if ($existingslug) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $existingTitle = Subservice::where('title', $request->title)->where('service_id',$request->service_id)->where('id', '!=', $id)->first();
    if ($existingTitle) {
        $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
 $user_id = session('SUPERADMIN_ID');
   
    $update = Subservice::findOrFail($id);
     $before = json_encode($update);

    $update->title = $request->title;
    $update->service_id = $request->service_id;
   
  $update->slug = $request->slug;
   
    $update->user_id = $user_id;
    $update->img_description = $request->img_description;
    $update->description = $request->description;
     $update->hsn_code=$request->hsn_code;
    $update->metatitle = $request->metatitle;
    $update->metakeyword = $request->metakeyword;
    $update->metadescription = $request->metadescription;
    $update->ordering_by = $request->ordering_by;

    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];
    
    
  if ($request->hasFile('image')) {
       
        if ($update->image && file_exists(public_path('uploads/subservice/' . $update->image))) {
            unlink(public_path('uploads/subservice/' . $update->image));
        }

      
        $img = preg_replace('/\.[^.]+$/', '', $update->image) . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/subservice'), $img);
        $update->image = $img;
    }
if ($request->hasFile('video')) {

    if ($update->video && file_exists(public_path('uploads/subservice/' . $update->video))) {
        unlink(public_path('uploads/subservice/' . $update->video));
    }

    $file = $request->file('video');
    $ext = $file->extension();

    if ($update->video) {
        $filename = preg_replace('/\.[^.]+$/', '', $update->video) . '.' . $ext;
    } else {
        $filename = time() . '_subservice.' . $ext;
    }

    // Move file to uploads folder
    $file->move(public_path('uploads/subservice'), $filename);
    $update->video = $filename;
    $update->save();
}



    $update->save();
   
      $after = json_encode($update);
       $adduser=$update->id;
    insertLogsAPI($user_id,'3',' Sub Service Update','6','',$adduser,'','',$after,$before,''); 
 $message = fleshmessage(3,1,' Sub Service');
    return redirect(url('backend/service/subservice'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
}





  
    //Sub  Service Allotted City Curd Function Start //
    
    function subserviceallottedcity(Request $request){
       
        $user_id = session('SUPERADMIN_ID');
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $id=Crypt::decrypt($request->id);
    $data['subservice']= Subservice::where('id',$id)->first();
   
     $data['country'] = DB::table('serviceallottedcities')->where('service_type','1')->distinct()->select('countries_id')->get();
      insertLogsAPI($user_id,'2','Sub Service Allotted City View','','','','','','','',''); 
    return view('backend.service.subserviceallottedcity',$data);
}



 function subserviceallottedcityview(Request $request){
      $subserviceid =$request->subserviceid;
        $service_id=$request->service_id;
     $filterdata=[
         'countriesfilter'=>$request->countriesfilter,
         'statefilter'=>$request->statefilter,
         'cityfilter'=>$request->cityfilter,
         ];
       
    $draw= $request->draw;
    $rows = $request->start;
    $columnIndex = $request->order[0]['column'];
    $columnName = $request->columns[$columnIndex]['data'];
    $columnSortOrder = $request->order[0]['dir'];
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'];
    $searchValue = $request->search['value'];
    $length = $request->length;


 $user_id = session('SUPERADMIN_ID');
  $roledata = superadmin::where('id', $user_id)->first();
   
   

    $housesurveydata = Serviceallottedcity::subserviceallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$filterdata,$service_id,$subserviceid);
    $housesurveycount = Serviceallottedcity::subserviceallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$filterdata,$service_id,$subserviceid);
   
  
  
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
  $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    $action .= '<li class="list-unstyled " style="margin: 0;">';
   
    $action .= '<a href="' . asset('backend/subserviceallottedcitydelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-2">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>
    </li>';
    
    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
         ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';


 $service = Service::where('id',$row->serviceid)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Servicename = '<span>'.$service.'</span>'; 
     
 $city =DB::table('tbl_cities')->where('city_id', $row->city_id)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $Cityname = '<span>'.$city.'</span>'; 
     
 $state =DB::table('tbl_states')->where('state_id', $row->state_id)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $Statename = '<span>'.$state.'</span>'; 
     
 $country =DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Countryname = '<span>'.$country.'</span>'; 
     
  
        
        
  
        
   $country = DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
        $countryName = $country->name ?? '';
        $countryName = '';

      
   
     $data[] = array(
    "id" => $i++, 
  
   "countries" => $Countryname,
   "state" => $Statename,
   "city" => $Cityname,
  


    
  
   "status" => $status,
    "action" => $action
);

    
    }
    

    $query = DB::table('serviceallottedcities')->orderBy('id', 'DESC')->where('service_type','2')->where('serviceid',$subserviceid);



  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    }
    
    
    
   function serviceallottedcitycountryget(Request $request)
{
   
    $states = DB::table('tbl_states')
                ->where('country_id', $request->country_id)->where('s_status','1')
                ->get(['state_id', 'name']);

 
    $cities = DB::table('tbl_cities')
                ->where('stateid', $request->state_id ?? null)->where('city_status','1') 
                ->get(['city_id', 'name']);
    
    return response()->json(['states' => $states, 'cities' => $cities]);
}
    
// Controller
 function subservicecountrydata(Request $request)
{
    $service_id = $request->service_id;

    $states = DB::table('serviceallottedcities as sac')
        ->where('sac.service_type', '1')
        ->join('tbl_states as s', 'sac.state_id', '=', 's.state_id')
        ->where('sac.countries_id', $request->country_id)
        ->distinct()
        ->get(['sac.state_id', 's.name']);

    $cities = [];
    if ($request->state_id) {
        $cities = DB::table('serviceallottedcities as sac')
            ->where('sac.service_type', '1')
            ->join('tbl_cities as c', 'sac.city_id', '=', 'c.city_id')
            ->where('sac.state_id', $request->state_id)
            ->where('c.city_status', '1') // yaha city_status lagaya
            ->distinct()
            ->get(['sac.city_id', 'c.name']);
    }

    return response()->json(['states' => $states, 'cities' => $cities]);
}




 function subserviceallottedcityadd(Request $request)
{
    $user_id   = session('SUPERADMIN_ID');
    $serviceId = $request->id;
    $countryId = $request->countries;
    $stateId   = $request->state;
    $cityId    = $request->city;
    $status    = $request->status;

    $ip        = CurrentTimestamp()['ip'];
    $strtotime = CurrentTimestamp()['strtotime'];

    $inserted = false;
    $updated  = false;

    if (!empty($cityId)) {
        $existing = Serviceallottedcity::where('city_id', $cityId)
            ->where('service_type', '2')->where('serviceid',$serviceId)
            ->first();

        if ($existing) {
            $before = json_encode($existing);

            $existing->status    = $status ?? '1';
            // $existing->serviceid    = $serviceId;
            $existing->ip        = $ip;
            $existing->strtotime = $strtotime;
            $existing->save();

           
            if ($status == 0) {
                Serviceallottedcity::where('service_type', 3)->where('city_id', $existing->city_id)->update(['status' => '0']);
                Serviceallottedcity::where('service_type', 4)->where('city_id', $existing->city_id)->update(['status' => '0']);
            }

            $after   = json_encode($existing);
            $adduser = $existing->id;

            insertLogsAPI($user_id, '2', 'Subservice Allotted City Update', '', '', $adduser, '', '', $after, $before, ''); 
            $updated = true;
        } else {
            $create = new Serviceallottedcity();
            $create->serviceid     = $serviceId;
            $create->service_type  = '2';
            $create->countries_id  = $countryId;
            $create->state_id      = $stateId;
            $create->city_id       = $cityId;
            $create->status        = $status ?? '1';
            $create->ip            = $ip;
            $create->strtotime     = $strtotime;
            $create->save();

         
            if ($status == 0) {
                Serviceallottedcity::where('service_type', 3)->where('city_id', $create->city_id)->update(['status' => '0']);
                Serviceallottedcity::where('service_type', 4)->where('city_id', $create->city_id)->update(['status' => '0']);
            }

            $after   = json_encode($create);
            $before  = json_encode([]);
            $adduser = $create->id;

            insertLogsAPI($user_id, '1', 'Subservice Allotted City Add', '', '', $adduser, '', '', $after, $before, ''); 
            $inserted = true;
        }
    } else {
        $cities = DB::table('serviceallottedcities')->where('state_id', $stateId)->where('status','1')->where('service_type','1')->get();

        foreach ($cities as $city) {
            $existing = Serviceallottedcity::where('city_id', $city->city_id)->where('service_type','2')->where('serviceid',$serviceId)->first();

            if ($existing) {
                $before = json_encode($existing);

                $existing->status    = $status ?? '1';
                //  $existing->serviceid     = $serviceId;
                $existing->ip        = $ip;
                $existing->strtotime = $strtotime;
                $existing->save();

                if ($status == 0) {
                    Serviceallottedcity::where('service_type', 3)->where('city_id', $existing->city_id)->update(['status' => '0']);
                    Serviceallottedcity::where('service_type', 4)->where('city_id', $existing->city_id)->update(['status' => '0']);
                }

                $after   = json_encode($existing);
                $adduser = $existing->id;

                insertLogsAPI($user_id,'2','Subservice Allotted City Update','','',$adduser,'','',$after,$before,''); 
                $updated = true;
            } else {
                $create = new Serviceallottedcity();
                $create->serviceid     = $serviceId;
                $create->service_type  = '2';
                $create->countries_id  = $countryId;
                $create->state_id      = $stateId;
                $create->city_id       = $city->city_id;
                $create->status        = $status ?? '1';
                $create->ip            = $ip;
                $create->strtotime     = $strtotime;
                $create->save();
                
                if ($status == 0) {
                    Serviceallottedcity::where('service_type', 3)->where('city_id', $create->city_id)->update(['status' => '0']);
                    Serviceallottedcity::where('service_type', 4)->where('city_id', $create->city_id)->update(['status' => '0']);
                }

                $after   = json_encode($create);
                $before  = json_encode([]);
                $adduser = $create->id;

                insertLogsAPI($user_id,'1','Subservice Allotted City Add','','',$adduser,'','',$after,$before,''); 
                $inserted = true;
            }
        }
    }

    if ($updated) {
        $message = fleshmessage(3,1,'Subservice Allotted City');
        return redirect()->back()->with($message['status'],$message['message']);
    } elseif ($inserted) {
        $messagei = fleshmessage(2,1,'Subservice Allotted City');
        return redirect()->back()->with($messagei['status'],$messagei['message']);
    } else {
        return redirect()->back()->with('error', 'Something went wrong.');
    }
}



function subserviceallottedcitydelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
        $id=Crypt::decrypt($id);
        $delete = Serviceallottedcity::findOrFail($id);
        $delete->delete();
         $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Subservice Allotted City Delete','','',$adduser,'','',$after,$before); 
    $message = fleshmessage(4,1,'Subservice Allotted City');
          return redirect()->back()->with($message['status'],$message['message']);
   
    }


    
     //Sub  Service Allotted City Curd Function End //

//Sub Service Curd Function End //




//Child Service Curd Function //


    
 function childservice(){
            
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
 $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '12', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Child Service View','12','','','','','','',''); 
             $data['service']=Service::where('status','1')->get();
              $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'12');
        return view('backend.service.childservice',$data);
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
  public function childservicesstatus(Request $request)
{
    $id = $request->id;
    $child = ChildService::find($id);

    if (!$child) {
        return response()->json(['success' => false, 'message' => 'Child Service not found'], 404);
    }

    $result = updateStatus('child', $id, $request->status);

    // Always return the final DB value
    $currentStatus = ChildService::where('id', $id)->value('status');

    return response()->json([
        'success' => $result['success'],
        'message' => $result['message'] ?? null,
        'status'  => $currentStatus
    ]);
}
    

function childservicescreate(Request $request){
        
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '12', 'action_add');
     if ($hasPermission) { 
             $existingslug = ChildService::where('slug', $request->slug)->first();
    if ($existingslug) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
             $existingMobile = ChildService::where('title', $request->title)->where('subservice_id', $request->subservice_id)->where('service_id', $request->service_id)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
     $user_id = session('SUPERADMIN_ID');

        $create=new ChildService;
        $create->title=$request->title;
        $create->service_id=$request->service_id;
        $create->subservice_id=$request->subservice_id;
        $create->user_id=$user_id;
        
     $create->slug =$request->slug;
        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/childservice'), $img);
        $create->image = $img;
          }
        if ($request->icon_image) {
        $img = time() . 'icon_image.' . $request->icon_image->extension();
        $request->icon_image->move(public_path('uploads/childservice'), $img);
        $create->icon_image = $img;
          }
        $create->img_description=$request->img_description;
        $create->description=$request->description;
        $create->meta_title=$request->meta_title;
        $create->meta_keyword=$request->meta_keyword;
        $create->meta_description=$request->meta_description;
        $create->ordering_by=$request->ordering_by;
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->meta_description=$request->meta_description;
        $create->tokan=reandum_code('50');
       $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save();
      $after = json_encode($create);
     $before = json_encode($create);
    $adduser=$create->id;
    insertLogsAPI($user_id,'1','Child Service Add','12','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,' Child Service');
     return redirect()->back()->with($message['status'],$message['message']);
    }
    
    
     function childserviceslug(Request $request){
      $slug= $request->slug;
    
    $productslug=ChildService::where('slug',$slug)->exists();
    if(!empty($request->id)){
    $productslug=ChildService::where('slug',$slug)->where('id', '!=' ,$request->id)->exists();
        
    }
      return response()->json(['exists' => $productslug]);
       
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
   }
   
   
   function childservicesajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');
    $roledata = superadmin::where('id', $user_id)->first();

    if($roledata && $roledata->role=='1'){
        
        $housesurveydata = ChildService::childservicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = ChildService::childservicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = ChildService::childservicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = ChildService::childservicesajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'12','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/childservicesedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'12','action_delete')){
            $action .= '<a href="' . asset('backend/childservicesdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
    
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'12','action_edit')){
            $action .= '   <a class="btn actionedit viewbtn btn-sm " href="' . asset('backend/childserviceallottedcity/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-map anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '</ul>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
               ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';
        
         $subservice = Subservice::where('id',$row->subservice_id)->first();
         if(empty($subservice)){
        $subservice = "";
    }else{
        $subservice = $subservice->title;
    } 
     $Subservice = '<span>'.$subservice.'</span>'; 
     
  $service = Service::where('id',$row->service_id)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Services = '<span>'.$service.'</span>';
     


        $data[] = array(
           "id" => $row->id, 
 "service" => 
    '<span class="badge" style="background:#5D3FD3;">' . $Services . '</span><br>' .
    '<span class="badge "  style="background:#E91E63;">' . $Subservice . '</span>',
   "title" => $row->title,
    "icon_image" => '<a href="' . asset('uploads/childservice/' . $row->icon_image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/childservice/' . $row->icon_image) . '" style=" width: 30px;"></a>',
    "image" => '<a href="' . asset('uploads/childservice/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/childservice/' . $row->image) . '" style=" width: 30px;"></a>',
   "ordering_by" => $row->ordering_by,
   "status" => $status,
    "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '12', 'action_globle_view');
    $canAccessCity = permission($user_id, '12', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('child_services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('child_services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('child_services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('child_services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}



 function childservicesdelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '12', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
   
        $delete = ChildService::findOrFail($id);
      $image_path = public_path("uploads/childservice/{$delete->image}");
      $icon_path = public_path("uploads/childservice/{$delete->icon_image}");
     
        
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
           
            unlink($image_path);
        }
         if (File::exists($icon_path) && !File::isDirectory($icon_path)) {
           
            unlink($icon_path);
        }
        $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Child Service Delete','12','',$adduser,'','',$after,$before,''); 


        
     $message = fleshmessage(4,1,'Child Service');
          return redirect()->back()->with($message['status'],$message['message']);
   
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
   

 function childservicesedit(Request $request){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '12', 'action_edit');
     if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['service']=Service::where('status','1')->get();
         $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'12');
        $data['childservicedata']=ChildService::where('id',$id)->first();
        return view('backend.service.childserviceedit',$data);
    }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
 }
   




function childservicesupdate(Request $request){
    $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '12', 'action_edit');
     if ($hasPermission) { 
        $id = Crypt::decrypt($request->id);
             $existingslug = ChildService::where('slug', $request->slug)->where('id','!=',$id)->first();
    if ($existingslug) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
             $existingMobile = ChildService::where('title', $request->title)->where('subservice_id', $request->subservice_id)->where('service_id', $request->service_id)->where('id','!=',$id)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
     $user_id = session('SUPERADMIN_ID');

     $update = ChildService::where('id',$id)->first();
    $before = json_encode($update);
        $update->title=$request->title;
        $update->service_id=$request->service_id;
        $update->subservice_id=$request->subservice_id;
        $update->user_id=$user_id;
        
     $update->slug =$request->slug;
       if ($request->hasFile('image')) {
       
        if ($update->image && file_exists(public_path('uploads/childservice/' . $update->image))) {
            unlink(public_path('uploads/childservice/' . $update->image));
        }

      
        $img = preg_replace('/\.[^.]+$/', '', $update->image) . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/childservice'), $img);
        $update->image = $img;
    }
       if ($request->hasFile('icon_image')) {
       
        if ($update->icon_image && file_exists(public_path('uploads/childservice/' . $update->icon_image))) {
            unlink(public_path('uploads/childservice/' . $update->icon_image));
        }

      
        $img = preg_replace('/\.[^.]+$/', '', $update->icon_image) . '.' . $request->icon_image->extension();
        $request->icon_image->move(public_path('uploads/childservice'), $img);
        $update->icon_image = $img;
    }
       
        $update->img_description=$request->img_description;
        $update->description=$request->description;
        $update->meta_title=$request->meta_title;
        $update->meta_keyword=$request->meta_keyword;
        $update->meta_description=$request->meta_description;
        $update->ordering_by=$request->ordering_by;
        $update->created_by=$user_id;
        $update->panel_id='1';
     
       
       $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];
    $update->save();
      $after = json_encode($update);
    
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Child Service Update','12','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(3,1,' Child Service');
     return redirect(asset('backend/service/childservice'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
    //Child Service Allotted City Work Start//
    
    
    
     function childserviceallottedcity(Request $request){
       
        $user_id = session('SUPERADMIN_ID');
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $id=Crypt::decrypt($request->id);
    $data['childservice']= ChildService::where('id',$id)->first();
   
     $data['country'] = DB::table('serviceallottedcities')->where('service_type','2')->distinct()->select('countries_id')->where('status','1')->get();
      insertLogsAPI($user_id,'2','Child Service  Allotted City View','','','','','','','',''); 
    return view('backend.service.childserviceallottedcity',$data);
}



 function childserviceallottedcityview(Request $request){
     $service_id =$request->service_id;
     $childservice_id =$request->childservice_id;
     $filterdata=[
         'countriesfilter'=>$request->countriesfilter,
         'statefilter'=>$request->statefilter,
         'cityfilter'=>$request->cityfilter,
         'statusfilter'=>$request->statusfilter,
         ];
       
    $draw  = $request->draw ?? 1;
    $rows  = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex     = $request->order[0]['column'] ?? 0;
    $columnName      = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? '';
    $searchValue     = $request->search['value'] ?? '';


 $user_id = session('SUPERADMIN_ID');
  $roledata = superadmin::where('id', $user_id)->first();
   
   

    $housesurveydata = Serviceallottedcity::childserviceallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$filterdata,$service_id,$childservice_id);
    $housesurveycount = Serviceallottedcity::childserviceallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$filterdata,$service_id,$childservice_id);
   
  
  
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
         $checkbox = '<input type="checkbox" class="row-checkbox" value="' . $row->id . '">';
  $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    $action .= '<li class="list-unstyled " style="margin: 0;">';
   
    $action .= '<a href="' . asset('backend/childserviceallottedcitydelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-2">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>
    </li>';
    
    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';

     
 $city =DB::table('tbl_cities')->where('city_id', $row->city_id)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $Cityname = '<span>'.$city.'</span>'; 
     
 $state =DB::table('tbl_states')->where('state_id', $row->state_id)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $Statename = '<span>'.$state.'</span>'; 
     
 $country =DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Countryname = '<span>'.$country.'</span>'; 
     
  
        
       
       
       
        
  
        
   $country = DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
        $countryName = $country->name ?? '';
        $countryName = '';

      
   
     $data[] = array(
 "id"        => $checkbox . " " . $row->id, 
  
   "countries" => $Countryname,
   "state" => $Statename,
   "city" => $Cityname,
   "status" => $status,
    "action" => $action
);

    
    }
    

    $query = DB::table('serviceallottedcities')->orderBy('id', 'DESC')->where('service_type','3')->where('serviceid',$childservice_id);



  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    }
    
    
    
    public function childserviceallottedcitystatus(Request $request)
{
    $id = $request->id;
    $newStatus = (string) $request->status;

    // Find record by id
    $record = Serviceallottedcity::find($id);

    if (!$record) {
        return response()->json([
            'success' => false,
            'message' => 'Child Service not found'
        ], 404);
    }

    // Call updateAllottedCityStatus with validation
    $result = updateAllottedCityStatus('child', $record, $newStatus);

    if (!$result['success']) {
        return response()->json([
            'success' => false,
            'message' => $result['message']
        ], 400);
    }

    // Save new status only if valid
    $record->status = $newStatus;
    $record->save();

    return response()->json(['success' => true]);
}

// Controller


 function childservicecountrydata(Request $request)
{
    $service_id = $request->service_id;

    // States
    $states = DB::table('serviceallottedcities as sac')
        ->join('tbl_states as s', 'sac.state_id', '=', 's.state_id')
        ->where('sac.countries_id', $request->country_id)
        ->where('sac.service_type', '2')
        ->where('sac.status', '1') 
        ->distinct()
        ->get(['sac.state_id', 's.name']);

    // Cities
    $cities = [];
    if ($request->state_id) {
        $cities = DB::table('serviceallottedcities as sac')
            ->join('tbl_cities as c', 'sac.city_id', '=', 'c.city_id')
            ->where('sac.state_id', $request->state_id)
            ->where('sac.service_type', '2')
            ->where('sac.status', '1') 
            ->distinct()
            ->get(['sac.city_id', 'c.name']);
    }

    return response()->json(['states' => $states, 'cities' => $cities]);
}

 function childserviceallottedcityadd(Request $request)
{
    $user_id   = session('SUPERADMIN_ID');
    $serviceId = $request->id;
    $countryId = $request->countries;
    $stateId   = $request->state;
    $cityId    = $request->city;
    $status    = $request->status;

  

    $ip        = CurrentTimestamp()['ip'];
    $strtotime = CurrentTimestamp()['strtotime'];

    $inserted = false;
    $updated  = false;

    
    if (!empty($cityId)) {
        $existing = Serviceallottedcity::where('service_type','3')->where('city_id', $cityId)->where('serviceid',$serviceId)->first();

        if ($existing) {
            
            $before = json_encode($existing);

            $existing->status           = $status ?? '1';
         
            $existing->ip               = $ip;
            $existing->strtotime        = $strtotime;
            $existing->save();

            $after   = json_encode($existing);
            $adduser = $existing->id;

            insertLogsAPI($user_id,'2','Child Service Allotted City Update','','',$adduser,'','',$after,$before,''); 
            $updated = true;

        } else {
           
            $create = new Serviceallottedcity();
            $create->serviceid        = $serviceId;
            $create->service_type     = '3';
            $create->countries_id     = $countryId;
            $create->state_id         = $stateId;
            $create->city_id          = $cityId;
            $create->status           = $status ?? '1';
           
            $create->ip               = $ip;
            $create->strtotime        = $strtotime;
            $create->save();

            $after   = json_encode($create);
            $before  = json_encode([]);
            $adduser = $create->id;

            insertLogsAPI($user_id,'1','Child Service Allotted City Add','','',$adduser,'','',$after,$before,''); 
            $inserted = true;
        }

    } else {
       
        $cities = DB::table('serviceallottedcities')->where('state_id', $stateId)->where('status','1')->where('service_type','2')->get();

        foreach ($cities as $city) {
            $existing = Serviceallottedcity::where('serviceid', $serviceId)->where('city_id', $city->city_id)->where('service_type','3')->first();

            if ($existing) {
              
                $before = json_encode($existing);

                $existing->status           = $status ?? '1';
              
                $existing->ip               = $ip;
                $existing->strtotime        = $strtotime;
                $existing->save();

                $after   = json_encode($existing);
                $adduser = $existing->id;

                insertLogsAPI($user_id,'2','Child Service Allotted City Update','','',$adduser,'','',$after,$before,''); 
                $updated = true;

            } else {
             
                $create = new Serviceallottedcity();
                $create->serviceid        = $serviceId;
                $create->service_type     = '3';
                $create->countries_id     = $countryId;
                $create->state_id         = $stateId;
                $create->city_id          = $city->city_id;
                $create->status           = $status ?? '1';
             
                $create->ip               = $ip;
                $create->strtotime        = $strtotime;
                $create->save();

                $after   = json_encode($create);
                $before  = json_encode([]);
                $adduser = $create->id;

                insertLogsAPI($user_id,'1',' Child Service Allotted City Add','','',$adduser,'','',$after,$before,''); 
                $inserted = true;
            }
        }
    }

    if ($updated) {
        $message = fleshmessage(3,1,' Child Service Allotted City');
        return redirect()->back()->with($message['status'],$message['message']);
    } elseif ($inserted) {
        $messagei = fleshmessage(2,1,' Child Service Allotted City');
        return redirect()->back()->with($messagei['status'],$messagei['message']);
    } else {
        return redirect()->back()->with('error', 'Something went wrong.');
    }
}


function childserviceallottedcitydelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
        $id=Crypt::decrypt($id);
        $delete = Serviceallottedcity::findOrFail($id);
        $delete->delete();
         $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Child Service Allotted City Delete','','',$adduser,'','',$after,$before); 
    $message = fleshmessage(4,1,'Child Service Allotted City');
          return redirect()->back()->with($message['status'],$message['message']);
   
    }
    
    
    
    
    
  //Child Service Curd Function End//
   
  //Service Plan Curd Function
  
  
   function  serviceplan(){
     
          
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '17', 'action_view');
     if ($hasPermission) { 
           $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'17');
             $data['service']=Service::where('status','1')->get();
           insertLogsAPI($user_id,'2','Service Plan View','17','','','','','','',''); 
        return view('backend.service.serviceplan',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }
    
    
    




function serviceplancreate(Request $request){
 
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '17', 'action_add');
     if ($hasPermission) { 
        $existingMobile = ServicePlan::where('slug', $request->slug)->first();
        if ($existingMobile) {
        $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
        }
        $existingMobile = ServicePlan::where('title', $request->title)->where('subservice_id', $request->subservice_id)->where('service_id', $request->service_id)->first();
        if ($existingMobile) {
        $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
        }
        $user_id = session('SUPERADMIN_ID');

        $create=new ServicePlan;
        $create->service_id=$request->service_id;
        $create->subservice_id=$request->subservice_id;
        $create->childservice_id=$request->childservice_id;
        
        $create->title=$request->title;
        $create->slug =$request->slug;
        $create->video_link =$request->video_link;
        
        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/serviceplan'), $img);
        $create->image = $img;
          }
          
        if ($request->hasFile('multiple_image')) {
        foreach ($request->file('multiple_image') as $file) {
        $img = time() . '_' . uniqid() . '.' . $file->extension();
        $file->move(public_path('uploads/serviceplan'), $img);
        $images[] = $img;
        }
        
        $create->multiple_image = json_encode($images);
        }
        if ($request->video) {
        $img = time() . 'video.' . $request->video->extension();
        $request->video->move(public_path('uploads/serviceplan'), $img);
        $create->video = $img;
          }
        $create->img_description=$request->img_description;
        
        $create->def_price=$request->def_price;
        $create->mrp_price=$request->mrp_price;
        $create->ordering_by=$request->ordering_by;
        
        $create->short_description=$request->short_description;
        $create->description=$request->description;
        
        $create->meta_title=$request->meta_title;
        $create->meta_keyword=$request->meta_keyword;
        $create->meta_description=$request->meta_description;
        
        $create->user_id=$user_id;
        $create->created_by=$user_id;
        $create->panel_id='1';
    
        $create->token=reandum_code('50');
        
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
        
        $create->save();
        
        $after = json_encode($create);
        $before = json_encode($create);
        $adduser=$create->id;
        insertLogsAPI($user_id,'1',' Service Plan Add','17','',$adduser,'','',$after,$before,''); 
        
        $message = fleshmessage(2,1,' Service Plan');
        return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
    
    function serviceplanajaxview(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');
    $roledata = superadmin::where('id', $user_id)->first();

    if($roledata && $roledata->role=='1'){
        
        $housesurveydata = ServicePlan::serviceplanajaxview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = ServicePlan::serviceplanajaxview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = ServicePlan::serviceplanajaxview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = ServicePlan::serviceplanajaxview($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'17','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/serviceplanaedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

       
    
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'17','action_edit')){
            $action .= '   <a class="btn actionedit viewbtn btn-sm " href="' . asset('backend/singleviewserviceplan/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-show anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'17','action_edit')){
            $action .= '   <a class="btn  planbtn btn-sm " href="' . asset('backend/serviceplanallottedcity/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-dollar anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';
         $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'17','action_delete')){
            $action .= '<a href="' . asset('backend/serviceplanadelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';

        $action .= '</ul>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';
        
         $subservice = Subservice::where('id',$row->subservice_id)->first();
         if(empty($subservice)){
        $subservice = "";
    }else{
        $subservice = $subservice->title;
    } 
     $Subservice = '<span>'.$subservice.'</span>'; 
     
  $service = Service::where('id',$row->service_id)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Services = '<span>'.$service.'</span>';
     
$child = ChildService::where('id', $row->childservice_id)->first();

if (empty($child)) {
    $child = "";
} else {
    $child = '<br><span class="badge childservicecolor" style="background:#009688;">' 
           . $child->title . 
           '</span>';
}


        $data[] = array(
   "id" => $row->id, 
  "service" => 
    '<span class="badge servicecolor" style="background:#5D3FD3;">' . $Services . '</span><br>' .
    '<span class="badge subservicecolor" style="background:#E91E63;">' . $Subservice . '</span>' .
    $child,
"price" => 
    '<div class="d-flex flex-column">
        <span>₹' . number_format($row->def_price) . '</span>' .
        ($row->mrp_price 
            ? '<small class="text-danger text-decoration-line-through">₹' . number_format($row->mrp_price) . '</small>' 
            : ''
        ) .
    '</div>',


   "title" => $row->title,
   "image" => '<a href="' . asset('uploads/serviceplan/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/serviceplan/' . $row->image) . '" style=" width: 30px;"></a>',
   "ordering_by" => $row->ordering_by,
   "status" => $status,
   "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '17', 'action_globle_view');
    $canAccessCity = permission($user_id, '17', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('service_plans')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('service_plans')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('service_plans')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('service_plans')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}


 public function serviceplanstatus(Request $request)
{
    $id = $request->id;
    $plan = ServicePlan::find($id);

    if (!$plan) {
        return response()->json(['success' => false, 'message' => 'Service Plan not found'], 404);
    }

    $result = updateStatus('plan', $id, $request->status);

    // Always return the final DB value
    $currentStatus = ServicePlan::where('id', $id)->value('status');

    return response()->json([
        'success' => $result['success'],
        'message' => $result['message'] ?? null,
        'status'  => $currentStatus
    ]);
}


 function serviceplanadelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '17', 'action_delete');
     if ($hasPermission) { 
   
        $id=Crypt::decrypt($id);
        $user_id = session('SUPERADMIN_ID');
        $delete = ServicePlan::findOrFail($id);
      $image_path = public_path("uploads/serviceplan/{$delete->image}");
      $multipal_path = public_path("uploads/serviceplan/{$delete->multiple_image}");
     
        
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
           
            unlink($image_path);
        }
         if (File::exists($multipal_path) && !File::isDirectory($multipal_path)) {
           
            unlink($multipal_path);
        }
        $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4',' Service Plan Delete','17','',$adduser,'','',$after,$before,''); 


        
     $message = fleshmessage(4,1,'Service Plan');
          return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }
    
    
    function serviceplanaedit(Request $request){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '17', 'action_edit');
     if ($hasPermission) { 
    
    $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'17');
    
        $id=Crypt::decrypt($request->id);
        $data['serviceplandata']=ServicePlan::where('id',$id)->first();
        
        $data['service']=Service::where('status','1')->get();
       //// $data['subservice']=Subservice::where('status','1','service_id',$data['serviceplandata']->service_id)->get();
        return view('backend.service.serviceplanedit',$data);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
    
    function serviceplanupdate(Request $request){
       
        $user_id = session('SUPERADMIN_ID');
   
     $hasPermission = permission($user_id, '17', 'action_edit');
     if ($hasPermission) { 
        $id = Crypt::decrypt($request->id);
             $existingSlug = ServicePlan::where('slug', $request->slug)->where('id','!=',$id)->first();
    if ($existingSlug) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
             $existingMobile = ServicePlan::where('title', $request->title)->where('subservice_id', $request->subservice_id)->where('service_id', $request->service_id)->where('id','!=',$id)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }

        $update = ServicePlan::where('id',$id)->first();
        $before = json_encode($update);
        $update->service_id=$request->service_id;
        $update->subservice_id=$request->subservice_id;
        $update->childservice_id=$request->childservice_id;
        $update->user_id=$user_id;
        
        $update->title=$request->title;
        $update->slug =$request->slug;
        $update->video_link =$request->video_link;
        
       if ($request->hasFile('image')) {
       
        if ($update->image && file_exists(public_path('uploads/serviceplan/' . $update->image))) {
            unlink(public_path('uploads/serviceplan/' . $update->image));
        }

      
        $img = preg_replace('/\.[^.]+$/', '', $update->image) . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/serviceplan'), $img);
        $update->image = $img;
    }
      if ($request->hasFile('multiple_image')) {

    if ($update->multiple_image) {
        $oldImages = json_decode($update->multiple_image, true); // JSON format
        if (is_array($oldImages)) {
            foreach ($oldImages as $oldImg) {
                $oldPath = public_path('uploads/serviceplan/' . $oldImg);
                if (file_exists($oldPath)) {
                    unlink($oldPath);
                }
            }
        }
    }

    $images = [];
    foreach ($request->file('multiple_image') as $file) {
        $imgName = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
        $file->move(public_path('uploads/serviceplan'), $imgName);
        $images[] = $imgName;
    }


    $update->multiple_image = json_encode($images);
}
  if ($request->hasFile('video')) {
       
        if ($update->video && file_exists(public_path('uploads/serviceplan/' . $update->video))) {
            unlink(public_path('uploads/serviceplan/' . $update->video));
        }

      
        $img = preg_replace('/\.[^.]+$/', '', $update->video) . '.' . $request->video->extension();
        $request->video->move(public_path('uploads/serviceplan'), $img);
        $update->video = $img;
    }
       
        $update->img_description=$request->img_description;
        $update->short_description=$request->short_description;
        $update->description=$request->description;
        $update->meta_title=$request->meta_title;
        $update->meta_keyword=$request->meta_keyword;
        $update->meta_description=$request->meta_description;
        $update->def_price=$request->def_price;
        $update->mrp_price=$request->mrp_price;
        $update->ordering_by=$request->ordering_by;
        $update->created_by=$user_id;
        $update->panel_id='1';
     
       
       $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];
    $update->save();
      $after = json_encode($update);
    
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Service Plan Update','17','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(3,1,' Service Plan');
     return redirect(asset('backend/service/serviceplan'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    


    
//Service Plan Single View

function singleviewserviceplan(Request $request){
    $id = Crypt::decrypt($request->id);
      $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '17', 'action_edit');
     if ($hasPermission) { 
        $data['serviceplan']=ServicePlan::where('id',$id)->first();
           insertLogsAPI($user_id,'2',' Single View Service Plan','17','','','','','','',''); 
        return view('backend.service.singleviewserviceplan',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    
}



 
     function serviceplanallottedcity(Request $request){
       
        $user_id = session('SUPERADMIN_ID');
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $id=Crypt::decrypt($request->id);
    $data['serviceplancity']= ServicePlan::where('id',$id)->first();
   
     $data['country'] = DB::table('serviceallottedcities')->where('service_type','2')->where('status','1')->distinct()->select('countries_id')->get();
      insertLogsAPI($user_id,'2',' Service Plan  Allotted City View','','','','','','','',''); 
    return view('backend.service.serviceplanallottedcity',$data);
}


 function serviceplancountrydata(Request $request)
{
    $service_id = $request->service_id;

    // States
    $states = DB::table('serviceallottedcities as sac')
        ->join('tbl_states as s', 'sac.state_id', '=', 's.state_id')
        ->where('sac.countries_id', $request->country_id)
        ->where('sac.service_type', '2')
        ->where('sac.status', '1') 
        ->distinct()
        ->get(['sac.state_id', 's.name']);

    // Cities
    $cities = [];
    if ($request->state_id) {
        $cities = DB::table('serviceallottedcities as sac')
            ->join('tbl_cities as c', 'sac.city_id', '=', 'c.city_id')
            ->where('sac.state_id', $request->state_id)
            ->where('sac.service_type', '2')
            ->where('sac.status', '1') 
            ->distinct()
            ->get(['sac.city_id', 'c.name']);
    }

    return response()->json(['states' => $states, 'cities' => $cities]);
}



 function serviceplanallottedcityadd(Request $request)
{
    $user_id   = session('SUPERADMIN_ID');
    $serviceId = $request->id;
    $countryId = $request->countries;
    $stateId   = $request->state;
    $cityId    = $request->city;
    $status    = $request->status;
   
    $ip        = CurrentTimestamp()['ip'];
    $strtotime = CurrentTimestamp()['strtotime'];

    $inserted = false;
    $updated  = false;

    
    if (!empty($cityId)) {
        $existing = Serviceallottedcity::where('city_id', $cityId)->where('service_type','4')->where('serviceid',$serviceId)
            ->first();

        if ($existing) {
            
            $before = json_encode($existing);
            $existing->status           = $status ?? '1';
            $existing->ip               = $ip;
            $existing->price = $request->price;
            $existing->strtotime        = $strtotime;
            $existing->save();
          
            $after   = json_encode($existing);
            $adduser = $existing->id;
            insertLogsAPI($user_id,'2','Service Plan Allotted City Update','','',$adduser,'','',$after,$before,''); 
            $updated = true;

        } else {
           
            $create = new Serviceallottedcity();
            $create->serviceid        = $serviceId;
            $create->service_type     = '4';
            $create->countries_id     = $countryId;
            $create->price     = $request->price;
            $create->state_id         = $stateId;
            $create->city_id          = $cityId;
            $create->status           = $status ?? '1';
           
            $create->ip               = $ip;
            $create->strtotime        = $strtotime;
            $create->save();

            $after   = json_encode($create);
            $before  = json_encode([]);
            $adduser = $create->id;

            insertLogsAPI($user_id,'1','Service Plan Allotted City Add','','',$adduser,'','',$after,$before,''); 
            $inserted = true;
        }

   } else {
       
        $cities = DB::table('serviceallottedcities')->where('state_id', $stateId)->where('status','1')->where('service_type','2')->get();
     
        foreach ($cities as $city) {
            $existing = Serviceallottedcity::where('city_id', $city->city_id)->where('service_type','4')->where('serviceid',$serviceId)->first();

            if ($existing) {
              
                $before = json_encode($existing);

                $existing->status           = $status ?? '1';
              
                $existing->ip               = $ip;
                $existing->price               = $request->price;
                $existing->strtotime        = $strtotime;
                $existing->save();
           
                $after   = json_encode($existing);
                $adduser = $existing->id;

                insertLogsAPI($user_id,'2',' Service Plan Allotted City Update','','',$adduser,'','',$after,$before,''); 
                $updated = true;

            } else {
             
                $create = new Serviceallottedcity();
                $create->serviceid        = $serviceId;
                $create->service_type     = '4';
                $create->countries_id     = $countryId;
                $create->price     = $request->price;
                $create->state_id         = $stateId;
                $create->city_id          = $city->city_id;
                $create->status           = $status ?? '1';
             
                $create->ip               = $ip;
                $create->strtotime        = $strtotime;
                $create->save();
                         

                $after   = json_encode($create);
                $before  = json_encode([]);
                $adduser = $create->id;

                insertLogsAPI($user_id,'1',' Service Plan Allotted City Add','','',$adduser,'','',$after,$before,''); 
                $inserted = true;
            }
        }
    }
    
    

    if ($updated) {
        $message = fleshmessage(3,1,'Service Plan Allotted City');
        return redirect()->back()->with($message['status'],$message['message']);
    } elseif ($inserted) {
        $messagei = fleshmessage(2,1,' Service Plan Allotted City');
        return redirect()->back()->with($messagei['status'],$messagei['message']);
    } else {
        return redirect()->back()->with('error', 'Something went wrong.');
    }
}






function serviceplanallottedcityview(Request $request){
     $service_id =$request->service_id;
     $serviceplan_id =$request->serviceplan_id;
     $filterdata=[
         'countriesfilter'=>$request->countriesfilter,
         'statefilter'=>$request->statefilter,
         'cityfilter'=>$request->cityfilter,
         'statusfilter'=>$request->statusfilter,
         ];
       
  $draw  = $request->draw ?? 1;
    $rows  = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex     = $request->order[0]['column'] ?? 0;
    $columnName      = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? '';
    $searchValue     = $request->search['value'] ?? '';

 $user_id = session('SUPERADMIN_ID');
  $roledata = superadmin::where('id', $user_id)->first();
   
   

    $housesurveydata = Serviceallottedcity::serviceplanallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$filterdata,$service_id,$serviceplan_id);
    $housesurveycount = Serviceallottedcity::serviceplanallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$filterdata,$service_id,$serviceplan_id);
   
  
  
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
           $checkbox = '<input type="checkbox" class="row-checkbox" value="' . $row->id . '">';
  $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    $action .= '<li class="list-unstyled " style="margin: 0;">';
   
    $action .= '<a href="' . asset('backend/serviceplanallottedcitydelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-2">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>
    </li>';
    
    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
         ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';

     
 $city =DB::table('tbl_cities')->where('city_id', $row->city_id)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $Cityname = '<span>'.$city.'</span>'; 
     
 $state =DB::table('tbl_states')->where('state_id', $row->state_id)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $Statename = '<span>'.$state.'</span>'; 
     
 $country =DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Countryname = '<span>'.$country.'</span>'; 
     
  
        
        
  
        
   $country = DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
        $countryName = $country->name ?? '';
        $countryName = '';

      
   
     $data[] = array(
    "id"        => $checkbox . " " . $row->id, 
  
   "countries" => $Countryname,
   "state" => $Statename,
   "city" => $Cityname,
   "price" => $row->price,
   "status" => $status,
    "action" => $action
);

    
    }
    

    $query = DB::table('serviceallottedcities')->orderBy('id', 'DESC')->where('service_type','4')->where('serviceid',$serviceplan_id);



  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    }
    
    
    function serviceplanallottedcitydelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
        $id=Crypt::decrypt($id);
        $delete = Serviceallottedcity::findOrFail($id);
        $delete->delete();
         $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Service Plan Allotted City Delete','','',$adduser,'','',$after,$before); 
    $message = fleshmessage(4,1,'Service Plan Allotted City');
          return redirect()->back()->with($message['status'],$message['message']);
   
    }
    
    
    
    
    public function serviceplanallottedcitystatus(Request $request)
{
    $id = $request->id;
    $newStatus = (string) $request->status;

    // Find record by id
    $record = Serviceallottedcity::find($id);

    if (!$record) {
        return response()->json([
            'success' => false,
            'message' => 'Service Plan not found'
        ], 404);
    }

    $result = updateAllottedCityStatus('plan', $record, $newStatus);

    if (!$result['success']) {
        return response()->json([
            'success' => false,
            'message' => $result['message']
        ], 400);
    }

    // Save new status only if valid
    $record->status = $newStatus;
    $record->save();

    return response()->json(['success' => true]);
}


 function deletemultiplecities(Request $request)
{
    $ids = $request->ids;

    if (!empty($ids)) {
        $ids = array_filter($ids, function ($id) {
            return is_numeric($id);
        });

        if (!empty($ids)) {
            DB::table('serviceallottedcities')
                ->whereIn('id', $ids)
                ->delete();

            return response()->json([
                'status' => true,
                'message' => 'Selected records deleted successfully!'
            ]);
        }
    }

    return response()->json([
        'status' => false,
        'message' => 'No records selected!'
    ]);
}
 function deletemultiplecitieschild(Request $request)
{
    $ids = $request->ids;

    if (!empty($ids)) {
        $ids = array_filter($ids, function ($id) {
            return is_numeric($id);
        });

        if (!empty($ids)) {
            DB::table('serviceallottedcities')
                ->whereIn('id', $ids)
                ->delete();

            return response()->json([
                'status' => true,
                'message' => 'Selected records deleted successfully!'
            ]);
        }
    }

    return response()->json([
        'status' => false,
        'message' => 'No records selected!'
    ]);
}



    










}