<?php

namespace App\Http\Controllers\backend\partner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Partner;
use App\Models\superadmin;
use DB;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\File;
class PartnerController extends Controller
{
   
    function partner(){
          $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '32', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Partner View','32','','','','','','','');
            $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
            $data['id_proof_select'] = DB::table('id_proof_selects')->where('status','1')->get();
         return view('backend.partner.partner',$data);
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    } 
    
function partneradd(Request $request){
    
$user_id=session('SUPERADMIN_ID');
$hasPermission = permission($user_id, '32', 'action_add');
if ($hasPermission) { 
    
$create=new Partner;
$create->name = $request->name;
$create->email = $request->email;
$create->id_proof_select = $request->id_proof_select;
$create->mobile_number = $request->mobile_number;
if ($request->hasFile('id_proof')) {
    $files = $request->file('id_proof');
    $uploadedFiles = [];

    foreach ($files as $file) {
        $img = time() . '_' . uniqid() . '.' . $file->extension();
        $file->move(public_path('uploads/partner'), $img);
        $uploadedFiles[] = $img;
    }

  
    $create->id_proof = json_encode($uploadedFiles);
}



if ($request->profile) {
$image = time() . '.' . $request->profile->extension();
$request->profile->move(public_path('uploads/partner'), $image);
$create->profile = $image;
}

$create->dob = $request->dob;
$create->id_number = $request->id_number;
$create->partner_code = $request->partner_code;
$create->salary_status = $request->salary_status;
$create->salary = $request->salary;
$create->total_days = $request->total_days;
$create->per_day_salary = $request->per_day_salary;
$create->per_day_hourly = $request->per_day_hourly;
$create->per_hours_salary = $request->per_hours_salary;
$create->take_breack_hours = $request->take_breack_hours;
$create->commission = $request->commission;
$create->countries = $request->countries;
$create->state = $request->state;
$create->city = $request->city;
$create->pincode = is_array($request->pincode) ? implode(',', $request->pincode) : $request->pincode;
$create->user_id = $user_id;
$create->created_by=$user_id;
$create->panel_id='1';
$create->tokan=reandum_code('50');
$create->ip = CurrentTimestamp()['ip'];
$create->strtotime = CurrentTimestamp()['strtotime'];
$create->created_at = CurrentTimestamp()['datetime'];
$create->updated_at = CurrentTimestamp()['datetime'];
$create->save();
$after = json_encode($create);
$before = json_encode($create);
$adduser=$create->id;

insertLogsAPI($user_id,'1','Partner Add','32','',$adduser,'','',$after,$before,''); 
$message = fleshmessage(2,1,'Partner');
return redirect()->back()->with($message['status'],$message['message']);

}

$website = Websitesetting::where('id', '1')->first();
$messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
}     
    
    

  
    
    
function partnerviewajax(Request $request){
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
    $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $promocodedata = Partner::partnerviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $promocodecount = Partner::partnerviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
    $promocodedata = Partner::partnerviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $promocodecount = Partner::partnerviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($promocodedata as $row) {
    $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
    if(permission($user_id,'32','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/partneredit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';
               $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'16','action_edit')){
            $action .= '   <a class="btn actionedit viewbtn btn-sm " href="' . asset('backend/partnersingleview/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-show anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'32','action_delete')){
    $action .= '<a href="' . asset('backend/partnerdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';

    $action .= '</ul>';

    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
    $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
        <label class="flip-label" for="flip' . $row->id . '"></label>
    </div>';

   
     $data[] = array(
    "id" => $row->id, 
    "name" => '<a href="' . (!empty($row->profile) ? asset('uploads/partner/' . $row->profile) : asset('frontend/assets/image/user.png')) . 
          '" data-fancybox="images">
              <img src="' . (!empty($row->profile) ? asset('uploads/partner/' . $row->profile) : asset('frontend/assets/image/user.png')) . 
          '" class="profile-img" style="width:36px;"></a>&nbsp;' . $row->name,


    "email" => $row->email,
    "number" => $row->mobile_number,
    "status" => $status,
    "action" => $action
    );

    }
    
    $canViewGlobal = permission($user_id, '32', 'action_globle_view');
    $canAccessCity = permission($user_id, '32', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;


    if ($user_id == '1') {
        $query = DB::table('partners')->orderBy('id', 'DESC');

    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('partners')->orderBy('id', 'DESC');

    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('partners')->where('user_id', $user_id)->orderBy('id', 'DESC');

    } else {
        $query = DB::table('partners')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $promocodecount,
    "data" => $data
    );
    
    echo json_encode($datas);
}



  public function partnerstatus(Request $request) {
    $id = $request->id;
    $status = Partner::find($id);

    if (!$status) {
        return response()->json(['success' => false, 'message' => ' Email Template   not found'], 404);
    }
    $status->status = $request->status;
    $status->save();

    return response()->json(['success' => true]);
}




public function partnerdelete(Request $request, $id)
{
    $id = Crypt::decrypt($id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '32', 'action_delete');
    if ($hasPermission) { 
    $delete = Partner::findOrFail($id);
    if ($delete->id_proof) {
        $logoPath = public_path('uploads/partner/' . $delete->id_proof);
        if (file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }
    
    if ($delete->profile) {
        $logoPathprofile = public_path('uploads/partner/' . $delete->profile);
        if (file_exists($logoPathprofile)) {
            @unlink($logoPathprofile);
        }
    }

    $delete->delete();
    $after = json_encode($delete);
    $before = json_encode($delete);
    $adduser=$delete->id;
        
    insertLogsAPI($user_id,'4','Partner Delete','32','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(4,1,'Partner');
    return redirect()->back()->with($message['status'],$message['message']);
    }
    
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
}




function partnersingleview(Request $request){
    $id = Crypt::decrypt($request->id);
      $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '32', 'action_edit');
     if ($hasPermission) { 
        $data['partnerdata']=Partner::where('id',$id)->first();
        $data['verifydata']=DB::table('tbl_partner_verifies')->where('partner_id', $id)->first();
           insertLogsAPI($user_id,'2',' Single View Partner','32','','','','','','',''); 
        return view('backend.partner.partnersingleview',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    
}

function partneredit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '32', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        
        $data['partner']=Partner::where('id',$id)->first();
          $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
             $data['id_proof_select'] = DB::table('id_proof_selects')->where('status','1')->get();
        return view('backend.partner.partneredit',$data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }
    
    				 
	function partnerupdate(Request $request){
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '32', 'action_edit');
    if ($hasPermission) { 
   
   
    $update = Partner::findOrFail($id);
    $before = json_encode($update);
      
    $update->name = $request->name;
    $update->email = $request->email;
    $update->mobile_number = $request->mobile_number;
   if ($request->hasFile('id_proof')) {
    $files = $request->file('id_proof');
    $uploadedFiles = [];


    $existingFiles = [];
    if (!empty($update->id_proof)) {
        $existingFiles = json_decode($update->id_proof, true);
    }

   
    foreach ($files as $file) {
        $img = time() . '_' . uniqid() . '.' . $file->extension();
        $file->move(public_path('uploads/partner'), $img);
        $uploadedFiles[] = $img;
    }


    $finalFiles = array_merge($existingFiles, $uploadedFiles);

 
    $update->id_proof = json_encode($finalFiles);
}

    if ($request->profile) {
    if($update->profile && file_exists(public_path('uploads/partner/' . $update->profile))){
            unlink(public_path('uploads/partner/' . $update->profile));
        }
        $imgupdate = time() . '.' . $request->profile->extension();
        $request->profile->move(public_path('uploads/partner'), $imgupdate);
        $update->profile = $imgupdate;
    }
    

    $update->partner_code = $request->partner_code;
    $update->dob = $request->dob;
    $update->id_number = $request->id_number;
    $update->salary_status = $request->salary_status;
    $update->salary = $request->salary;
    $update->id_proof_select = $request->id_proof_select;
    $update->total_days = $request->total_days;
    $update->per_day_salary = $request->per_day_salary;
    $update->per_day_hourly = $request->per_day_hourly;
    $update->per_hours_salary = $request->per_hours_salary;
    $update->take_breack_hours = $request->take_breack_hours;
    $update->commission = $request->commission;
    $update->countries = $request->countries;
    $update->state = $request->state;
    $update->city = $request->city;
    $update->pincode = is_array($request->pincode) ? implode(',', $request->pincode) : $request->pincode;
    $update->user_id = $user_id;
    $update->created_by=$user_id;
    $update->panel_id='1';
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];
    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Partner Update','32','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(3,1,'Partner');
    return redirect(url('backend/partner/partner'))->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }  
    
    

public function partnerverify(Request $request)
{
    try {
        $partner_id = Crypt::decrypt($request->partner_id);

        $exists = DB::table('tbl_partner_verifies')->where('partner_id', $partner_id)->first();

        $data = [
            'partner_id'      => $partner_id,
            'email'           => $request->email,
            'mobile'          => $request->mobile_number,
            'type'            => $request->type,
            'email_verify'    => $request->email_verify ?? 0,
            'mobile_verify'   => $request->mobile_verify ?? 0,
            'document_status' => $request->document_status ?? 0,
            'ip'              => CurrentTimestamp()['ip'],
            'strtotime'       => CurrentTimestamp()['strtotime'],
            'updated_at'      => CurrentTimestamp()['datetime'],
        ];

        if ($exists) {
            DB::table('tbl_partner_verifies')->where('partner_id', $partner_id)->update($data);
        } else {
            $data['created_at'] = CurrentTimestamp()['datetime'];
            DB::table('tbl_partner_verifies')->insert($data);
        }

        return response()->json(['status' => 'success']);
    } catch (\Exception $e) {
        return response()->json(['status' => 'error', 'message' => $e->getMessage()]);
    }
}

}
