<?php

namespace App\Http\Controllers\backend\master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;

use Illuminate\Support\Facades\Validator;
use App\Models\ChildService;
use App\Models\Serviceallottedcity;
use App\Models\Brand;
use App\Models\Service;
use App\Models\Subservice;
use App\Models\tbl_permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class BrandController extends Controller
{
function brands() {
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }

    $user_id = session('SUPERADMIN_ID');

    $data['services'] = Service::where('status', '1')->get();

    $hasPermission = permission($user_id, '11', 'action_view');
    if ($hasPermission) { 
        insertLogsAPI($user_id, '2', 'Brand View', '11', '', '', '', '', '', '', ''); 
        $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'11');
        return view('backend.master.brand', $data);
    }

    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

    
 function brandsedit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '11', 'action_edit');
    if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['services'] = Service::where('status', '1')->get();
        $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'11');
        $data['branddata']=Brand::where('id',$id)->first();
        return view('backend.master.brandedit',$data);
    }
     $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    


   

function brandscreate(Request $request) {
    
     $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '11', 'action_add');
    if ($hasPermission) { 
     $existingMobile = Brand::where('slug', $request->slug)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }

    $create = new Brand;

    // Save foreign keys
$create->service_id = $request->service_id;
$create->subservice_id = $request->subservice_id;
$create->brand_name = $request->brand_name;
$create->user_id = $user_id;
    $create->slug = $request->slug;
    $create->tollfree_number = $request->tollfree_number;
    $create->ordering_by = $request->ordering_by;
    $create->description = $request->description;

    // Handle brand logo upload
    if ($request->hasFile('brand_logo')) {
        $imgName = time() . '_brand_logo.' . $request->brand_logo->extension();
        $request->brand_logo->move(public_path('uploads/brands'), $imgName);
        $create->brand_logo = $imgName;
    }

    $create->created_by=$user_id;
    $create->panel_id = '1';
    $create->tokan = reandum_code('50');
    $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
 $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save();

    $after = json_encode($create);
    $before = json_encode($create);
    $adduser = $create->id;

    insertLogsAPI($user_id, '1', 'Brand Add', '11', '', $adduser, '', '', $after, $before, '');

    $message = fleshmessage(2, 1, 'Brand');
    return redirect()->back()->with($message['status'], $message['message']);
    
    }
     $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

   
public function brandsupdate(Request $request)
{
    
     $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '11', 'action_edit');
    if ($hasPermission) { 
       $id = Crypt::decrypt($request->id);
    $existingMobile = Brand::where('slug', $request->slug)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
 

    // Find the existing brand record
    $brand = Brand::findOrFail($id);

    // Save old data for logs
    $before = json_encode($brand);

    // Update foreign keys and other fields
    $brand->service_id = $request->service_id;
    $brand->subservice_id = $request->subservice_id;
    $brand->brand_name = $request->brand_name;
    $brand->user_id = $user_id;
    $brand->slug = $request->slug;
    $brand->tollfree_number = $request->tollfree_number;
    $brand->ordering_by = $request->ordering_by;
    $brand->description = $request->description;

    // Handle brand logo upload - delete old image if new uploaded
    if ($request->hasFile('brand_logo')) {
        // Delete old image if exists
        if ($brand->brand_logo && file_exists(public_path('uploads/brands/' . $brand->brand_logo))) {
            unlink(public_path('uploads/brands/' . $brand->brand_logo));
        }

        $imgName = time() . '_brand_logo.' . $request->brand_logo->extension();
        $request->brand_logo->move(public_path('uploads/brands'), $imgName);
        $brand->brand_logo = $imgName;
    }
    $brand->created_by=$user_id;
    $brand->panel_id='1';

    $brand->updated_at = CurrentTimestamp()['datetime'];
        $brand->ip = CurrentTimestamp()['ip'];
    $brand->strtotime = CurrentTimestamp()['strtotime'];
    $brand->save();

    // Save new data for logs
    $after = json_encode($brand);

    insertLogsAPI($user_id, '3', 'Brand Update', '11', '', $brand->id, '', '', $after, $before, '');

    $message = fleshmessage(3, 1, 'Brand'); // Assuming fleshmessage(3,1) is for update success
    return redirect(url('backend/master/brands'))->with($message['status'],$message['message']);
}
 $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}





  public function brandsstatus(Request $request) {
    $id = $request->id;
    $status = Brand::find($id);

    if (!$status) {
        return response()->json(['success' => false, 'message' => ' Brand  not found'], 404);
    }
    $status->status = $request->status;
    $status->save();

    return response()->json(['success' => true]);
}




public function brandsdelete(Request $request, $id)
{

    $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '11', 'action_delete');
    if ($hasPermission) { 
    $id = Crypt::decrypt($id);

    $delete = Brand::findOrFail($id);
    if ($delete->brand_logo) {
        $logoPath = public_path('uploads/brands/' . $delete->brand_logo);

        if (file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }

    $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
        
         insertLogsAPI($user_id,'4','Brand Delete','11','',$adduser,'','',$after,$before,''); 
      $message = fleshmessage(4,1,'Brand');
          return redirect()->back()->with($message['status'],$message['message']);
    }
     $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}








      function brandsajax(Request $request){
   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $branddata = Brand::brandsajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $brandcount = Brand::brandsajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $branddata = Brand::brandsajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $brandcount = Brand::brandsajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($branddata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
   if(permission($user_id,'11','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/brandsedit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';

   

    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'11','action_delete')){
    $action .= '<a href="' . asset('backend/brandsdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';



    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
  $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                 data-fid="11"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';
        

         $subservice = Subservice::where('id',$row->subservice_id)->first();
         if(empty($subservice)){
        $subservice = "";
    }else{
        $subservice = $subservice->title;
    } 
     $Subservice = '<span>'.$subservice.'</span>'; 
     
  $service = Service::where('id',$row->service_id)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Services = '<span>'.$service.'</span>';

$data[] = [
    "id" => $i++,
     "service" => 
    '<span class="badge servicecolor" style="background:#5D3FD3;">' . $Services . '</span><br>' .
    '<span class="badge subservicecolor" style="background:#E91E63;">' . $Subservice . '</span>',
    "brand_name" => $row->brand_name,
    "brand_logo" => '<a href="' . asset('uploads/brands/' . $row->brand_logo) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/brands/' . $row->brand_logo) . '" style=" width: 36px;"></a>',
    //  "brand_logo" => '<a href="' . asset('uploads/product/' . $row->brand_logo) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/product/' . $row->brand_logo) . '" style=" width: 36px;"></a>',
    "tollfree_number" => $row->tollfree_number,
    "ordering_by" => $row->ordering_by,
    "status" => $status,
    "action" => $action
];


    
    }
    
 $canViewGlobal = permission($user_id, '11', 'action_globle_view');
$canAccessCity = permission($user_id, '11', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;

if ($user_id == '1') {
    $query = DB::table('brands')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('brands')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('brands')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');

} else {
    $query = DB::table('brands')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $brandcount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
   
}
