<?php

namespace App\Http\Controllers\backend\login;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\tbl_message_api;
use App\Models\tbl_admin_otpverifie;

use Validator,Redirect,Response;
use Illuminate\Support\Facades\Mail;
use App\Mail\Backend\AdminEmailVerify;

use Illuminate\Support\Facades\DB;
use App\Models\Role;
use App\Models\Websitesetting;
use Crypt;
use Session;

use Hash;

class LoginController extends Controller
{
    //
    
    public function forgetpassword() {
        
    if (session('SUPERADMIN_ID')) { 
        return redirect()->route('backend.index'); 
    } else {
        return view('backend.login.forgetpassword');
    }
    }
    
    
    function login(){
  
        if (session('SUPERADMIN_ID')) { 
        return redirect()->route('backend.index'); 
    } else {
           
        return view('backend.login.login');
    }
    }
    function index(){
        return view('backend.index');
    }



public function login_process(Request $request)
{
    $input = $request->email;
    $type = strpos($input, '@') !== false ? 2 : 1; // 2 = email, 1 = mobile
    $actionType = $request->type_action ?? 'login';

    // Check user exists
    $admin = DB::table('superadmins')->where('email', $input)->orWhere('mobile', $input)->first();

    if (!$admin) {
        return $request->ajax()
            ? response()->json(['status' => 'error', 'message' => 'User not found.'])
            : redirect()->back()->with('error', 'User not found.');
    }

    if ($admin->verift_status == 0) {
        return $request->ajax()
            ? response()->json(['status' => 'error', 'message' => 'Your account has been blocked.'])
            : redirect()->back()->with('error', 'Your account has been blocked.');
    }

  
    if ($actionType === 'forgot') {
        verifyUserOtp($admin, $type,$actionType); 

        return $request->ajax()
            ? response()->json([
                'status' => 'success',
                'message' => 'OTP has been sent to your ' . ($type == 2 ? 'Email' : 'Mobile') . '.'
            ])
            : redirect()->back()->with('success', 'OTP has been sent.');
    }

    // Normal login
    if (!Hash::check($request->password, $admin->password)) {
        return redirect()->back()->with('error', 'Invalid credentials. Please check your password.');
    }

    $verify = Websitesetting::where('id', '1')->first();
    $verifytype = $verify->login_with_opt_apply;

    if ($verifytype == '1') {
        return verifyUserOtp($admin, $type,$actionType);
    } else {
        Session::put('userlogin', true);
        Session::put('SUPERADMIN_ID', $admin->id);
        return redirect()->route('backend.index')->with('success', 'Login Successfully');
    }
}






public function otpverify(Request $request)
{
    $value = session('superadmin_value');
    $type = session('superadmin_type');


    if (!$value || !$type) {
        return redirect(asset('backend/login'))->with('error', 'Session expired. Please try again.');
    }

    $key = $type == 2 ? 'email' : 'mobile';

   
    $user = DB::table('tbl_admin_otpverifies')->where($key, $value)->first();

    if (!empty($user)) {
        $data['otp'] = $user->otp;
        return view('backend.login.otpverify', $data);
    } else {
        return redirect(asset('backend/login'))->with('error', 'Invalid or expired OTP.');
    }
}


public function forgetpasswordcheck(Request $request)
{
    $value = session('superadmin_value');
    $type = session('superadmin_type');
    $otp   = $request->otp;

    $result = forgotpasswordotp($value, $type, $otp);

    return response()->json($result);
}



function otpverification(Request $request)
{
    $value = session('superadmin_value');  
    $type = session('superadmin_type');    
    $otpInput = $request->otphide;

    $key = $type == 2 ? 'email' : 'mobile';

    $adminOtp = DB::table('tbl_admin_otpverifies')->where('otp', $otpInput)->where($key, $value)->first();

    if (!$adminOtp) {
        return redirect(asset('backend/login'))->with('error', 'Invalid or expired OTP');
    }

    // Step 2: Get superadmin record from superadmins table
    $superadmin = DB::table('superadmins')->where($key, $value)->first();

    if (!$superadmin) {
        return redirect(asset('backend/login'))->with('error', 'Admin not found');
    }

 
    Session::put('userlogin', true);
    Session::put('SUPERADMIN_ID', $superadmin->id); 

  Session::forget('superadmin_value');
    Session::forget('superadmin_type');
    return redirect()->route('backend.index')->with('success', 'Login Successfully');
}




function logout(){
    session()->flush();
     return redirect()->route('backend.login')->with('success', 'Logout Successfully'); 
}


public function forgotchangepassword(Request $request)
{
    $value = session('superadmin_value');  
    $type = session('superadmin_type');    

    if (!$value || !$type) {
        return redirect(asset('backend/login'))->with('error', 'Session expired. Please try again.');
    }

    $key = $type == 2 ? 'email' : 'mobile';

    // Admin check
    $superadmin = DB::table('superadmins')->where($key, $value)->first();

    if (!$superadmin) {
        return redirect(asset('backend/login'))->with('error', 'Admin not found');
    }

    DB::table('superadmins')->where($key, $value)->update([
        'password' => Hash::make($request->password)
    ]);

    return redirect(asset('backend/login'))->with('success', 'Password updated successfully. Please login.');
}




function otp(){
    return view('backend.login.otp');
}


function otpmail(){
    return view('backend.login.otpmail');
}

}
