<?php

namespace App\Http\Controllers\backend\location;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
  use Illuminate\Support\Facades\DB;
  use Illuminate\Support\Facades\Crypt;
 use App\Models\Pincode;
 use App\Models\superadmin;
 use App\Models\Serviceallottedcity;
 use App\Models\Store;
 use App\Models\Websitesetting;
 use Illuminate\Support\Str;


class LocationController extends Controller
{
    //
    
    function countries(){
        $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
         $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '8', 'action_view');
     if ($hasPermission) { 
          insertLogsAPI($user_id,'2','Countries View','8','','','','','','',''); 
       return view('backend.location.countries');
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
       
    }
    
    
public function ajaxcountriesview(Request $request)
{
    $draw = $request->draw;
    $start = $request->start ?? 0;
    $length = $request->length ?? 10;

    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName = $request->columns[$columnIndex]['data'] ?? 'countries_id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';

    if ($columnName === 'id') {
        $columnName = 'countries_id';
    }

    $searchValue = $request->search['value'] ?? '';

    $query = DB::table('tbl_countries');

    if (!empty($searchValue)) {
        $query->where(function ($q) use ($searchValue) {
            $q->where('name', 'like', "%$searchValue%")
              ->orWhere('countries_id', 'like', "%$searchValue%");
              
               if (strtolower($searchValue) === 'active') {
            $q->orWhere('cstatus', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('cstatus', '0');
        }
        });
    }

    $recordsFiltered = $query->count();
    $query->orderBy($columnName, $columnSortOrder);

    if ($length != -1) {
        $query->offset($start)->limit($length);
    }

    $countries = $query->get();

    $user_id = session('SUPERADMIN_ID');
    $data = [];
    $i = $start + 1;

    foreach ($countries as $row) {
        $id = $row->countries_id;

        $action = '<ul class="action d-flex m-0" style="list-style-type: none;">';

        if (permission($user_id, '8', 'action_edit')) {
            $action .= '<li class="list-unstyled" style="margin: 0;">
                <a data-bs-toggle="modal" 
                   data-bs-target="#editModal" 
                   class="actionedit btn editbtn btn-sm" 
                   href="javascript:void(0);" 
                   onClick="countriesedit(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ');">
                    <i class="fadeIn animated anji bx bx-pencil me-0"></i>
                </a>';
        }
        $action .= '</li>';

        if ($row->selfstatus == '1' && permission($user_id, '8', 'action_delete')) {
            $action .= '<li><a class="btn deletebtn btn-sm ms-2" onclick="return check_delete();" href="' . asset('backend/countriesdelete/' . Crypt::encrypt($row->countries_id)) . '"><i class="fadeIn animated bx bx-trash anji me-0"></i></a></li>';
        }

        $action .= '</ul>';

        $status = '<div class="form-check form-switch form-check-success">
            <input onclick="round_success_noti()" name="status" ' . ($row->cstatus == 1 ? 'checked' : '') . ' data-id="' . $row->countries_id . '" class="form-check-input js-switch" type="checkbox" role="switch">
        </div>';

        $data[] = [
            "id"     => $row->countries_id,
            "name"   => $row->name,
            "status" => $status,
            "action" => $action,
        ];
    }

    $totalRecords = DB::table('tbl_countries')->count();

    return response()->json([
        "draw" => intval($draw),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $recordsFiltered,
        "data" => $data,
    ]);
}





public function countriesadd(Request $request)
{
    $user_id = session('SUPERADMIN_ID');

  
    $existingname = DB::table('tbl_countries')->where('name', $request->name)->first();
    if ($existingname) {
        $message = fleshmessage(6, 1, 'Country Name');
        return redirect()->back()->with($message['status'], $message['message']);
    }

  $adduser = DB::table('tbl_countries')->insertGetId([
    'name' => $request->name,
    'shortname' => 'N/A',
    'icons' => 'N/A',
    'currencysymbols' => 'N/A',
    'Currencyname' => 'N/A',
    'phonecode' => 0 ,
    'selfstatus' => '1'
]);

    
    $after = json_encode(['name' => $request->name]);
    $before = json_encode(['name' => $request->name]); 


    insertLogsAPI($user_id, '1', 'Country Name Add', '8', '', $adduser, '', '', $after, $before);

 
    $message = fleshmessage(2, 1, 'Country Name');
    return redirect()->back()->with($message['status'], $message['message']);
}


public function countriesupdate(Request $request)
{
    $user_id = session('SUPERADMIN_ID');

    $existingname = DB::table('tbl_countries')->where('name', $request->name)->where('countries_id', '!=', $request->id)->first();

    if ($existingname) {
        $message = fleshmessage(6, 1, 'Country Name');
        return redirect()->back()->with($message['status'], $message['message']);
    }

   
    $existingData = DB::table('tbl_countries')->where('countries_id', $request->id)->first();
     $before = json_encode($existingData);
     
    DB::table('tbl_countries')
        ->where('countries_id', $request->id)
        ->update([
            'name' => $request->name,
            'shortname' => 'N/A',
            'icons' => 'N/A',
            'currencysymbols' => 'N/A',
            'Currencyname' => 'N/A',
            'phonecode' => 0,
            'selfstatus' => '1'
        ]);

   
    $after = json_encode([
        'name' => $request->name,
      
    ]);
   
 $adduser=$request->id;
   
    insertLogsAPI($user_id, '3', 'Country Name Update', '8', '', $adduser, '', '', $after, $before);

    $message = fleshmessage(3, 1, 'Country Name');
    return redirect()->back()->with($message['status'], $message['message']);
}



public function countriesdelete(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($request->id);

    $beforeData = DB::table('tbl_countries')->where('countries_id', $id)->first();
    DB::table('tbl_countries')->where('countries_id', $id)->delete();

    $before = json_encode($beforeData);
    $after = json_encode(null); 

    $adduser = $beforeData->countries_id ?? null;

    insertLogsAPI($user_id, '4', 'Country Delete', '8', '', $adduser, '', '', $after, $before);

    $message = fleshmessage(4, 1, 'Country Name');

    return redirect()->back()->with($message['status'], $message['message']);
}


public function countriesstatus(Request $request)
{
    
    $updated = DB::table('tbl_countries')->where('countries_id', $request->id)->update(['cstatus' => $request->status]);

    if ($request->status == '0') {
        Serviceallottedcity::where('countries_id', $request->id)->update(['status' => '0']);
        Pincode::where('country', $request->id)->update(['status' => '0']);
    }

    return response()->json(['success' => $updated > 0]);
}


////////////State///////////////


function state(){
     $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
    $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '9', 'action_view');
     if ($hasPermission) { 
         $data['country'] = DB::table('tbl_countries')->get()->where('cstatus','1');
     $data['statecount'] = DB::table('tbl_states')->where('s_status','1')->count();
                insertLogsAPI($user_id,'2','State View','9','','','','','','',''); 
    return view('backend.location.state',$data);
     }
     
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
   
}




public function ajaxstatessview(Request $request)
{
    $countryId = $request->countries; 

    $draw = $request->draw ?? 1;
    $start = $request->start ?? 0;
    $length = $request->length ?? 10;

    // safely handle column order
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName = $request->columns[$columnIndex]['data'] ?? 'state_id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';

    $searchValue = $request->search['value'] ?? null;

    if ($columnName === 'id') {
        $columnName = 's.state_id';
    } elseif ($columnName === 'states') {
        $columnName = 's.name';
    } elseif ($columnName === 'countries') {
        $columnName = 'c.name';
    } elseif ($columnName === 'status') {
        $columnName = 's.s_status';
    } else {
        $columnName = 's.state_id';
    }

  
    $query = DB::table('tbl_states as s')
        ->join('tbl_countries as c', 's.country_id', '=', 'c.countries_id')
        ->where('c.cstatus', 1);

    if (!empty($countryId)) {
        $query->where('s.country_id', $countryId);
    }

    if (!empty($searchValue)) {
        $query->where(function ($q) use ($searchValue) {
            $q->where('s.name', 'like', "%$searchValue%")
              ->orWhere('s.state_id', 'like', "%$searchValue%")
              ->orWhere('c.name', 'like', "%$searchValue%");
              
               if (strtolower($searchValue) === 'active') {
            $q->orWhere('s_status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('s_status', '0');
        }
        });
    }

    $recordsFiltered = $query->count();
    $filteredCount = $recordsFiltered; 

    $query->orderBy($columnName, $columnSortOrder);
    if ($length != -1) {
        $query->offset($start)->limit($length);
    }

    
    $states = $query->select('s.*', 'c.name as country_name')->get();

    $data = [];
    $i = $start + 1;

    $user_id = session('SUPERADMIN_ID');

    foreach ($states as $row) {
        $id = $row->state_id;

        $action = '<ul class="action d-flex m-0" style="list-style-type: none;">';

        if (permission($user_id, '9', 'action_edit')) {
            $action .= '<li class="list-unstyled" style="margin: 0;">
                <a data-bs-toggle="modal" 
                   data-bs-target="#editModal" 
                   class="actionedit btn editbtn btn-sm" 
                   href="javascript:void(0);" 
                   onClick="stateedit(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ');">
                    <i class="fadeIn animated anji bx bx-pencil me-0"></i>
                </a>';
        }
        $action .= '</li>';

        if ($row->selfstatus == '1' && permission($user_id, '9', 'action_delete')) {
            $action .= '<li><a class="btn deletebtn btn-sm ms-2" onclick="return check_delete();" href="' . asset('backend/statedelete/' . Crypt::encrypt($row->state_id)) . '"><i class="fadeIn animated bx bx-trash anji me-0"></i></a></li>';
        }

        $action .= '</ul>';

        $status = '<div class="form-check form-switch form-check-success">';
        $status .= '<input onclick="round_success_noti()" name="status" ' . ($row->s_status == 1 ? 'checked' : '') . '  data-id="' . $row->state_id . '" class="form-check-input js-switch" type="checkbox" role="switch">';
        $status .= '</div>';

        $data[] = [
            "id" => $row->state_id,
            "states" => $row->name,
            "countries" => $row->country_name, 
            "status" => $status,
            "action" => $action,
        ];
    }

 
    $totalRecords = DB::table('tbl_states as s')
        ->join('tbl_countries as c', 's.country_id', '=', 'c.countries_id')
        ->where('c.cstatus', 1)
        ->count();

    return response()->json([
        "draw" => intval($draw),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $recordsFiltered,
        "data" => $data,
        "stateCount" => $filteredCount,
    ]);
}



public function statestatus(Request $request)
{
    $updated = DB::table('tbl_states')->where('state_id', $request->id)->update(['s_status' => $request->status]);

    if ($request->status == '0') {
        Serviceallottedcity::where('state_id', $request->id)->update(['status' => '0']);
          Pincode::where('state', $request->id)->update(['status' => '0']);
    }

    return response()->json(['success' => $updated > 0]);
}


public function stateadd(Request $request)
{
    $user_id = session('SUPERADMIN_ID');

    $existingname = DB::table('tbl_states')->where('country_id', $request->country_id) ->where('name', $request->name) ->first();

    if ($existingname) {
        $message = fleshmessage(6, 1, 'State name  in this country.');
        return redirect()->back()->with($message['status'], $message['message']);
    }

    $insertId = DB::table('tbl_states')->insertGetId([
        'country_id' => $request->country_id,
        'name'       => $request->name,
        'selfstatus' => '1'
    ]);

   
    $adduser = DB::table('tbl_states')->where('state_id ', $insertId)->first();

    $after  = json_encode($adduser);
    $before = json_encode($adduser);

    insertLogsAPI( $user_id, '1','State Name Add','9','', $insertId,  '', '',$after,$before);

    $message = fleshmessage(2, 1, 'State Name');
    return redirect()->back()->with($message['status'], $message['message']);
}






public function stateupdate(Request $request)
{
    $user_id = session('SUPERADMIN_ID');

    $existingname = DB::table('tbl_states')->where('name', $request->name)->where('country_id', $request->country_id)->where('state_id', '!=', $request->id)->first();

    if ($existingname) {
       $message = fleshmessage(6, 1, 'State name  in this country.');
        return redirect()->back()->with($message['status'], $message['message']);
    }

   
    $existingData = DB::table('tbl_states')->where('state_id', $request->id)->first();
     $before = json_encode($existingData);
     
    DB::table('tbl_states')
        ->where('state_id', $request->id)
        ->update([
            'name' => $request->name,
           'country_id' => $request->country_id,
            'selfstatus' => '1'
        ]);

   
    $after = json_encode([
        'name' => $request->name,
         'state_id'   => $request->id,
        'country_id' => $request->country_id,
      'selfstatus' => '1'
    ]);
   
 $adduser=$request->id;
   
    insertLogsAPI($user_id, '3', 'State Name Update', '9', '', $adduser, '', '', $after, $before);

    $message = fleshmessage(3, 1, 'State Name');
    return redirect()->back()->with($message['status'], $message['message']);
}



public function statedelete(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($request->id);

    $beforeData = DB::table('tbl_states')->where('state_id', $id)->first();
    DB::table('tbl_states')->where('state_id', $id)->delete();

    $before = json_encode($beforeData);
    $after = json_encode(null); 

    $adduser = $beforeData->state_id ?? null;

    insertLogsAPI($user_id, '4', 'State Delete', '9', '', $adduser, '', '', $after, $before);

    $message = fleshmessage(4, 1, 'State Name');

    return redirect()->back()->with($message['status'], $message['message']);
}

////////City/////////



  

 function getCountryByState(Request $request)
{

    if ($request->has('country')) {
        $states = DB::table('tbl_states')->where('country_id', $request->country)->where('s_status', '1')->get(['state_id', 'name']);
        return response()->json(['states' => $states]);
    }


    if ($request->has('state_id')) {
        $state = DB::table('tbl_states')->where('state_id', $request->state_id)->where('s_status', '1')->first();
        if ($state) {
            return response()->json(['country_id' => $state->country_id]);
        }
        return response()->json(['country_id' => null]);
    }

    return response()->json(['message' => 'Invalid request'], 400);
}




function cities(){
     $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '10', 'action_view');
     if ($hasPermission) { 
         $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
     $data['state'] = DB::table('tbl_states')->get()->where('s_status','1');
     $data['citycount'] = DB::table('tbl_cities')->where('city_status','1')->count();
      insertLogsAPI($user_id,'2','Cities View','10','','','','','','',''); 
    return view('backend.location.cities',$data);
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
   
}


public function ajaxcitiesview(Request $request)
{
    $countryId = $request->countries;
    $stateId   = $request->state;

    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;
    $length = $request->length ?? 10;

    // Safe handling for order column
    $columnIndex     = $request->order[0]['column'] ?? 0;
    $columnName      = $request->columns[$columnIndex]['data'] ?? 'tbl_cities.city_id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';

    $searchValue = $request->search['value'] ?? null;

    if ($columnName === 'id') {
        $columnName = 'tbl_cities.city_id';
    }

  
    $query = DB::table('tbl_cities')
        ->join('tbl_states', 'tbl_cities.stateid', '=', 'tbl_states.state_id')
        ->join('tbl_countries', 'tbl_states.country_id', '=', 'tbl_countries.countries_id')
        ->where('tbl_states.s_status', '1')
        ->where('tbl_countries.cstatus', '1');

    // Filter by country
    if (!empty($countryId)) {
        $query->where('tbl_states.country_id', $countryId);
    }

    // Filter by state
    if (!empty($stateId)) {
        $query->where('tbl_cities.stateid', $stateId);
    }

    // Search filter
    if (!empty($searchValue)) {
        $query->where(function ($q) use ($searchValue) {
            $q->where('tbl_cities.name', 'like', "%$searchValue%")
              ->orWhere('tbl_cities.city_id', 'like', "%$searchValue%")
              ->orWhere('tbl_states.name', 'like', "%$searchValue%")
              ->orWhere('tbl_countries.name', 'like', "%$searchValue%");
              
               if (strtolower($searchValue) === 'active') {
            $q->orWhere('city_status', '1');
        } elseif (strtolower($searchValue) === 'inactive') {
            $q->orWhere('city_status', '0');
        }
        });
    }

   
    $recordsFiltered = $query->count();
    $filteredCount   = $recordsFiltered;

    // Sorting + pagination
    $query->orderBy($columnName, $columnSortOrder);
    if ($length != -1) {
        $query->limit($length)->offset($start);
    }

    // Select
    $cities = $query->select(
        'tbl_cities.*',
        'tbl_states.name as state_name',
        'tbl_countries.name as country_name'
    )->get();

    $data    = [];
    $i       = $start + 1;
    $user_id = session('SUPERADMIN_ID');

    foreach ($cities as $row) {
        $id = $row->city_id;

        // Action buttons
        $action = '<ul class="action d-flex m-0" style="list-style-type: none;">';

        if (permission($user_id, '10', 'action_edit')) {
            $action .= '<li class="list-unstyled" style="margin: 0;">
                <a data-bs-toggle="modal" 
                   data-bs-target="#editModal" 
                   class="actionedit btn editbtn btn-sm" 
                   href="javascript:void(0);" 
                   onClick="cityedit(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ');">
                    <i class="fadeIn animated anji bx bx-pencil me-0"></i>
                </a>';
        }
        $action .= '</li>';

        if ($row->selfstatus == '1' && permission($user_id, '10', 'action_delete')) {
            $action .= '<li><a class="btn deletebtn btn-sm ms-2" onclick="return check_delete();" href="' . asset('backend/citydelete/' . Crypt::encrypt($row->city_id)) . '"><i class="fadeIn animated bx bx-trash anji me-0"></i></a></li>';
        }

        $action .= '</ul>';

        // Status switch
        $status = '<div class="form-check form-switch form-check-success">';
        $status .= '<input onclick="round_success_noti()" name="status" ' . ($row->city_status == 1 ? 'checked' : '') . ' data-id="' . $row->city_id . '" class="form-check-input js-switch" type="checkbox" role="switch">';
        $status .= '</div>';

        $data[] = [
            "id"        => $row->city_id,
            "cities"    => $row->name,
            "states"    => $row->state_name,
            "countries" => $row->country_name,
            "status"    => $status,
            "action"    => $action,
        ];
    }

   
    $totalRecords = DB::table('tbl_cities')
        ->join('tbl_states', 'tbl_cities.stateid', '=', 'tbl_states.state_id')
        ->join('tbl_countries', 'tbl_states.country_id', '=', 'tbl_countries.countries_id')
        ->where('tbl_states.s_status', '1')
        ->where('tbl_countries.cstatus', '1')
        ->count();

    return response()->json([
        "draw"            => intval($draw),
        "recordsTotal"    => $totalRecords,
        "recordsFiltered" => $recordsFiltered,
        "data"            => $data,
        "cityCount"       => $filteredCount,
    ]);
}







public function citiesstatus(Request $request)
{
    $updated = DB::table('tbl_cities')->where('city_id', $request->id)->update(['city_status' => $request->status]);

    if ($request->status == '0') {
        Serviceallottedcity::where('city_id', $request->id)->update(['status' => '0']);
          Pincode::where('city', $request->id)->update(['status' => '0']);
    }
    return response()->json(['success' => $updated > 0]);
}



public function cityadd(Request $request)
{
    $user_id = session('SUPERADMIN_ID');

    $existingname = DB::table('tbl_cities')->where('stateid', $request->state_id) ->where('name', $request->name) ->first();

    if ($existingname) {
        $message = fleshmessage(6, 1, 'City name  in this country.');
        return redirect()->back()->with($message['status'], $message['message']);
    }

    $insertId = DB::table('tbl_cities')->insertGetId([
        'stateid' => $request->state_id,
        'name'       => $request->name,
        'selfstatus' => '1'
    ]);

   
    $adduser = DB::table('tbl_cities')->where('city_id', $insertId)->first();

    $after  = json_encode($adduser);
    $before = json_encode($adduser);

    insertLogsAPI( $user_id, '1','City Name Add','10','', $insertId,  '', '',$after,$before);

    $message = fleshmessage(2, 1, 'City Name');
    return redirect()->back()->with($message['status'], $message['message']);
}






public function cityupdate(Request $request)
{
    $user_id = session('SUPERADMIN_ID');

    $existingname = DB::table('tbl_cities')->where('name', $request->name)->where('stateid', $request->state_id)->where('city_id', '!=', $request->id)->first();

    if ($existingname) {
       $message = fleshmessage(6, 1, 'City name  in this country.');
        return redirect()->back()->with($message['status'], $message['message']);
    }

   
    $existingData = DB::table('tbl_cities')->where('city_id', $request->id)->first();
     $before = json_encode($existingData);
     
    DB::table('tbl_cities')
        ->where('city_id', $request->id)
        ->update([
            'name' => $request->name,
          'stateid' => $request->state_id,
            'selfstatus' => '1'
        ]);

   
    $after = json_encode([
        'name' => $request->name,
         'city_id'   => $request->id,
        'stateid' => $request->state_id,
      'selfstatus' => '1'
    ]);
   
 $adduser=$request->id;
   
    insertLogsAPI($user_id, '3', 'City Name Update', '10', '', $adduser, '', '', $after, $before);

    $message = fleshmessage(3, 1, 'City Name');
    return redirect()->back()->with($message['status'], $message['message']);
}



public function citydelete(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($request->id);

    $beforeData = DB::table('tbl_cities')->where('city_id', $id)->first();
    DB::table('tbl_cities')->where('city_id', $id)->delete();

    $before = json_encode($beforeData);
    $after = json_encode(null); 

    $adduser = $beforeData->state_id ?? null;

    insertLogsAPI($user_id, '4', 'City Delete', '10', '', $adduser, '', '', $after, $before);

    $message = fleshmessage(4, 1, 'City Name');

    return redirect()->back()->with($message['status'], $message['message']);
}





///   Pincode  ///

    function pincode(){
        $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
         $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '21', 'action_view');
     if ($hasPermission) { 
         $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
          insertLogsAPI($user_id,'2','Pincode View','21','','','','','','',''); 
       return view('backend.location.pincode',$data);
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
       
    }

  function pincodecreate(Request $request){
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '21', 'action_add');

    if ($hasPermission) {
        $pincodes = explode(',', $request->pincode);

        $alreadyExists = [];
        $inserted = [];

        foreach ($pincodes as $pincodeValue) {
            $pincodeValue = trim($pincodeValue);
            if (empty($pincodeValue)) continue;

            // check if already exists
            $existpincode = Pincode::where('pincode', $pincodeValue)->first();
            if ($existpincode) {
                $alreadyExists[] = $pincodeValue;
                continue;
            }

            // create new pincode
            $create = new Pincode();
            $create->country = $request->country;
            $create->state = $request->state;
            $create->city = $request->city;
            $create->pincode = $pincodeValue;
            $create->ordering_by = $request->ordering_by;
            $create->user_id = $user_id;
            $create->created_by = $user_id;
            $create->panel_id = '1';
            $create->tokan = reandum_code('50');
            $create->ip = CurrentTimestamp()['ip'];
            $create->strtotime = CurrentTimestamp()['strtotime'];
            $create->created_at = CurrentTimestamp()['datetime'];
            $create->updated_at = CurrentTimestamp()['datetime'];
            $create->save();

            $after = json_encode($create);
            $before = json_encode($create);
            $adduser = $create->id;

            insertLogsAPI($user_id, '1', 'Pincode Add', '21', '', $adduser, '', '', $after, $before, '');

            $inserted[] = $pincodeValue;
        }

        if (!empty($inserted) && !empty($alreadyExists)) {
            $message = [
                'status'  => 'success',
                'message' => 'New pincodes inserted: '.implode(', ', $inserted).'. Already exists: '.implode(', ', $alreadyExists)
            ];
        } elseif (!empty($inserted)) {
            $message = fleshmessage(2,1,'Pincode'); 
        } else {
            $message = fleshmessage(6,1,'Pincode');
        }

        return redirect()->back()->with($message['status'], $message['message']);
    }

    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}






function pincodeajax(Request $request){
    
     $filterData = [
        'filtercountries' => $request->filtercountries,
        'filterstate'   => $request->filterstate,
        'filtercity'   => $request->filtercity,
    ];
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = Pincode::pincodeajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$filterData);
        $housesurveycount = Pincode::pincodeajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$filterData);
    }else{
        $housesurveydata = Pincode::pincodeajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$filterData);
        $housesurveycount = Pincode::pincodeajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$filterData);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'21','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/pincodeedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'21','action_delete')){
            $action .= '<a href="' . asset('backend/pincodedelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
    
       

        $action .= '</ul>';

      $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';

        
         $country =DB::table('tbl_countries')->where('countries_id', $row->country)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Countryname = '<span>'.$country.'</span>'; 
     
 $state =DB::table('tbl_states')->where('state_id', $row->state)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $Statename = '<span>'.$state.'</span>';
     
     $city =DB::table('tbl_cities')->where('city_id', $row->city)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $Cityname = '<span>'.$city.'</span>'; 
     
        $data[] = array(
            "id" => $row->id, 
            // "ordering_by" => $row->ordering_by,
            "country" => $Countryname,
          "state" =>$Statename ,
          "city" => $Cityname,
          "pincode" => $row->pincode,

            "status" => $status,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '21', 'action_globle_view');
    $canAccessCity = permission($user_id, '21', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('pincodes')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('pincodes')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('pincodes')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('pincodes')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}

 function pincodestatus(Request $request) {
    $id = $request->id;
    $status = Pincode::find($id);

    if (!$status) {
        return response()->json(['success' => false, 'message' => ' Pincode  not found'], 404);
    }
    $status->status = $request->status;
    $status->save();

    return response()->json(['success' => true]);
}


function pincodedelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '21', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
   
        $delete = Pincode::findOrFail($id);
        $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Pincode Delete','21','',$adduser,'','',$after,$before,''); 

     $message = fleshmessage(4,1,'Pincode');
          return redirect()->back()->with($message['status'],$message['message']);
   
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
     function pincodeedit(Request $request){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '21', 'action_edit');
     if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
          $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        $data['pincodedata']=Pincode::where('id',$id)->first();
        return view('backend.location.pincodeedit',$data);
    }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
 }
 
 
 
public function pincodeupdate(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($request->id);

    $hasPermission = permission($user_id, '21', 'action_edit');

    if ($hasPermission) {
        $pincodeValue = trim($request->pincode);

        // check duplicate (exclude current id)
        $existpincode = Pincode::where('pincode', $pincodeValue)
            ->where('id', '!=', $id)
            ->first();

        if ($existpincode) {
            $message = fleshmessage(6, 1, 'Pincode');
            return redirect()->back()->with($message['status'], $message['message']);
        }

        $update = Pincode::where('id', $id)->first();
        $before = json_encode($update);

        $update->country = $request->country;
        $update->state = $request->state;
        $update->city = $request->city;
        $update->pincode = $pincodeValue;
        $update->ordering_by = $request->ordering_by;
        $update->user_id = $user_id;
        $update->created_by = $user_id;
        $update->panel_id = '1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];
        $update->save();

        $after = json_encode($update);
        $adduser = $update->id;

        insertLogsAPI($user_id, '3', 'Pincode Update', '21', '', $adduser, '', '', $after, $before, '');

        $message = fleshmessage(3, 1, 'Pincode');
        return redirect(asset('backend/pincode'))->with($message['status'], $message['message']);
    }

    // permission denied case
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}










//Store
    
    function store(){
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '23', 'action_view');
     if ($hasPermission) { 
        $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
           insertLogsAPI($user_id,'2','Store View','23','','','','','','',''); 
           $data['validateslug'] = array('editid'=> '', 'slugtype' => '1', 'fid'=>'23');
        return view('backend.location.store' , $data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }   
    
    
    
 function storeedit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '23', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
         $data['store']=Store::where('id',$id)->first();
         $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id), 'slugtype' => '2', 'fid'=> '23');
        return view('backend.location.storeedit',$data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }    
    
    
    
    
    
     function storecreate(Request $request){
//   return $request->all();
    $user_id=session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '23', 'action_add');
    if ($hasPermission) { 
    $existingMobile = Store::where('email', $request->email)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Email');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $existingMobile = Store::where('number', $request->number)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Number');
        return redirect()->back()->with($message['status'],$message['message']);
    }

        $create=new Store;
        $create->name = $request->name;
        $create->number = $request->number;
        $slug = strtolower(trim($request->slug));
        $city = strtolower(trim($request->city));
        $pincode = trim($request->pincode);

        $slug = Str::slug($slug);
        $city = Str::slug($city);

        $create->slug = $slug . '-' . $city . '-' . $pincode;
        $create->city = $request->city;
        $create->pincode = $request->pincode;
        $create->whatsapp = $request->whatsapp;
        $create->email = $request->email;
        $create->user_id = $user_id;
        $create->latitude = $request->latitude;
        $create->longitude=$request->longitude;
        $create->countries = $request->countries;
        $create->state = $request->state;
      
        $create->map_url = $request->map_url;
        $create->address = $request->address;
        $create->start_time = $request->start_time;
        $create->end_time = $request->end_time;
        $create->close = $request->close;
        
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->tokan=reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
        $create->save();
        $after = json_encode($create);
        $before = json_encode($create);
        $adduser=$create->id;
    insertLogsAPI($user_id,'1','Store Add','23','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Store');
    return redirect()->back()->with($message['status'],$message['message']);
    }
         $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }   
    
    
    function storeupdate(Request $request){
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '23', 'action_edit');
    if ($hasPermission) { 
    $existingMobile = Store::where('email', $request->email)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Email');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $existingMobile = Store::where('number', $request->number)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Number');
        return redirect()->back()->with($message['status'],$message['message']);
    }
   
   
    $update = Store::findOrFail($id);
    $before = json_encode($update);
        $update->name = $request->name;
        $update->number = $request->number;
        
         $cityname = DB::table('tbl_cities')->where('city_status','1')->where('city_id',$request->city)->first();
         $slug = strtolower(trim($request->slug));
        $city = strtolower(trim($request->city));
        $pincode = trim($request->pincode);

        $slug = Str::slug($slug);
        $city = Str::slug($city);

        $update->slug = $slug . '-' . $cityname->name . '-' . $pincode;
        $update->whatsapp = $request->whatsapp;
        $update->email = $request->email;
        $update->user_id = $user_id;
        $update->latitude = $request->latitude;
        $update->longitude=$request->longitude;
        $update->countries = $request->countries;
        $update->state = $request->state;
        $update->city = $request->city;
        $update->pincode = $request->pincode;
        $update->map_url = $request->map_url;
        $update->address = $request->address;
        $update->start_time = $request->start_time;
        $update->end_time = $request->end_time;
        $update->close = $request->close;

        $update->created_by=$user_id;
        $update->panel_id='1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
      $after = json_encode($update);
       $adduser=$update->id;
    insertLogsAPI($user_id,'3','Store Update','23','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(3,1,'Store');
    return redirect(url('backend/store'))->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }  

   
   
   
   
function storeajax(Request $request){


   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $storedata = Store::storeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $storecount = Store::storeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $storedata = Store::storeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $storecount = Store::storeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($storedata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
   if(permission($user_id,'23','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/storeedit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';


    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'23','action_delete')){
    $action .= '<a href="' . asset('backend/storedelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';


    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';

   
     $data[] = array(
    "id" => $row->id, 
    "name" => $row->name,
    "number" => $row->number,
    "email" => $row->email,
    "time_range" => $row->start_time . ' - ' . $row->end_time, 

    "status" => $status,
    "action" => $action
);

    
    }
    
 $canViewGlobal = permission($user_id, '23', 'action_globle_view');
$canAccessCity = permission($user_id, '23', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;





if ($user_id == '1') {
    $query = DB::table('stores')->orderBy('id', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('stores')->orderBy('id', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('stores')->where('user_id', $user_id)->orderBy('id', 'ASC');

} else {
    $query = DB::table('stores')->where('user_id', $user_id)->orderBy('id', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $storecount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
  
  
  
  
public function storestatus(Request $request) {
    $id = $request->id;
    $statusstatus = Store::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'product not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     




public function storedelete(Request $request, $id)
{
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '23', 'action_delete');
        if ($hasPermission) { 
    $delete = Store::findOrFail($id);
   $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
        
         insertLogsAPI($user_id,'4','Store Delete','23','',$adduser,'','',$after,$before,''); 
      $message = fleshmessage(4,1,'Store');
          return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}  

}
