<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Newsletter;
use App\Models\User;
use App\Models\superadmin;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class NewsletterController extends Controller
{
    //
    
     function newsletter(){
          $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '31', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Newsletter View','31','','','','','','','');
         return view('backend.features.newsletter');
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }
    
    
    
   function newsletterajax(Request $request){
        $filterData = [
        'status'   => $request->status,
    ];

    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = Newsletter::newsletterajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$filterData);
        $housesurveycount = Newsletter::newsletterajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$filterData);
    }else{
        $housesurveydata = Newsletter::newsletterajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start,$filterData);
        $housesurveycount = Newsletter::newsletterajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start,$filterData);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
         $checkbox = '<input type="checkbox" class="row-checkbox" value="' . $row->id . '">';
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        // $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        // if(permission($user_id,'31','action_edit')){
        //     $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/faqedit/' . Crypt::encrypt($row->id)) . '">
        //             <i class="fadeIn animated bx bx-pencil anji me-0"></i>
        //         </a>';
        // }
        // $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'29','action_delete')){
            $action .= '<a href="' . asset('backend/newsletterdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
    
        $action .= '</ul>';

        $newsletterstatus = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="newsletter_status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->newsletter_status == 1 ? 'checked' : '') . '>
            <label class="flip-labelnewsletter" for="flip' . $row->id . '"></label>
        </div>';
 $username = User::where('id',$row->user_id)->first();
         if(empty($username)){
        $username = "N/A";
    }else{
        $username = $username->name;
    } 
     $Username = '<span>'.$username.'</span>'; 
        $data[] = array(
               "id"        => $checkbox . " " . $row->id, 
    	    "username"=>$Username,
            "email"=>$row->email,
            "newsletterstatus" => $newsletterstatus,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '31', 'action_globle_view');
    $canAccessCity = permission($user_id, '31', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('newsletters')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('newsletters')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('newsletters')->where('user_id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('newsletters')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}

  function newsletterdelete($id)
    {
    $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '31', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
        $delete = Newsletter::find($id);
         $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Newsletter Delete','31','',$adduser,'','',$after,$before,''); 
     $message = fleshmessage(4,1,'Newsletter');
          return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }


   function newsletterstatus(Request $request) {
    $id = $request->id;
    $status = Newsletter::find($id);
    if (!$status) {
        return response()->json(['success' => false, 'message' => 'Newsletter  not found'], 404);
    }

    $status->newsletter_status = $request->newsletter_status;
    $status->save();
    return response()->json(['success' => true]);
    }  
    
    
     function deletemultiplecitiesnewsletter(Request $request)
{
    $ids = $request->ids;

    if (!empty($ids)) {
        $ids = array_filter($ids, function ($id) {
            return is_numeric($id);
        });

        if (!empty($ids)) {
            DB::table('newsletters')
                ->whereIn('id', $ids)
                ->delete();

            return response()->json([
                'status' => true,
                'message' => 'Selected records deleted successfully!'
            ]);
        }
    }

    return response()->json([
        'status' => false,
        'message' => 'No records selected!'
    ]);
}
    
    
  
}
