<?php

use App\Models\Additionalsetting;

if (!function_exists('verifyRecaptcha')) {
    function verifyRecaptcha($response)
    {
        if (empty($response)) {
            return ['success' => false, 'message' => 'Required Captcha'];
        }

        $additionalsettings = Additionalsetting::find(1);
        if (!$additionalsettings || empty($additionalsettings->captchasecretkey)) {
            return ['success' => false, 'message' => 'Captcha configuration missing'];
        }

        $secret = $additionalsettings->captchasecretkey;
        $verifyResponse = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$secret}&response={$response}");
        $responseData = json_decode($verifyResponse);

        if (!empty($responseData) && $responseData->success) {
            return ['success' => true];
        } else {
            return ['success' => false, 'message' => 'Invalid Captcha'];
        }
    }
}
