<?php

use App\Models\tbl_otp_a_log;
use App\Models\tbl_message_api;
use App\Models\tbl_users;
use App\Models\tbl_website_setting;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use App\Mail\Backend\AdminEmailVerify;







if (!function_exists('userverifyUserOtp')) {
    function userverifyUserOtp($user, $type)
    {
        $settings = DB::table('websitesettings')->where('id', '1')->first();
        $otpDelay = $settings->adminloginattempt_time ?? 1;

        $key = $type == 2 ? 'email' : 'mobile';
        $value = $user;
        $otp = '123456';
        // $otp = rand(100000, 999999);
        $timestamp = strtotime(minusdatetime($otpDelay));

        $exists = DB::table('tbl_user_otpverifies')->where($key, $value)->first();
        $countquery = DB::table('tbl_user_otpverifies')->where($key, $value)->where('strtotime', '>=', $timestamp)->first();
        $count = $countquery ? $countquery->attempt : 0;

        if ($settings->user_multipal_attempt_status == '1') {
            
            if ($settings->admin_otp_attempt_count < $count) {
                $mv = fleshmessage(1, 1, 30);
                return response()->json([
                    'results' => 'error',
                    'message' => $mv['message']
                ]);
            } else {
                $attempt = ($count <= 0) ? 1 : $count + 1;
            }
        } else {
            $attempt = 1;
        }

        $otpData = [
            $key => $value,
            'otp' => $otp,
            'type' => $type,
            'attempt' => $attempt,
            'iploging_attemptunit' => $attempt,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'strtotime' => CurrentTimestamp()['strtotime'],
            'updated_at' => now(),
        ];

        if ($exists) {
            DB::table('tbl_user_otpverifies')->where($key, $value)->update($otpData);
        } else {
            $otpData['created_at'] = now();
            DB::table('tbl_user_otpverifies')->insert($otpData);
        }

        if ($type == 2) {
            // email
            $content = emailcontent(6, '2', '', $otp);
            $userdata = [
                'subject' => $content['subject'],
                'message' => $content['message'],
            ];
            // mail send
            Mail::to($value)->send(new AdminEmailverify($userdata));
        } elseif ($type == 1) {
            // mobile
            userverifyotpsend_messageApi('1', $value, 1, $otp);
        }

        return response()->json([
            'results' => 'success',
            'message' => 'OTP has been sent to your ' . ($type == 1 ? 'Mobile' : 'Email') . '.'
        ]);
    }
}

