<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Service;
use App\Models\Subservice;
use App\Models\Serviceallottedcity;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\Cookie;

if (!function_exists('homeservicesection')) {
    function homeservicesection($section_type) {

        $defaultCityId = getDefaultCityId();

        $cookieData = Cookie::get('current_location');
        $cityid = $defaultCityId;

        if (!empty($cookieData)) {
            $decoded = is_array($cookieData) ? $cookieData : json_decode($cookieData, true);

            if (!empty($decoded['city_id'])) {
                $cityid = $decoded['city_id'];
            } elseif (!empty($decoded['address']['city_id'])) {
                $cityid = $decoded['address']['city_id'];
            }
        }

        $setting = Websitesetting::where('id', 1)->first();

        if ($setting && !empty($setting->services)) {
            $dbServices = json_decode($setting->services, true);

            $index = $section_type - 1;
            $value = $dbServices[$index] ?? 0;

            if ($value && $value != 0) {
                $service = Service::join('serviceallottedcities as sac', 'sac.serviceid', '=', 'services.id')
                    ->where('services.id', $value)
                    ->where('services.status', '1')
                    ->where('sac.city_id', $cityid)
                    ->where('sac.status', '1')
                    ->where('sac.service_type', '1')
                    ->select('services.id', 'services.title')
                    ->first();

                if ($service) {
                    return [
                        'status'   => true,
                        'service'  => $service,
                        'city_id'  => $cityid, 
                        'source'   => 'cookie_or_default'
                    ];
                }
            }
        }

        return [
            'status'  => false,
            'city_id' => $cityid, 
            'source'  => 'cookie_or_default'
        ];
    }
}

if (!function_exists('homesubservicesection')) {
    function homesubservicesection($serviceID) {

        $defaultCityId = getDefaultCityId();

        $cookieData = Cookie::get('current_location');
        $cityid = $defaultCityId;

        if (!empty($cookieData)) {
            $decoded = is_array($cookieData) ? $cookieData : json_decode($cookieData, true);

            if (!empty($decoded['city_id'])) {
                $cityid = $decoded['city_id'];
            } elseif (!empty($decoded['address']['city_id'])) {
                $cityid = $decoded['address']['city_id'];
            }
        }

        $subservices = Serviceallottedcity::join('subservices', 'subservices.id', '=', 'serviceallottedcities.serviceid')
            ->where('subservices.service_id', $serviceID)
            ->where('subservices.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '2')
            ->select('subservices.*')
            ->get();

        if ($subservices->isEmpty()) {
            return [
                'status'       => false,
                'subservices'  => [],
                'city_id'      => $cityid, 
                'source'       => 'cookie_or_default'
            ];
        } else {
            return [
                'status'       => true,
                'subservices'  => $subservices->toArray(),
                'city_id'      => $cityid, 
                'source'       => 'cookie_or_default'
            ];
        }
    }
}





// if (!function_exists('homeservicesection')) {
//     function homeservicesection($section_type) {
//         $cityid = session('current_city_ids');
//         // $cityid = '3378'; 
        
//         $setting = Websitesetting::where('id', 1)->first();

//         if ($setting && !empty($setting->services)) {
//             $dbServices = json_decode($setting->services, true);

//             $index = $section_type - 1;
//             $value = $dbServices[$index] ?? 0;

//             if ($value && $value != 0) {
//                 $service = Service::join('serviceallottedcities as sac', 'sac.serviceid', '=', 'services.id')
//                     ->where('services.id', $value)
//                     ->where('services.status', '1')
//                     ->where('sac.city_id', $cityid)
//                     ->where('sac.status', '1')
//                     ->where('sac.service_type', '1')
//                     ->select('services.id', 'services.title')
//                     ->first();

//                 if ($service) {
//                     return [
//                         'status' => true,
//                         'service' => $service
//                     ]; 
//                 }
//             }
//         }

//         return [
//             'status' => false,
            
//         ]; 
//     }
// }

// if (!function_exists('homesubservicesection')) {
//     function homesubservicesection($serviceID) {

//          $cityid = session('current_city_ids');
 
//       $subservices = Serviceallottedcity::join('subservices', 'subservices.id', '=', 'serviceallottedcities.serviceid')
//     ->where('subservices.service_id', $serviceID)
//     ->where('subservices.status', '1')
//     ->where('serviceallottedcities.city_id', $cityid)
//     ->where('serviceallottedcities.status', '1')
//     ->where('serviceallottedcities.service_type', '2')
   
//     ->get();
    
//         if ($subservices->isEmpty()) {
//             return [
//                 'status' => false,
//                 'subservices' => []
//             ];
//         } else {
//             return [
//                 'status' => true,
//                 'subservices' => $subservices->toArray() 
//             ];
//         }
//     }
// }