<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Session;
use App\Models\Additionalsetting;

if (!function_exists('getDefaultCityId')) {
    function getDefaultCityId()
    {
        return '3378'; 
    }
}

if (!function_exists('openstreetmaplocation')) {
    function openstreetmaplocation($latitude, $longitude)
    {

        $latitude  = $latitude ;
        $longitude = $longitude;

        $response = Http::withHeaders([
            'User-Agent' => 'LaravelApp/1.0'
        ])->get("https://nominatim.openstreetmap.org/reverse", [
            'lat' => $latitude,
            'lon' => $longitude,
            'format' => 'json',
            'addressdetails' => 1,
        ]);

        $locationData = $response->json();
        
 
        
        $addr = $locationData['address'] ?? [];
        $cityName = $addr['city'] ?? $addr['town'] ?? $addr['village'] ?? null;
        $city = DB::table('tbl_cities')->where('name', $cityName)->first();
        $cityId = $city->city_id??'No city id' ;
        
        $displayName = implode(', ', array_filter([
            $addr['road'] ?? '',
            $addr['residential'] ?? '',
            $addr['city'] ?? $addr['town'] ?? $addr['village'] ?? '',
            $addr['state'] ?? '',
            $addr['country'] ?? ''
        ]));

        $cookieData = [
            'lat'          => $latitude,
            'lng'          => $longitude,
            'city_name'    => $cityName,
            'address'      => $addr,
            'city_id'      => $cityId,
            'display_name' => $displayName
        ];

        Cookie::queue('current_location', json_encode($cookieData), 60 * 24 * 7);

        return [
            'status'       => 'success',
            'source'       => 'osm',
            'city_id'      => $cityId,
            'data'         => $cookieData,
            'display_name' => $displayName,
            'address'      => $addr
        ];
    }
}


if (!function_exists('googleapiloation')) {
    
    function googleapiloation($lat, $lng){
        
        $additionalsettings = Additionalsetting::where('id', '1')->first();
        $apiKey = $additionalsettings->google_api;

        $url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=$lat,$lng&key=$apiKey";
        $response = file_get_contents($url);
        $jsonData = json_decode($response);

        $longNamesWithTypes = []; 
        $cityName = '';          

        if ($jsonData->status == "OK" && isset($jsonData->results[0])) {
            $addressComponents = $jsonData->results[0]->address_components ?? [];
            foreach ($addressComponents as $component) {
                if (isset($component->long_name) && isset($component->types)) {
                    $longNamesWithTypes[] = [
                        'long_name' => $component->long_name,
                        'types'     => $component->types
                    ];
                }
                if (isset($component->types) && in_array('locality', $component->types)) {
                    $cityName = $component->long_name;
                }
            }
        }

        $city = DB::table('tbl_cities')->where('name', $cityName)->first();
        $cityId = $city->city_id??"no city id";
        $cookieData = [
            'lat'        => $lat,
            'lng'        => $lng,
            'city_name'  => $cityName,
            'long_names' => $longNamesWithTypes,
            'city_id'    => $cityId
        ];

        Cookie::queue('current_location', json_encode($cookieData), 60 * 24 * 7);

        return [
            'source'      => 'google',
            'city_id'     => $cityId,
            'lat'         => $lat,
            'lng'         => $lng,
            'city_name'   => $cityName,
            'long_names'  => $longNamesWithTypes
        ];
    }
}




function cookiescity() {
    if (Cookie::has('current_location')) {
        $cookieData = json_decode(Cookie::get('current_location'), true);
        return $cookieData['city_id'];
    } 
}

if (!function_exists('getSettingsLocation')) {
    function getSettingsLocation() {
        $settings = DB::table('additionalsettings')->where('id', 1)->first();

        return [
            'latitude'  => $settings->latitude ?? null,
            'longitude' => $settings->longitude ?? null,
        ];
    }
}

if (!function_exists('getDisplayLocation')) {
    function getDisplayLocation()
    {
        $displayName = 'Select Location';

        if (Cookie::has('current_location')) {
            $cookieData = json_decode(Cookie::get('current_location'), true);

            if (!empty($cookieData['display_name'])) {
                $displayName = $cookieData['display_name'];
            } 
            elseif (!empty($cookieData['long_names']) && is_array($cookieData['long_names'])) {
                $parts = [];
                foreach ($cookieData['long_names'] as $component) {
                    $types = $component['types'] ?? [];
                    $name = $component['long_name'] ?? '';

                    // Common types include
                    $includeTypes = [
                        'street_number',
                        'route',
                        'locality',
                        'administrative_area_level_3',
                        'administrative_area_level_2',
                        'administrative_area_level_1',
                        'country',
                        'postal_code'
                    ];

                    if (!empty($name) && count(array_intersect($types, $includeTypes)) > 0) {
                        $parts[] = $name;
                    }
                }

                $parts = array_unique($parts);
                $displayName = implode(', ', $parts);
            } 
          
            elseif (!empty($cookieData['address']) && is_array($cookieData['address'])) {
                $addr = $cookieData['address'];
                $parts = [
                    $addr['road'] ?? null,
                    $addr['residential'] ?? null,
                      $cookieData['city_name'] ?? null,  
                      $addr['pincode'] ?? null,  
                    //   $addr['formatted'] ?? null,  
                    $addr['city'] ?? $addr['town'] ?? $addr['village'] ?? null,
                    $addr['state'] ?? null,
                    $addr['postcode'] ?? null,
                    $addr['country'] ?? null
                ];

                $parts = array_filter($parts);
                $displayName = implode(', ', $parts);
            }
        }

        return $displayName;
    }
}



//search helper function



  function handleSearch(Request $request)
{

   
    if ($request->has('latitude') && $request->has('longitude')) {

        $latitude = $request->get('latitude');
        $longitude = $request->get('longitude');
        $formattedAddress = urldecode($request->get('address', ''));

        $additionalsettings = Additionalsetting::where('id', 1)->first();
        $apiKey = $additionalsettings->google_api;


        $url = "https://maps.googleapis.com/maps/api/geocode/json?latlng={$latitude},{$longitude}&key={$apiKey}";
        $response = @file_get_contents($url);
        $data = json_decode($response, true);

        if (isset($data['status']) && $data['status'] == 'OK') {
            $results = $data['results'][0];
            $addressComponents = $results['address_components'];

            $city = $state = $country = $pincode = $area = $tehsil = "";

            foreach ($addressComponents as $component) {
                $types = $component['types'];

                if (in_array('locality', $types)) $city = $component['long_name'];
                if (in_array('administrative_area_level_2', $types)) $tehsil = $component['long_name'];
                if (in_array('administrative_area_level_1', $types)) $state = $component['long_name'];
                if (in_array('country', $types)) $country = $component['long_name'];
                if (in_array('postal_code', $types)) $pincode = $component['long_name'];
                if (in_array('sublocality_level_1', $types)) $area = $component['long_name'];
            }

          
            $cityRecord = DB::table('tbl_cities')->where('name', $city)->first();
             $cityId = $cityRecord->city_id ?? 0;

          
            $cookieData = [
                'city_name' => $city,
                'city_id'   => $cityId,
                'address'   => [
                    'formatted' => $formattedAddress,
                    'lat'       => $latitude,
                    'lng'       => $longitude,
                    'area'      => $area,
                    'tehsil'    => $tehsil,
                    'state'     => $state,
                    'country'   => $country,
                    'pincode'   => $pincode,
                ]
            ];
            Cookie::queue('current_location', json_encode($cookieData), 60 * 24 * 30);

          return [
           'status' => 'success',
           'city_id' => $cityId,
           'city_name' => $city,
           'address' => $cookieData['address']
];

        } else {
            return response()->json(['status' => 'error', 'message' => 'Error fetching location']);
        }
    }

   
  
}

function submithandleSearch( Request $request){
 
    if ($request->has('address')) {
        
        $address = urlencode($request->get('address'));
       
        $additionalsettings = Additionalsetting::where('id', 1)->first();
        $apiKey = $additionalsettings->google_api;

        $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";
        $response = @file_get_contents($url);
        $data = json_decode($response, true);

        $latitude = $longitude = 0;
        $city = $state = $country = $pincode = $area = $tehsil = "";

        if (isset($data['results'][0])) {
            $result = $data['results'][0];
            $latitude = $result['geometry']['location']['lat'] ?? 0;
            $longitude = $result['geometry']['location']['lng'] ?? 0;
            $formattedAddress = $result['formatted_address'] ?? '';

            $addressComponents = $result['address_components'] ?? [];

            foreach ($addressComponents as $component) {
                $types = $component['types'];
                if (in_array('locality', $types)) $city = $component['long_name'];
                if (in_array('administrative_area_level_2', $types)) $tehsil = $component['long_name'];
                if (in_array('administrative_area_level_1', $types)) $state = $component['long_name'];
                if (in_array('country', $types)) $country = $component['long_name'];
                if (in_array('postal_code', $types)) $pincode = $component['long_name'];
                if (in_array('sublocality_level_1', $types)) $area = $component['long_name'];
            }
        }

        $cityRecord = DB::table('tbl_cities')->where('name', $city)->first();
        $cityId = $cityRecord->city_id ?? 0;

        $cookieData = [
            'city_name' => $city,
            'city_id'   => $cityId,
            'address'   => [
                'formatted' => $formattedAddress,
                'lat'       => $latitude,
                'lng'       => $longitude,
                'area'      => $area,
                'tehsil'    => $tehsil,
                'state'     => $state,
                'country'   => $country,
                'pincode'   => $pincode,
            ],
        ];

        Cookie::queue('current_location', json_encode($cookieData), 60 * 24 * 30);

       return [
        'status' => 'success',
        'city_id' => $cityId,
        'city_name' => $city,
        'address' => $cookieData['address']
];

    }
}







