<?php

use Illuminate\Support\Facades\Cookie;
use App\Models\Service;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use App\Models\Subservice;

use App\Models\Serviceallottedcity;
use App\Models\Tbl_Product;
use App\Models\ChildService;
use App\Models\ServicePlan;

if (!function_exists('headerdata')) {
    function headerdata()
    {
        $cityid ='';

        $cookieData = Cookie::get('current_location');

        if (!empty($cookieData)) {
            $decoded = json_decode($cookieData, true);
            if (!empty($decoded['city_id'])) {   
                $cityid = $decoded['city_id'];
            }
        }

        $service = Service::join('serviceallottedcities as sac', 'sac.serviceid', '=', 'services.id')
            ->where('services.status', '1')
            ->where('sac.city_id', $cityid)
            ->where('sac.status', '1')
            ->where('sac.service_type', '1')
            ->select('services.title', 'services.slug')
            ->get();

        return $service;
    }
}


if (!function_exists('getCurrentPageSlug')) {
    function getCurrentPageSlug()
    {
        $fullUrl = url()->current();
        $path = parse_url($fullUrl, PHP_URL_PATH);
        $segments = explode('/', trim($path, '/'));
        $slug = end($segments);

        return $slug;
    }
}


//ajax se page id pass function//

if (!function_exists('ajaxpgreload')) {
    function ajaxpgreload(){
        
        $currentUrl = url()->current(); 
        $path = parse_url($currentUrl, PHP_URL_PATH); 
        $segments = explode('/', trim($path, '/'));
        $firstSegment = '/' . ($segments[0] ?? '');
        $record = DB::table('pages')->where('page_url', $firstSegment)->first();

        return $record->page_id ?? null;
    }
}


//service details page me clid service or service paln product code 

if (!function_exists('servicesubservices')) {
    function servicesubservices($slug = null)
    {
        $cityid = cookiescity();
        $service = Service::where('slug', $slug)->where('status','1')->first();

        

        if (!$service) return collect();

        return \App\Models\Serviceallottedcity::join('subservices', 'subservices.id', '=', 'serviceallottedcities.serviceid')
            ->where('subservices.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('subservices.service_id', $service->id)
            ->where('serviceallottedcities.service_type', '2')
            ->select('subservices.*', 'serviceallottedcities.id as allot_id')
            ->get();
    }
}



if (!function_exists('singleserviceidproduct')) {
    function singleserviceidproduct($slug = null)
    {
        $cityid = cookiescity();
        $service = Service::where('slug', $slug)->where('status','1')->first();

        if (!$service) return collect();

         return \App\Models\Serviceallottedcity::join('tbl__products', 'tbl__products.id', '=', 'serviceallottedcities.serviceid')
            ->where('tbl__products.service_id', $service->id)
            ->where('tbl__products.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '5')
            ->inRandomOrder()
            ->get();
    }
}


//service-details page code function me bhi ajax ke function se hi aa rha hai


if (!function_exists('getServiceDetailsBySlug')) {
    function getServiceDetailsBySlug($slug = null)
    {
        $slug = trim($slug);
        if (!$slug) return null;

        $subservice = \App\Models\Subservice::where('slug', $slug)->where('status', '1')->first();
        $serviceplan = DB::table('service_plans')->where('slug', $slug)->first();
        $service = $subservice ? \App\Models\Service::where('id', $subservice->service_id)->first() : null;

        return [
            'subservice'        => $subservice,
            'service'           => $service,
            'plan_service'      => $serviceplan->service_id ?? null,
            'plan_childservice'      => $serviceplan->childservice_id ?? null,
            'plan_subservice'   => $serviceplan->subservice_id ?? null,
            'subservice_id'     => $subservice->id ?? null,
            'service_id'        => $subservice->service_id ?? null,
        ];
    }
}







if (!function_exists('relatedserviceplan')) {
    function relatedserviceplan($slug = null)
    {
        $cityid = cookiescity();
        $details = getServiceDetailsBySlug($slug);

        if (!$details) return collect();  

        $service_id = $details['service_id'] ?? $details['plan_service'];
        $subservice_id = $details['subservice_id'] ?? $details['plan_subservice'];
        $plan_childservice = $details['plan_childservice'] ?? null;

        if (!$service_id || !$subservice_id || !$plan_childservice) {
            return collect();
        }
        return \App\Models\Serviceallottedcity::join('service_plans','service_plans.id','=','serviceallottedcities.serviceid')
            ->where('service_plans.status', '1')
            ->where('service_plans.subservice_id', $subservice_id)
            ->where('service_plans.service_id', $service_id)
            ->where('service_plans.childservice_id', $plan_childservice)
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '4')
            ->get();
    }
}






if (!function_exists('childservice')) {
    function childservice($slug = null)
    {
        $cityid = cookiescity();
        $details = getServiceDetailsBySlug($slug);

        if (!$details) return collect();  

        $service_id = $details['service_id'] ?? $details['plan_service'];
        $subservice_id = $details['subservice_id'] ?? $details['plan_subservice'];

        if (!$service_id || !$subservice_id) return collect();

        return \App\Models\Serviceallottedcity::join(
                'child_services',
                'child_services.id',
                '=',
                'serviceallottedcities.serviceid'
            )
            ->where('child_services.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '3')
            ->where('child_services.service_id', $service_id)
            ->where('child_services.subservice_id', $subservice_id)
            ->get();
    }
}



if (!function_exists('serviceplans')) {
    function serviceplans($slug = null)
    {
        $cityid = cookiescity();
        $details = getServiceDetailsBySlug($slug);

        if (!$details) return collect(); 

        $service_id = $details['service_id'] ?? $details['plan_service'];
        $subservice_id = $details['subservice_id'] ?? $details['plan_subservice'];

        if (!$service_id || !$subservice_id) return collect();

        return \App\Models\Serviceallottedcity::join(
                'service_plans',
                'service_plans.id',
                '=',
                'serviceallottedcities.serviceid'
            )
            ->where('service_plans.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '4')
            ->where('service_plans.service_id', $service_id)
            ->where('service_plans.subservice_id', $subservice_id)
            ->get();
    }
}


if (!function_exists('serviceproducts')) {
    function serviceproducts($slug = null)
    {
        $cityid = cookiescity();
        $details = getServiceDetailsBySlug($slug);

        if (!$details) return collect();  

        $service_id = $details['service_id'] ?? $details['plan_service'];
        $subservice_id = $details['subservice_id'] ?? $details['plan_subservice'];

        if (!$service_id || !$subservice_id) return collect();

        return \App\Models\Serviceallottedcity::join('tbl__products','tbl__products.id','=','serviceallottedcities.serviceid')
            ->where('tbl__products.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '5')
            ->where('tbl__products.service_id', $service_id)->where('tbl__products.subservice_id', $subservice_id) ->inRandomOrder()->get();
    }
}




//search query work

if (!function_exists('searchData')) {
    function searchData($query)
    {
        $cityid = cookiescity();
        // ===== SERVICES =====
        $services = DB::table('serviceallottedcities')
            ->join('services', 'services.id', '=', 'serviceallottedcities.serviceid')
            ->where('services.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '1')
            ->where('services.title', 'like', '%' . $query . '%')
            ->select('services.*')
            ->get();

        // ===== PLANS =====
        $plans = DB::table('serviceallottedcities')
            ->join('service_plans', 'service_plans.id', '=', 'serviceallottedcities.serviceid')
            ->where('service_plans.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '4')
            ->where('service_plans.title', 'like', '%' . $query . '%')
            ->select('service_plans.*')
            ->get();

        // ===== PRODUCTS =====
        $products = DB::table('serviceallottedcities')
            ->join('tbl__products', 'tbl__products.id', '=', 'serviceallottedcities.serviceid')
            ->where('tbl__products.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '5')
            ->where('tbl__products.product_item', 'like', '%' . $query . '%')
            ->select('tbl__products.*')
            ->get();

         return [
            'query' => $query,
            'services' => $services,
            'plans' => $plans,
            'products' => $products,
        ];
    }
}


